% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_karabatsos2004.R
\docType{data}
\name{karabatsos2004}
\alias{karabatsos2004}
\title{Data: Item Responses Theory (Karabatsos & Sheu, 2004)}
\format{A list with 4 matrices:
\describe{
  \item{\code{k.M}: }{Number of correct responses for participants with rest scores
      j=0,...,5 (i.e., the sum score minus the score for item i)}
  \item{\code{n.M}: }{Total number of participants for each cell of matrix \code{k.M}}
  \item{\code{k.IIO}: }{Number of correct responses for participants with sum scores j=0,...,6}
  \item{\code{n.IIO}: }{Total number of participants for each cell of matrix \code{k.IIO}}
}}
\usage{
karabatsos2004
}
\description{
The test was part of the 1992 Trial State Assessment in Reading at
Grade 4, conducted by the National Assessments of Educational Progress (NAEP).
}
\examples{
data(karabatsos2004)
head(karabatsos2004)

######################################################
##### Testing Monotonicity (M)                   #####
##### (Karabatsos & Sheu, 2004, Table 3, p. 120) #####

IJ <- dim(karabatsos2004$k.M)
monotonicity <- nirt_to_Ab(IJ[1], IJ[2], axioms = "W1")
p <- sampling_binom(k = c(karabatsos2004$k.M),
                    n = c(karabatsos2004$n.M),
                    A = monotonicity$A, b = monotonicity$b,
                    prior = c(.5, .5), M = 300)

# posterior means (Table 4, p. 120)
post.mean <- matrix(apply(p, 2, mean), IJ[1],
                    dimnames = dimnames(karabatsos2004$k.M))
round(post.mean, 2)

# posterior predictive checks (Table 4, p. 121)
ppp <- ppp_binom(p, c(karabatsos2004$k.M), c(karabatsos2004$n.M),
                 by = 1:prod(IJ))
ppp <- matrix(ppp[,3], IJ[1], dimnames = dimnames(karabatsos2004$k.M))
round(ppp, 2)


######################################################
##### Testing invariant item ordering (IIO)      #####
##### (Karabatsos & Sheu, 2004, Table 6, p. 122) #####

IJ <- dim(karabatsos2004$k.IIO)
iio <- nirt_to_Ab(IJ[1], IJ[2], axioms = "W2")
p <- sampling_binom(k = c(karabatsos2004$k.IIO),
                    n = c(karabatsos2004$n.IIO),
                    A = iio$A, b = iio$b,
                    prior = c(.5, .5), M = 300)
# posterior predictive checks (Table 6, p. 122)
ppp <- ppp_binom(prob = p, k = c(karabatsos2004$k.IIO),
                 n = c(karabatsos2004$n.IIO), by = 1:prod(IJ))
matrix(ppp[,3], 7, dimnames = dimnames(karabatsos2004$k.IIO))

# for each item:
ppp <- ppp_binom(p, c(karabatsos2004$k.IIO), c(karabatsos2004$n.IIO),
                 by = rep(1:IJ[2], each = IJ[1]))
round(ppp[,3], 2)
}
\references{
Karabatsos, G., & Sheu, C.-F. (2004). Order-constrained Bayes inference for dichotomous models of unidimensional nonparametric IRT. Applied Psychological Measurement, 28(2), 110-125. \url{https://doi.org/10.1177/0146621603260678}
}
\seealso{
The polytope for the nonparametric item response theory can be obtained
    using (see \code{\link{nirt_to_Ab}}).
}
\keyword{datasets}
