% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multioccbuild.R
\name{multioccbuild}
\alias{multioccbuild}
\title{This function creates model.input for the GibbsSampler() function}
\usage{
multioccbuild(detection, occupancy, coords, DataNames, threshold)
}
\arguments{
\item{detection}{A data frame that has one row for every site X season X survey combination.
Must contain columns exactly named 'site', 'season', and 'survey' within season.
Must also contain all covaraites in the detection process of the model, and binary indicators of detections for all species
to be modeled.  It is permissible for this data frame to have columns for species and/or variables
that will not be used in model.}

\item{occupancy}{A data frame that is one row for every site x season combination.
Must contain columns for the 'site' and 'season', and these must be named 'site' and 'season' exactly.
Also must contain all covariates to be used in the latent occupancy process of the model.
It is permissible for this data frame to have columns for species and/or variables
that will not be used in model.}

\item{coords}{A data frame that is one row for every site included in the study.
Contains columns for the 'site', and location coordinates x and y.
These are used to output the adjacency matrix A based on Euclidean distance threshold the user provides
as an input in the 'DataNames' argument.}

\item{DataNames}{A list with elements "species", "detection", and "occupancy"
DataNames$species is a vector with the name of every species to be included in the model.  Must be a subset of names of columns of 'detection'.
DataNames$detection is a vector with the names of the detection covariates to be included in the model.  These names must be a subset of column names of 'detection'.
DataNames$occupancy is a vector with the names of the occupancy covariates to be included in the model.  These names must be a subset of column names of 'occupancy'.

This list 'DataNames' is required because it:
(1) allows for modeling subsets of species and/or variables in varioys input data frames, which means the user does not need to modify either data frame for different runs of the model.
(2) this list also determines the order of covariates in X and W.}

\item{threshold}{The distance which determines if two locations are neighbors
in the adjacency matrix or not.  This threshold is the Euclidean distance based on the x and y coordinates input in 'coords'.}
}
\value{
model.input a list with
\itemize{
\item DataNames, the list with elements "species", "detection", and "occupancy".
\item X, the design matrix for occupancy.  Contains a column of 1s for the intercept, and one column for each variable in names$occupancy.
\item W, design matrix for detection.  Contains a column of 1s for the intercept, and one column for each variable in names$detection.
\item y, observed occupancy data.  Contains one column for each species listed in names$species.
\item A, the adjacency matrix containing either a 0 or 1 indicating if two locations are neighbors based on their distances and the 'threshold' argument.
\item detection.info, details for detection.
\item occupancy.info, details for occupancy.
}
}
\description{
This function creates model.input for the GibbsSampler() function
}
