% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleOutcomes.R
\name{multipleOutcomes}
\alias{multipleOutcomes}
\title{Fitting Regression Models for Multiple Outcomes and Returning the Matrix of
Covariance}
\usage{
multipleOutcomes(..., family, data, data_index = NULL, score_epsilon = 1e-06)
}
\arguments{
\item{...}{formulas of models to be fitted.}

\item{family}{a character vector of families to be used in the models.
Currently only \code{gaussian} and \code{binomial} are supported. \code{cox} for time-to-event
data with potential censoring and \code{long} for longitudinal data may be supported
in the future. \code{family} can be of length 1 if all models are fitted in the
same family; otherwise family should be specified for each of the models in \code{...}.}

\item{data}{a data frame if all models are fitted on the same dataset;
otherwise a list of data frames for fitting models in \code{...}. Note that a
dataset can be used to fit multiple models, thus, \code{length(data)} is unnecessary
to be equal to the number of models in \code{...}. The row names in a data frame
are treated as sample IDs. Consequently, for any two records in different
data frames that correspond to the same sample, their row names should be
consistent.}

\item{data_index}{\code{NULL} if \code{data} is a data frame; otherwise, a vector in
integer specifying mapping a model in \code{...} to a data frame in \code{data} (a list).}

\item{score_epsilon}{whatever.}
}
\value{
It returns an object of class "multipleOutcomes", which is a list
containing the following components:
\tabular{ll}{
\code{coefficients} \tab an unnamed vector of coefficients of all fitted models.
Use \code{id_map} for variable mapping. \cr
\tab \cr
\code{mcov} \tab a unnamed matrix of covariance of \code{coefficients}. Use \code{id_map}
for variable mapping. \cr
\tab \cr
\code{id_map} \tab a list mapping the elements in \code{coefficients} and \code{mcov} to
variable names. \cr
\tab \cr
\code{n_shared_sample_sizes} \tab a matrix of shared sample sizes between datasets
being used to fit the models. \cr
\tab \cr
\code{call} \tab the matched call.\cr
}
}
\description{
Fitting Regression Models for Multiple Outcomes and Returning the Matrix of
Covariance
}
\examples{
## More examples can be found in the vignettes.
library(mvtnorm)
genData <- function(seed = NULL){

  set.seed(seed)
  n <- 400
  sigma <- matrix(c(1, .6, .6, 1), 2)
  x <- rmvnorm(n, sigma = sigma)
  gam <- c(.1, -.2)
  z <- rbinom(n, 1, plogis(1-1/(1+exp(-.5+x\%*\%gam+.1*rnorm(n)))))

  bet <- c(-.2,.2)
  #y <- rbinom(n, 1, plogis(1-1/(1+exp(-.5+x\%*\%bet + .2*z-.3*rnorm(n)))))
  y <- -.5+x\%*\%bet + .2*z-.3*rnorm(n)

  data.frame(y = y, z = z, x1 = x[, 1], x2 = x[, 2])

}

dat <- genData(123456)
dat1 <- head(dat,200)
dat2 <- tail(dat,200)
## fitting four models simultaneously.
fit <-
  multipleOutcomes(
    y ~ z + x1 - 1,
    z ~ x1 + x2,
    z ~ x1 - 1,
    y ~ x2,
    ## z can be fitted with a linear or logistic regression
    family = c('gaussian', 'binomial', 'gaussian','gaussian'),
    data = list(dat1, dat2),
    ## each dataset is used to fit two models
    data_index = c(1, 1, 2, 2)
  )

  ## unnamed coefficients of all model parameters
  coef(fit)

  ## named coefficients of a specific model
  coef(fit, 2)

  ## unnamed covariance matrix of all model parameters
  vcov(fit)

  ## named covariance matrix of a specific model
  vcov(fit, 1)

  ## summary of all parameter estimates
  summary(fit)

  ## summary of parameters in a specific model
  summary(fit, 4)

}
