\name{dichot}
\alias{dichot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Dichotomize data with a cutoff value
}
\description{
Function to dichotomize the input data for the semigroup construction with a cutoff value.
}
\usage{
dichot(x, c = 1, diag)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
   some data in a numeric form (usually arrays)
}
  \item{c}{
   the cutoff value to perform the dichotomization (default \code{1})
}
  \item{diag}{
  (optional and logical) whether or not the diagonals should be included (default \code{TRUE})
}
}
\details{
This is a convenient function (or wrapper if you like) of the \code{\link[base:replace]{replace}} function. 
In this case, the function is aimed to specify a cutoff value for the dichotomization of the data where the values equal or higher to the cutoff are converted to one, while the others are set to zero. The cutoff can be any real number.
}
\value{
Binary values of the input data.
}
%\references{
%No hay...
%}
\author{
Antonio Rivero Ostoic
}
\note{
The labels are preserved after the dichotomization.
}
%% ~Make other sections like Warning with \section{Warning }{....} ~
\seealso{
\code{\link[base:replace]{replace}}, \code{\link{prev}}, \code{\link{semigroup}}.
}
\examples{
## Create the data: 2 binary relations among 3 elements
arr <- round( replace( array(runif(18), c(3,3,2)), array(runif(18),
       c(3,3,2))>.5, 3 ) )

## dichotomize it with a cutoff value of 2
dichot(arr, c = 2)
}
\keyword{ manip }
%
