% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxpath.R
\name{multiview.cox.fit}
\alias{multiview.cox.fit}
\title{Fit a Cox regression model with elastic net regularization for a single
value of lambda}
\usage{
multiview.cox.fit(
  x_list,
  x,
  y,
  rho,
  weights,
  lambda,
  alpha = 1,
  offset = rep(0, nobs),
  thresh = 1e-10,
  maxit = 1e+05,
  penalty.factor = rep(1, nvars),
  exclude = c(),
  lower.limits = -Inf,
  upper.limits = Inf,
  warm = NULL,
  from.cox.path = FALSE,
  save.fit = FALSE,
  trace.it = 0
)
}
\arguments{
\item{x_list}{a list of \code{x} matrices with same number of rows
\code{nobs}}

\item{x}{the \code{cbind}ed matrices in \code{x_list}}

\item{y}{the quantitative response with length equal to \code{nobs}, the
(same) number of rows in each \code{x} matrix}

\item{rho}{the weight on the agreement penalty, default 0. \code{rho=0}
is a form of early fusion, and \code{rho=1} is a form of late fusion.
We recommend trying a few values of \code{rho} including 0, 0.1, 0.25,
0.5, and 1 first; sometimes \code{rho} larger than 1 can also be
helpful.}

\item{weights}{observation weights. Can be total counts if
responses are proportion matrices. Default is 1 for each
observation}

\item{lambda}{A single value for the \code{lambda} hyperparameter.}

\item{alpha}{The elasticnet mixing parameter, with
\eqn{0\le\alpha\le 1}.  The penalty is defined as
\deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.}
\code{alpha=1} is the lasso penalty, and \code{alpha=0} the ridge
penalty.}

\item{offset}{A vector of length \code{nobs} that is included in
the linear predictor (a \code{nobs x nc} matrix for the
\code{"multinomial"} family).  Useful for the \code{"poisson"}
family (e.g. log of exposure time), or for refining a model by
starting at a current fit. Default is \code{NULL}. If supplied,
then values must also be supplied to the \code{predict} function.}

\item{thresh}{Convergence threshold for coordinate descent. Each
inner coordinate-descent loop continues until the maximum change
in the objective after any coefficient update is less than
\code{thresh} times the null deviance. Defaults value is
\code{1E-7}.}

\item{maxit}{Maximum number of passes over the data for all lambda
values; default is 10^5.}

\item{penalty.factor}{Separate penalty factors can be applied to
each coefficient. This is a number that multiplies \code{lambda}
to allow differential shrinkage. Can be 0 for some variables,
which implies no shrinkage, and that variable is always included
in the model. Default is 1 for all variables (and implicitly
infinity for variables listed in \code{exclude}). Note: the
penalty factors are internally rescaled to sum to nvars, and the
lambda sequence will reflect this change.}

\item{exclude}{Indices of variables to be excluded from the
model. Default is none. Equivalent to an infinite penalty factor
for the variables excluded (next item).  Users can supply instead
an \code{exclude} function that generates the list of indices.  This
function is most generally defined as \verb{function(x_list, y, ...)},
and is called inside \code{multiview} to generate the indices for
excluded variables.  The \code{...} argument is required, the others
are optional.  This is useful for filtering wide data, and works
correctly with \code{cv.multiview}. See the vignette 'Introduction'
for examples.}

\item{lower.limits}{Vector of lower limits for each coefficient;
default \code{-Inf}. Each of these must be non-positive. Can be
presented as a single value (which will then be replicated), else
a vector of length \code{nvars}}

\item{upper.limits}{Vector of upper limits for each coefficient;
default \code{Inf}. See \code{lower.limits}}

\item{warm}{Either a \code{glmnetfit} object or a list (with names \code{beta}
and \code{a0} containing coefficients and intercept respectively) which can
be used as a warm start. Default is \code{NULL}, indicating no warm start.
For internal use only.}

\item{from.cox.path}{Was \code{multiview.cox.fit()} called from \code{multiview.path()}?
Default is FALSE.This has implications for computation of the penalty factors.}

\item{save.fit}{Return the warm start object? Default is FALSE.}

\item{trace.it}{If \code{trace.it=1}, then a progress bar is
displayed; useful for big models that take a long time to fit.}
}
\value{
An object with class "coxnet", "glmnetfit" and "glmnet". The list
returned contains more keys than that of a "glmnet" object.
\item{a0}{Intercept value, \code{NULL} for "cox" family.}
\item{beta}{A \code{nvars x 1} matrix of coefficients, stored in sparse matrix
format.}
\item{df}{The number of nonzero coefficients.}
\item{dim}{Dimension of coefficient matrix.}
\item{lambda}{Lambda value used.}
\item{dev.ratio}{The fraction of (null) deviance explained. The deviance
calculations incorporate weights if present in the model. The deviance is
defined to be 2*(loglike_sat - loglike), where loglike_sat is the log-likelihood
for the saturated model (a model with a free parameter per observation).
Hence dev.ratio=1-dev/nulldev.}
\item{nulldev}{Null deviance (per observation). This is defined to be
2*(loglike_sat -loglike(Null)). The null model refers to the 0 model.}
\item{npasses}{Total passes over the data.}
\item{jerr}{Error flag, for warnings and errors (largely for internal
debugging).}
\item{offset}{A logical variable indicating whether an offset was included
in the model.}
\item{call}{The call that produced this object.}
\item{nobs}{Number of observations.}
\item{warm_fit}{If \code{save.fit=TRUE}, output of C++ routine, used for
warm starts. For internal use only.}
\item{family}{Family used for the model, always "cox".}
\item{converged}{A logical variable: was the algorithm judged to have
converged?}
\item{boundary}{A logical variable: is the fitted value on the boundary of
the attainable values?}
\item{obj_function}{Objective function value at the solution.}
}
\description{
Fit a Cox regression model via penalized maximum likelihood for a single
value of lambda. Can deal with (start, stop] data and strata, as well as
sparse design matrices.
}
\details{
WARNING: Users should not call \code{multiview.cox.fit} directly. Higher-level
functions in this package call \code{multiview.cox.fit} as a subroutine. If a
warm start object is provided, some of the other arguments in the function
may be overriden.

\code{multiview.cox.fit} solves the elastic net problem for a single, user-specified
value of lambda. \code{multiview.cox.fit} works for Cox regression models, including
(start, stop] data and strata. It solves the problem using iteratively
reweighted least squares (IRLS). For each IRLS iteration, \code{multiview.cox.fit}
makes a quadratic (Newton) approximation of the log-likelihood, then calls
\code{elnet.fit} to minimize the resulting approximation.

In terms of standardization: \code{multiview.cox.fit} does not standardize \code{x}
and \code{weights}. \code{penalty.factor} is standardized so that they sum
up to \code{nvars}.
}
