% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca}
\alias{pca}
\title{PCA for Data Scatter Matrix}
\usage{
pca(data, var.amnt = 0.9, ...)
}
\arguments{
\item{data}{A centred-and-scaled data matrix or xts matrix}

\item{var.amnt}{The energy proportion to preserve in the projection, which
dictates the number of principal components to keep. Defaults to 0.90.}

\item{...}{Lazy dots for additional internal arguments}
}
\value{
A list of class "pca" with the following:
\itemize{
  \item{projectionMatrix -- }{the q eigenvectors corresponding to the q
    largest eigenvalues as a p x q projection matrix}
  \item{LambdaInv -- }{the diagonal matrix of inverse eigenvalues}
  \item{SPE -- }{the vector of SPE test statistic values for each of the n
    observations contained in "data"}
  \item{T2 -- }{the vector of Hotelling's T2 test statistic for each of the
    same n observations}
}
}
\description{
Calculate the principal component analysis for a data matrix,
  and also find the squared prediction error (SPE) and Hotelling's T2 test
  statistic values for each observation in this data matrix.
}
\details{
This function takes in a training data matrix, without the label
  column, and the energy preservation proportion, which defaults to 95
  percent per Kazor et al (2016). This proportion is the sum of the q largest
  eigenvalues divided by the sum of all p eigenvalues, where q is the number
  of columns of the p x q projection matrix P. This function then returns the
  projection matrix P, a diagonal matrix of the reciprocal eigenvalues
  (LambdaInv), a vector of the SPE test statistic values corresponding to the
  rows of the data matrix, and a T2 test statistic vector similar to the SPE
  vector.

  This internal function is called by faultFilter().
}
\examples{
nrml <- mspProcessData(faults = "NOC")
scaledData <- scale(nrml[,-1])
pca(scaledData)

}
\seealso{
Called by: \code{\link{faultFilter}}.
}
