% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rExtremalStudentPar.R
\name{rExtremalStudentParetoProcess}
\alias{rExtremalStudentParetoProcess}
\title{Simulation of extremal Student generalized Pareto vectors}
\usage{
rExtremalStudentParetoProcess(n, Sigma, nu, normalize = FALSE,
  matchol = NULL)
}
\arguments{
\item{n}{sample size}

\item{Sigma}{correlation matrix}

\item{nu}{degrees of freedom parameter}

\item{normalize}{logical; should unit Pareto samples above \eqn{\kappa} be returned?}

\item{matchol}{Cholesky matrix \eqn{\mathbf{A}}{A} such that \eqn{\mathbf{A}\mathbf{A}^\top = \boldsymbol{\Sigma}}{AA^t = \Sigma}. Corresponds to \code{t(chol(Sigma))}. Default to \code{NULL}, in which case the Cholesky root is computed within the function.}
}
\description{
The algorithm is described in section 4 of Thibaud and Opitz. It uses the Cholesky decomposition of the matrix \code{Sigma}
to generate samples on the unit sphere and an accept-reject algorithm to decide which samples to retain. If \code{normalize = TRUE} (the default), 
the vector is scaled by the exponent measure \eqn{\kappa} so that the maximum of the sample is greater than \eqn{\kappa}.
}
\examples{
loc <- expand.grid(1:4, 1:4)
Sigma <- exp(-as.matrix(dist(loc))^1.5)
rExtremalStudentParetoProcess(1000, Sigma, nu = 2)
}
\references{
Thibaud, E. and T. Opitz (2015). Efficient inference and simulation for elliptical Pareto processes. Biometrika, 102(4), 855-870.
}
\author{
Emeric Thibaud, Leo Belzile
}
