% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_branch.R
\name{filter_branch}
\alias{filter_branch}
\title{Create a new filter branch.}
\usage{
filter_branch(..., name = NULL)
}
\arguments{
\item{...}{branch definition expressions.}

\item{name}{Name for the new filter.}
}
\value{
a filter_branch object.
}
\description{
Create a new filter branch.
}
\examples{
# Define a filter branch.
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  !Name \%in\% c("Katrina"),
  !Name \%in\% c("Katrina"),
  TRUE # include all
)
# Create a mverse and add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_filter_branch(hurricane_outliers)
}
\seealso{
Other filter branch functions: 
\code{\link{add_filter_branch}()}
}
\concept{filter branch functions}
