% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_curve.R
\name{spec_curve}
\alias{spec_curve}
\alias{spec_curve.lm_mverse}
\alias{spec_curve.glm_mverse}
\alias{spec_curve.glm.nb_mverse}
\title{Display a specification curve across the multiverse.}
\source{
Uri Simonsohn, Joseph P. Simmons, and Leif D. Nelson. (2020).
“Specification curve analysis” \emph{Nature Human Behaviour},
4, 1208–14. \doi{10.1038/s41562-020-0912-z}
}
\usage{
spec_curve(.object, var, ...)

\method{spec_curve}{lm_mverse}(
  .object,
  var,
  conf.int = TRUE,
  conf.level = 0.95,
  option = names(multiverse::parameters(.object)),
  universe_order = FALSE,
  color_order = FALSE,
  color = NULL,
  branch_order = NULL,
  point_size = 0.25,
  grid_size = 2,
  point_alpha = 1,
  brewer_palette = "Set2",
  yaxis_text_size = 8,
  ...
)

\method{spec_curve}{glm_mverse}(
  .object,
  var,
  conf.int = TRUE,
  conf.level = 0.95,
  option = names(multiverse::parameters(.object)),
  universe_order = FALSE,
  color_order = FALSE,
  color = NULL,
  branch_order = NULL,
  point_size = 0.25,
  grid_size = 2,
  point_alpha = 1,
  brewer_palette = "Set2",
  yaxis_text_size = 8,
  ...
)

\method{spec_curve}{glm.nb_mverse}(
  .object,
  var,
  conf.int = TRUE,
  conf.level = 0.95,
  option = names(multiverse::parameters(.object)),
  universe_order = FALSE,
  color_order = FALSE,
  color = NULL,
  branch_order = NULL,
  point_size = 0.25,
  grid_size = 2,
  point_alpha = 1,
  brewer_palette = "Set2",
  yaxis_text_size = 8,
  ...
)
}
\arguments{
\item{.object}{a \code{glm.nb_mverse} object.}

\item{var}{name for the variable to show.}

\item{...}{ignored.}

\item{conf.int}{when \code{TRUE} (default), the estimate output
includes the confidence intervals.}

\item{conf.level}{the confidence level of the confidence interval
returned using \code{conf.int = TRUE}. Default value is 0.95.}

\item{option}{a vector of branches to show the options included.}

\item{universe_order}{when \code{TRUE}, order the universes according to
the order in the summary table.}

\item{color_order}{when \code{TRUE}, the estimated value will be ordered
according to the color.}

\item{color}{an expression to indicate how colors are assigned to markers.
By default, colors are assigned based on 'p.value <= 0.05'.}

\item{branch_order}{name for the branch to order.}

\item{point_size}{size of points on the top plot.}

\item{grid_size}{size of points on the bottom plot.}

\item{point_alpha}{alpha level of points and point ranges.}

\item{brewer_palette}{name of colorbrewer palette for the plot.}

\item{yaxis_text_size}{text size of y-axis label}
}
\value{
a specification curve plot for the estimates
}
\description{
\code{spec_curve} returns the specification curve  as
proposed by Simonsohn, Simmons, and Nelson
(2020) <doi:10.1038/s41562-020-0912-z>.
\code{spec_curve} are available for \code{mverse} objects fitted with
\code{lm_mverse()}, \code{glm_mverse()}, and \code{glm.nb_mverse()}.
Notice that the order of universes may not correspond to the order
in the summary table.
}
\examples{
\donttest{

# Display a specification curve for \code{lm} models
# fitted across the multiverse.
femininity <- mutate_branch(
  MasFem > 6, MasFem > mean(MasFem)
)
model <- formula_branch(
  alldeaths ~ femininity,
  alldeaths ~ femininity + HighestWindSpeed
)
mv <- mverse(hurricane) \%>\%
  add_mutate_branch(femininity) \%>\%
  add_formula_branch(model) \%>\%
  lm_mverse()
spec_curve(mv, var = "femininityTRUE")
# plot based on 90\% confidence interval
spec_curve(mv, var = "femininityTRUE", color = p.value < .1)
}
\donttest{

# Display a specification curve for \code{glm} models
# fitted across the multiverse.
femininity <- mutate_branch(
  MasFem > 6, MasFem > mean(MasFem)
)
model <- formula_branch(
  alldeaths ~ femininity,
  alldeaths ~ femininity + HighestWindSpeed
)
fam <- family_branch(gaussian)
mv <- mverse(hurricane) \%>\%
  add_mutate_branch(femininity) \%>\%
  add_formula_branch(model) \%>\%
  add_family_branch(fam) \%>\%
  glm_mverse()
spec_curve(mv, var = "femininityTRUE")
# plot based on 90\% confidence interval
spec_curve(mv, var = "femininityTRUE", color = p.value < .1)
}
\donttest{

# Display a specification curve for \code{glm.nb} models
# fitted across the multiverse.
femininity <- mutate_branch(
  MasFem > 6, MasFem > mean(MasFem)
)
model <- formula_branch(
  alldeaths ~ femininity,
  alldeaths ~ femininity + HighestWindSpeed
)
mv <- mverse(hurricane) \%>\%
  add_mutate_branch(femininity) \%>\%
  add_formula_branch(model) \%>\%
  glm.nb_mverse()
spec_curve(mv, var = "femininityTRUE")
# plot based on 90\% confidence interval
spec_curve(mv, var = "femininityTRUE", color = p.value < .1)
}
}
