\name{getclf}
\alias{getclf}
\title{Create likelihood function for multivariate data with missing values.}
\description{
  \code{getclf} returns a function proportional to twice the negative
  log likelihood function for multivariate normal data with missing
  values.  This is a private function used in \code{mlest}.
}
\usage{
getclf(data, freq)
}
\arguments{
  \item{data}{A data frame sorted so that records with identical
      patterns of missingness are grouped together.}
  \item{freq}{An integer vector specifying the number of records in each
  block of data with identical patterns of missingness.}
}
\details{
  The argument of the returned function is the vector of parameters.
  The parameterization is: mean vector first, followed
      by the log of the diagonal elements of the inverse of the Cholesky
      factor, and then the elements of the inverse of the Cholesky
      factor above the main diagonal.  These off-diagonal elements are
      ordered by column (left to right), and then by row within column
      (top to bottom).
}
\value{
  A function proportional to twice the negative log likelihood of the
  parameters given the data.
}
\references{ Little, R. J. A., and Rubin, D. B. (1987) \emph{Statistical Analysis
     with Missing Data}.  New York: Wiley. }

\seealso{ \code{\link{mlest}} }

\keyword{multivariate}





