% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvtb_summary.R
\name{mvtb.ri}
\alias{mvtb.ri}
\title{Computes the relative influence of each predictor for each outcome.}
\usage{
mvtb.ri(object, n.trees = NULL, weighted = F, relative = "col")
}
\arguments{
\item{object}{\code{mvtb} output object}

\item{n.trees}{number of trees to use. Defaults to the minimum number of trees by CV, test, or training error}

\item{weighted}{\code{TRUE/FALSE}. Reductions in SSE are weighted according the covariance explained by each predictor. See \code{?mvtb} for details.}

\item{relative}{If \code{"col"}, each column sums to 100. If \code{"tot"}, the whole matrix sums to 100 (a percent). Otherwise, the raw reductions in SSE are returned.}
}
\value{
Matrix of (relative) influences.
}
\description{
The relative influence of a predictor is the reduction in sums of squares attributable to splits on individual predictors.
It is often expressed as a percent (sums to 100).
}
\details{
'The 'influence' of a predictor is the reduction in SSE due to splitting on each predictor, summed over all trees.
If \code{"weighted"=TRUE}, the influence is weighted by the covariance explained in all pairs of outcomes by that predictor. 
This allows predictor selection to be informed by the covariance explained. 
Different weighting types are possible, see \code{?mvtb}.
}

