% Generated by roxygen2 (4.0.1): do not edit by hand
\name{multiThresh}
\alias{multiThresh}
\title{Resolution level thresholds for hard thresholded wavelet deconvolution estimator}
\usage{
multiThresh(Y, G = directBlur(dim(as.matrix(Y))), alpha = rep(1,
  dim(as.matrix(Y))[2]), blur = "direct", j0 = 3L, j1 = NA_integer_,
  eta = NA_real_, deg = 3L)
}
\arguments{
\item{G}{The input multichannel blur matrix/vector (needs to be the same dimension/length as the signal input which is a matrix or vector for the multichannel or single channel case respectively). This argument dictates the form of blur present in each of the channels.}

\item{alpha}{A numeric vector, with m elements, specifying the level of long memory for the noise process within each channel of the form alpha = 2 - 2H, where H is the Hurst parameter. If alpha is a single element, that same element is repeated across all required channels.}

\item{blur}{A character string describing which deconvolution regime is to be applied.\itemize{
\item 'direct' (default): No deconvolution required and direct signal observed. This is captured when G is an n by m matrix with all entries being zero except the first row where all elements are one.
\item 'smooth': Indirect signal observed and the blurring kernel is of regular smooth blur type.
\item 'box.car': Indirect signal observed and the blurring kernel is of box car type.}}

\item{j0}{The coarsest resolution level for the wavelet expansion.}

\item{j1}{The finest resolution level for the wavelet expansion. If unspecified, the function will compute all thresholds up to the maximum possible resolution level at j1 = log2(n) - 1.}

\item{eta}{The smoothing parameter. The default level is \eqn{2\sqrt(\alpha^*)} where \eqn{\alpha^*} is an optimal level depending on the type of blur. (see Kulik, Sapatinas and Wishart (2014) for details and justification)}

\item{Y}{An input signal either an n by m matrix containing the multichannel signal to be analysed or single vector of n elements for the single channel. In the multichannel case, each of the m columns represents a channel of n observations.}

\item{deg}{The degree of the auxiliary polynomial used in the Meyer wavelet.}
}
\value{
A numeric vector of the resolution level thresholds for the hard-thresholding nonlinear wavelet estimator from the multichannel model.
}
\description{
Computes the estimated resolution level thresholds for the hard-thresholding wavelet deconvolution estimate of the desired signal in the multichannel signals.
}
\details{
Given an input matrix of a multichannel signal (n rows and n columns) with m channels and n observations per channel, the function returns the required thresholds for the hard-thresholding estimator of the underlying function, f.
}
\examples{
library(mwaved)
# Simulate the multichannel doppler signal.
m <- 3
n <- 2^10
signal <- makeDoppler(n)
# Noise levels per channel
e <- rnorm(m*n)
# Create Gamma blur
shape <- seq(from = 0.5, to = 1, length = m)
scale <- rep(0.25,m)
G <- gammaBlur(n, shape = shape, scale = scale)
# Convolve the signal
X <- blurSignal(signal, G)
# Create error with custom signal to noise ratio
SNR <- c(10,15,20)
sigma <- sigmaSNR(X, SNR)
alpha <- c(0.75, 0.8, 1)
E <- multiNoise(n, sigma, alpha)
# Create noisy & blurred multichannel signal
Y <- X + E
# Determine thresholds
thresh <- multiThresh(Y, G, blur = 'smooth')
}
\references{
Kulik, R., Sapatinas, T. and Wishart, J.R. (2014) \emph{Multichannel wavelet deconvolution with long range dependence. Upper bounds on the L_p risk}  Appl. Comput. Harmon. Anal. (to appear in).
\url{http://dx.doi.org/10.1016/j.acha.2014.04.004}
}

