/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.RLTSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Utils;

public class Worker
implements Runnable {
    private final Signals signals;
    private final Graph graph;
    private final RLTSolver solver;
    private final Node root;
    private List<Unit> result;
    private boolean isSolvedToOptimality;
    private boolean isOk;
    private long startTime;
    private int logLevel;

    public Worker(Graph graph, Node root, Signals signals, RLTSolver solver, long time) {
        this.solver = solver;
        this.graph = graph;
        this.signals = signals;
        this.root = root;
        this.isSolvedToOptimality = true;
        this.isOk = true;
        this.startTime = time;
    }

    @Override
    public void run() {
        Set<Node> vertexSet = this.graph.vertexSet();
        this.solver.setRoot(this.root);
        if (vertexSet.size() <= 1) {
            this.result = vertexSet.stream().filter(n -> this.signals.weight((Unit)n) >= 0.0).collect(Collectors.toList());
            return;
        }
        double tl = this.solver.getTimeLimit().getRemainingTime() - (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        if (tl <= 0.0) {
            this.isSolvedToOptimality = false;
            return;
        }
        this.solver.setTimeLimit(new TimeLimit(Math.max(tl, 0.0)));
        try {
            List<Unit> sol = this.solver.solve(this.graph, this.signals);
            if (Utils.sum(sol, this.signals) > Utils.sum(this.result, this.signals)) {
                this.result = sol;
            }
        }
        catch (SolverException e) {
            this.isOk = false;
        }
        if (!this.solver.isSolvedToOptimality()) {
            this.isSolvedToOptimality = false;
        }
    }

    public List<Unit> getResult() {
        return this.result;
    }

    public boolean isSolvedToOptimality() {
        return this.isSolvedToOptimality;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

