% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omit_matrix.R
\name{omit_matrix}
\alias{omit_matrix}
\title{Compute TXI Profiles Omitting Each Gene}
\usage{
omit_matrix(phyex_set)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}
}
\value{
A numeric matrix storing TXI profiles for each omitted gene i
}
\description{
For each gene i, exclude the corresponding gene i from the
PhyloExpressionSet and compute the TXI profile for the dataset with gene i excluded.
 
This procedure results in a TXI profile matrix storing the TXI profile for each omitted gene i.
}
\details{
This function systematically removes each gene and recalculates the transcriptomic
index profile to assess the contribution of individual genes to the overall pattern.
This is useful for identifying genes that have a large influence on the
phylotranscriptomic signature.
}
\examples{
# Compute omit matrix for a PhyloExpressionSet
omit_mat <- omit_matrix(example_phyex_set)

}
\author{
Hajk-Georg Drost
}
