% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch_nltt_matrix.R
\name{stretch_nltt_matrix}
\alias{stretch_nltt_matrix}
\title{Stretch matrix 'm' with a timestep resolution of 'dt'}
\usage{
stretch_nltt_matrix(m, dt, step_type)
}
\arguments{
\item{m}{A matrix of 2 columns and at least 2 rows}

\item{dt}{The resultion, a value e <0,1]}

\item{step_type}{can be 'lower' or 'upper'}
}
\value{
The stretched matrix
}
\description{
Stretch matrix 'm' with a timestep resolution of 'dt'
}
\examples{
  m <- matrix( c(c(0.0, 1.0), c(0.5, 1.0)), ncol = 2, nrow = 2)
  expected <- matrix(
    c(
      c(0.0, 0.5, 1.0),  # Timepoints
      c(0.5, 0.5, 1.0)   # Values
    ),
    ncol = 2, nrow = 3
  )
  result <- stretch_nltt_matrix(m = m, dt = 0.5, step_type = "lower")
  testit::assert(identical(result, expected))

}
\author{
Richel Bilderbeek
}

