#' @name impute-constant
#' @title Impute by Constant Value
#'
#' Replaces `NA`s by a constant 
#'
#' @param .x vector; of values to have the `NA`
#' @param .na scalar to use as replacement.
#' 
#' @details 
#'
#' These functions replace **ALL** `NA` values in `x` with an scalar 
#' value specified by`.na`. 
#' 
#' @return 
#'   A vector with the type and length of `x` with all missing values replaces 
#'   by `.na`.

#' @seealso
#'   * [na.replace()] the underlying function that performs the replacement.
#' 
#' @rdname impute-constant

NULL
