% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_naaccr.R
\name{naaccr_encode}
\alias{naaccr_encode}
\title{Format a value as a string according to the NAACCR format}
\usage{
naaccr_encode(x, field, flag = NULL, version = NULL, format = NULL)
}
\arguments{
\item{x}{Vector of values.}

\item{field}{Character string naming the field.}

\item{flag}{Character vector of flags for the field. Only needed if the
field contains sentinel values.}

\item{version}{An integer specifying the NAACCR format version for parsing
the records. Use this or \code{format}, not both. If both \code{version}
and \code{format} are \code{NULL} (the default), the most recent version is
used.}

\item{format}{A \code{\link{record_format}} object for writing the records.}
}
\value{
Character vector of the values as they would be encoded in a
  NAACCR-formatted text file.
}
\description{
Format a value as a string according to the NAACCR format
}
\examples{
  r <- naaccr_record(
    ageAtDiagnosis = c("089", "000", "200"),
    dateOfDiagnosis = c("20070402", "201709  ", "        ")
  )
  r
  mapply(FUN = naaccr_encode, x = r, field = names(r))
}
\seealso{
\code{\link{split_sentineled}}
}
