% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPed.R
\name{simPedDFC}
\alias{simPedDFC}
\title{Double first cousin pedigree construction}
\usage{
simPedDFC(F, gpn = 4, fsn = 4, s = 2, fws = 2, prefix = NULL)
}
\arguments{
\item{F}{Number of blocks for the design}

\item{gpn}{Number of grandparent pairs in the 0/GP generation
(must be >= 2). Equals the number of full-sib families in the
1/P generation.}

\item{fsn}{Number of offspring in each full-sib family of the 1/P
and 2/F1 generations (must be an even number >= 4).}

\item{s}{Number of sires per full-sib family in the 1/P generation
(must be >=2)}

\item{fws}{Number of 1/P generation families with sires. Together, with
\code{s}, sets up how cousins and double first cousins are produced}

\item{prefix}{Optional prefix to add to every identity}
}
\value{
A \code{data.frame} with columns corresponding to: id, dam, sire,
  and sex. Sex is \code{M} for males and \code{F} for females.
}
\description{
Simulates a pedigree for the \dQuote{double first cousin} mating design
(Fairbairn and Roff 2006).
}
\details{
This is an adaption to a half-sib breeding design which also produces first
cousins and double first cousins. Double first cousins are produced by
mating two brothers to two sisters (the offspring of the resulting two
families are double first cousins with one another). This is described in
Fairbairn and Roff (2006) as being particularly effective for separating
autosomal additive genetic variance from sex chromosomal additive genetic
variance. It is also amenable to estimating dominance variance, however, it
still has difficulty separating dominance variance from common maternal
environmental variance (Meyer 2008).

For a given unit of the design (\code{F} total), \code{2*gpn} 0-generation 
(grandparental or GP) individuals are created and paired to make \code{gpn}
full-sib families. Then the first \code{fws} families are each allocated \code{s}
males/sires and \code{s*(fws-1)} females/dams in the 1/P generation. The
remaining (\code{gpn-fws}) families (only when: \code{gpn > fws}) are assigned
\code{s*fws} females/dams. If \code{fsn > (s*fws)}, the remaining 1/P 
generation individuals in each full-sib family (\code{fsn - (s*fws)}) are
allocated to each family with equal numbers of females and males (this allows
for more individuals to be phenotyped in the 1/P generation than are used to
produce the 2/F1 generation). The 2/F1 generation is then assigned, based on
the mating design in Fairbairn and Roff (2006) - essentially each sire (of
the \code{s} per full-sib family in the 1/P generation) is mated to a female
from each of the other \code{gpn-1} full-sib families to produce \code{fsn}
offspring (with equal numbers of females and males).
}
\examples{

  DFC1 <- simPedDFC(F = 1, gpn = 2, fsn = 4, s = 2, fws = 2)

}
\references{
Fairbairn, D.J. and D.A. Roff. 2006.  The quantitative genetics
of sexual dimorphism: assessing the importance of sex-linkage. Heredity
97:319-328.

Meyer, K. 2008.  Likelihood calculations to evaluate experimental designs to
estimate genetic variances. Heredity 101:212-221.
}
\seealso{
\code{\link{simPedHS}}, \code{\link{warcolak}}
}
\author{
\email{matthewwolak@gmail.com}
}
