% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ExpSmooth}
\alias{ExpSmooth}
\title{Exponentially smooth a series of observations.}
\usage{
ExpSmooth(obs, tau, extended = FALSE)
}
\arguments{
\item{obs}{A numeric vector of observations (in order).}

\item{tau}{The time scale for the exponential smoothing (see Stroud 1999).}

\item{extended}{Logical. Has the series (\code{obs}) already been extended via
via \code{nandb:::MedReflectExtend()}? If not, \code{ExpSmooth} will do this
prior to smoothing as an edge-correction technique. You will probably
never set this to \code{TRUE}, but \code{\link[=BestTau]{BestTau()}} needs this feature.}
}
\value{
The smoothed series, a numeric vector of the same length.
}
\description{
This function assumes that the observations are evenly spaced and separated
by 1 time unit (so choose your \code{tau} based on that).
}
\examples{
ExpSmooth(1:10, 1)
}
