% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{Bin2Tiff}
\alias{Bin2Tiff}
\alias{Bin2TiffFolder}
\title{Convert a binary image to tiff.}
\usage{
Bin2Tiff(bin.path, bits, height, width, frames = 1,
  endian = .Platform$endian, signed = TRUE)

Bin2TiffFolder(folder.path = ".", bits, height, width, frames = 1,
  endian = .Platform$endian, signed = TRUE)
}
\arguments{
\item{bin.path}{The path to the binary file.}

\item{bits}{How many bits are there per pixel? This should be a multiple of
8.}

\item{height}{The height of the image (in pixels).}

\item{width}{The width of the image (in pixels).}

\item{frames}{How many frames are there in the stack (default 1).}

\item{endian}{Eigher \code{"big"} or \code{"little"} (see \link{readBin}).}

\item{signed}{Logical. Only used for integers of sizes 1 and 2, when it
determines if the quantity on file should be regarded as a signed or
unsigned integer.}

\item{folder.path}{The path to the folder (defaults to current location).}
}
\description{
Read a binary image (pixels must be integers), specifying its dimension and
write it back to disk as a tifff file. The \code{Bin2TiffFolder} function does
this for an entire folder.
}
\details{
When using \code{Bin2TiffFolder}, the images must all have the same dimension.
}
\examples{
setwd(tempdir())
dir.create("temp_dir")
file.copy(system.file("extdata", "b.bin", package = "nandb"), "temp_dir")
Bin2Tiff("temp_dir/b.bin", height = 2, width = 2, bits = 8)
Bin2TiffFolder("temp_dir", height = 2, width = 2, bits = 8)
list.files("temp_dir")
}
