% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness.R
\name{BrightnessTimeSeries}
\alias{BrightnessTimeSeries}
\alias{BrightnessTimeSeriesTxtFolder}
\title{Create a Brightness time-series.}
\usage{
BrightnessTimeSeries(arr, frames.per.set, tau = NA, mst = NULL,
  filt = NULL, n.ch = 1, verbose = FALSE, mcc = parallel::detectCores(),
  seed = NULL)

BrightnessTimeSeriesTxtFolder(folder.path = ".", frames.per.set,
  ext = "tif", tau = NA, mst = NULL, filt = NULL, n.ch = 1,
  verbose = FALSE, mcc = parallel::detectCores(), seed = NULL)
}
\arguments{
\item{arr}{An array, can be 3- or 4-dimensional. The first two slots give the
x- and y-cordinates of pixels respectively. If the array is 3-dimensional,
the third slot gives the index of the frame. If it is 4-dimensional, the
third slot indexes the channel and the fourth indexes the frame in the
stack. To perform this on a file that has not yet been read in, set this
argument to the path to that file (a string).}

\item{frames.per.set}{The number of frames with which to calculate the
successive brightnesses.}

\item{tau}{If this is specified, bleaching correction is performed with
\code{\link[=CorrectForBleaching]{CorrectForBleaching()}} which uses exponential filtering with
time constant \code{tau} (where the unit of time is the time between
frames). If this is set to \code{'auto'}, then the value of \code{tau} is
calculated automatically via \code{\link[=BestTau]{BestTau()}}.}

\item{mst}{Do you want to apply an intensity threshold prior to calculating
brightness (via \code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your
thresholding \emph{method} here.}

\item{filt}{Do you want to smooth (\code{filt = 'smooth'}) or median
(\code{filt = 'median'}) filter the brightness image using
\code{\link[=SmoothFilterB]{SmoothFilterB()}} or \code{\link[=MedianFilterB]{MedianFilterB()}} respectively? If
selected, these are invoked here with a filter radius of 1 and with the
option \code{na_count = TRUE}. If you want to smooth/median filter the
brightness image in a different way, first calculate the brightnesses
without filtering (\code{filt = NULL}) using this function and then perform
your desired filtering routine on the result.}

\item{n.ch}{The number of channels in the image (default 1).}

\item{verbose}{If arr3d is specified as a file name, print a message to tell
the user that that file is now being processed (useful for
\code{BrightnessTxtFolder}, does not work with multiple cores).}

\item{mcc}{The number of cores to use for the parallel processing.}

\item{seed}{If using parallel processing (\code{mcc} > 1), a seed for the random
number generation for \link{BestTau}. Don't use \link{set.seed}, it won't work.}

\item{folder.path}{The path to the folder to process (defaults to current location).}

\item{ext}{The file extension of the images in the folder that you wish to
process. You must wish to process all files with this extension; if there
are files that you don't want to process, take them out of the folder. The
default is for tiff files. Do not use regular expression in this argument.}
}
\value{
An array where the \eqn{i}th slice is the \eqn{i}th brightness image.
}
\description{
Given a stack of images \code{arr}, use the first \code{frames.per.set} of
them to create one brightness image, the next \code{frames.per.set} of them
to create the next brightness image and so on to get a time-series of
brightness images. If \code{tau} is specified, bleaching correction is
performed via \code{\link[=CorrectForBleaching]{CorrectForBleaching()}}.
}
\details{
This may discard some images, for example if 175 frames are in the input and
\code{frames.per.set = 50}, then the last 25 are discarded. If bleaching or/and
thresholding are selected, they are performed on the whole image stack before
the sectioning is done for calculation of brightnesses.
}
\examples{
library(magrittr)
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
EBImage::display(EBImage::normalize(img[, , 1]), method = 'raster')
bts <- BrightnessTimeSeries(img, 20, tau = NA, mst = "Huang", mcc = 2)
setwd(tempdir())
WriteIntImage(img, '50.tif')
WriteIntImage(img, '50again.tif')
BrightnessTimeSeriesTxtFolder(tau = NA, mcc = 2, frames.per.set = 20)
list.files()
file.remove(list.files())  # cleanup
}
\seealso{
\code{\link[=Brightness]{Brightness()}}.
}
