% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{PillarsListToArr}
\alias{PillarsListToArr}
\title{Make a list of pillars back into a 3D array.}
\usage{
PillarsListToArr(pillars.list, dim)
}
\arguments{
\item{pillars.list}{The list of pillars}

\item{dim}{The desired dimension of the output array.}
}
\value{
A 3-dimensional array.
}
\description{
#' Suppose the array is of dimension \code{n1 * n2 * n3}, then pillar
\code{[i, j, ]} is list element \code{i + n1 * (j - 1)}, so the first element
is pillar \code{[1, 1, ]}, the second is pillar \code{[1, 2, ]} and so on.
}
\examples{
arr <- array(1:27, dim = rep(3, 3))
print(arr)
ListPillars(arr)
PillarsListToArr(ListPillars(arr), dim(arr))

}
\seealso{
\link{ListPillars}
}
