% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcar-test.R
\name{mcar_test}
\alias{mcar_test}
\title{Little's missing completely at random (MCAR) test}
\usage{
mcar_test(data)
}
\arguments{
\item{data}{A data frame}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with one row and four columns:
\item{statistic}{Chi-squared statistic for Little's test}
\item{df}{Degrees of freedom used for chi-squared statistic}
\item{p.value}{P-value for the chi-squared statistic}
\item{missing.patterns}{Number of missing data patterns in the data}
}
\description{
Use Little's (1988) test statistic to assess if data is missing completely
at random (MCAR). The null hypothesis in this test is that the data is
MCAR, and the test statistic is a chi-squared value. The example below
shows the output of \code{mcar_test(airquality)}. Given the high statistic
value and low p-value, we can conclude the \code{airquality} data is not
missing completely at random.
}
\note{
Code is adapted from LittleMCAR() in the now-orphaned {BaylorEdPsych}
package: https://rdrr.io/cran/BaylorEdPsych/man/LittleMCAR.html. Some of
code is adapted from Eric Stemmler - \url{https://web.archive.org/web/20201120030409/https://stats-bayes.com/post/2020/08/14/r-function-for-little-s-test-for-data-missing-completely-at-random/}
using Maximum likelihood estimation from {norm}.
}
\examples{
mcar_test(airquality)
mcar_test(oceanbuoys)

# If there are non-numeric columns, there will be a warning
mcar_test(riskfactors)

}
\references{
Little, Roderick J. A. 1988. "A Test of Missing Completely at
Random for Multivariate Data with Missing Values."
\emph{Journal of the American Statistical Association} 83 (404):
1198--1202. \doi{10.1080/01621459.1988.10478722}.
}
\author{
Andrew Heiss, \email{andrew@andrewheiss.com}
}
