% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{lower_triangular}
\alias{lower_triangular}
\alias{lower_triangular,spec_tbl_df-method}
\alias{lower_triangular,tbl_df-method}
\title{Keep rows corresponding of a lower triangular matrix built from two columns}
\usage{
lower_triangular(.data, .col1, .col2, .value)

\S4method{lower_triangular}{spec_tbl_df}(.data, .col1, .col2, .value)

\S4method{lower_triangular}{tbl_df}(.data, .col1, .col2, .value)
}
\arguments{
\item{.data}{A `tbl`}

\item{.col1}{A column name}

\item{.col2}{A column name}

\item{.value}{A column names of the value column}
}
\value{
A `tbl` with filtered rows

A `tbl` with filled abundance

A `tbl` with filled abundance
}
\description{
lower_triangular() takes as imput a `tbl` formatted as | <element> | <feature> | <value> | <...> | and returns a filtered `tbl`
}
\details{
\lifecycle{maturing}

...
}
\examples{

library(dplyr)
library(purrr)
library(tidyr)

mtcars_tidy_permuted = 
  mtcars_tidy \%>\% 
  filter(feature == "mpg") \%>\% 
  head(5) \%>\% 
  permute_nest(car_model, c(feature,value))

mtcars_tidy_permuted \%>\%
 # Summarise mpg
 mutate(data = map(data, ~ .x \%>\% summarise(mean(value)))) \%>\%
unnest(data) \%>\%

# Lower triangular
lower_triangular(car_model_1, car_model_2,  `mean(value)`)

}
