% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{impute_missing}
\alias{impute_missing}
\alias{impute_missing,spec_tbl_df-method}
\alias{impute_missing,tbl_df-method}
\title{Impute feature value if missing from element-feature pairs}
\usage{
impute_missing(.data, .element, .feature, .value, .formula)

\S4method{impute_missing}{spec_tbl_df}(.data, .element, .feature, .value, .formula)

\S4method{impute_missing}{tbl_df}(.data, .element, .feature, .value, .formula)
}
\arguments{
\item{.data}{A `tbl` formatted as | <element> | <feature> | <value> | <...> |}

\item{.element}{The name of the element column}

\item{.feature}{The name of the feature/gene column}

\item{.value}{The name of the feature/gene value column}

\item{.formula}{A formula with no response variable, representing the desired linear model where the first covariate is the factor of interest and the second covariate is the unwanted variation (of the kind ~ factor_of_intrest + batch)}
}
\value{
A `tbl` non-sparse value

A `tbl` with imputed abundnce

A `tbl` with imputed abundnce
}
\description{
impute_missing() takes as imput a `tbl` formatted as | <element> | <feature> | <value> | <...> | and returns a `tbl` with an edditional adjusted value column. This method uses scaled counts if present.
}
\details{
\lifecycle{maturing}

This function imputes the value of missing element-feature pair using the median of the element group defined by the formula
}
\examples{

 impute_missing(mtcars_tidy, car_model, feature, value, ~1)

}
