library(nanonext)
nanotest <- function(x) invisible(x || stop())
nanotestn <- function(x) invisible(!is.null(x) || stop())
nanotestw <- function(x) invisible(suppressWarnings(x) || stop())
nanotestwn <- function(x) invisible(suppressWarnings(!is.null(x)) || stop())

n <- nano("pair", listen = "inproc://nanonext", autostart = FALSE)
n1 <- nano("pair", dial = "inproc://nanonext", autostart = FALSE)
nanotest(inherits(n, "nanoObject"))
nanotest(inherits(n$socket, "nanoSocket"))
nanotest(inherits(n$socket, "nano"))
nanotest(identical(is_nano(n), TRUE))
n$newmethod <- "doesnotwork"
nanotest(is.null(n$newmethod))

nanotest(is.integer(attr(n$socket, "id")))
nanotest(n$socket$state == "opened")
nanotest(n$socket$protocol == "pair")
nanotestw(n$send("not ready") > 0L)
nanotestw(n$recv() > 0L)
nanotest(n$socket_setopt("size", "recv-size-max", 8192) == 0)
nanotest(n$socket_setopt("int", "recv-buffer", 8) == 0)
nanotest(n$socket_setopt("string", "socket-name", "nano") == 0)

nanotest(inherits(n$listener[[1]], "nanoListener"))
nanotest(n$listener[[1]]$url == "inproc://nanonext")
nanotest(n$listener[[1]]$state == "not started")
nanotest(n$listener_setopt("size", "recv-size-max", 1024) == 0)
nanotest(n$listener_start() == 0L)
nanotest(n$listener[[1]]$state == "started")

nanotest(inherits(n1$dialer[[1]], "nanoDialer"))
nanotest(n1$dialer[[1]]$url == "inproc://nanonext")
nanotest(n1$dialer[[1]]$state == "not started")
nanotest(n1$dialer_setopt("ms", "reconnect-time-min", 1000) == 0)
nanotest(n1$dialer_setopt("size", "recv-size-max", 8192) == 0)
nanotest(n1$dialer_start() == 0L)
nanotest(n1$dialer[[1]]$state == "started")

nanotestwn(n$send(data.frame(), block = FALSE, echo = FALSE))
nanotestwn(n1$recv(block = FALSE))
nanotestwn(n1$send("test", mode = "raw", block = 500, echo = FALSE))
nanotestwn(n$recv("character", block = 500))
nanotestwn(n1$send(c(1L, 0L, 0L), mode = "r"))
nanotestwn(n$recv("int", keep.raw = FALSE))
saio <- n$send_aio(data.frame(), timeout = 500)
nanotest(identical(is_aio(saio), TRUE))
nanotest(identical(is_nano(saio), FALSE))
nanotestn(saio[["aio"]])
nanotestn(saio$result)
raio <- n1$recv_aio(timeout = 500)
raio$newfield <- "doesnotwork"
nanotest(is.null(raio$newfield))
nanotest(is_aio(raio) == TRUE)
nanotestn(raio[["aio"]])
nanotestn(raio$raw)
nanotestn(raio$data)
saio <- n$send_aio(c(1.1, 2.2), mode = "raw", timeout = 500)
saio$newfield <- "doesnotwork"
nanotest(is.null(saio$newfield))
nanotest(is_aio(saio) == TRUE)
nanotest(is.logical(unresolved(saio)))
msg <- n1$recv_aio(mode = "numer", timeout = 500, keep.raw = FALSE)
nanotest(is.null(stop_aio(msg)))
nanotest(is.null(stop_aio(n)))
nanotest(identical(call_aio(msg), msg))
nanotestn(tryCatch(msg$data, error = function(e) 0L))
nanotest(identical(call_aio(n), n))
nanotest(is_aio(n) == FALSE)
sraio <- n$send_aio(as.raw(0L), mode = "r", timeout = 500)
rraio <- n$recv_aio(mode = "r", timeout = 500)
nanotestwn(call_aio(rraio)$data)
sraio <- n$send_aio(as.raw(1L), mode = "ra", timeout = 200)
rraio <- n$recv_aio(mode = "ra", timeout = 200)
sraio <- n$send_aio(as.raw(2L), mode = "raw", timeout = 200)
rraio <- n$recv_aio(mode = "raw", timeout = 200)
sraio <- n$send_aio(1, mode = "raw", timeout = 200)
rraio <- n$recv_aio(mode = "nume", timeout = 200)
sraio <- n$send_aio(c(1, 2), mode = "raw", timeout = 200)
rraio <- n$recv_aio(mode = "numeri", timeout = 200)
sraio <- n$send_aio(c(1, 2, 3), mode = "raw", timeout = 200)
rraio <- n$recv_aio(mode = "numeric", timeout = 200)
sraio <- n$send_aio("hello", mode = "raw", timeout = 200)
rraio <- n$recv_aio(mode = "characte", timeout = 200)

xc <- n$dial(url = "inproc://two", autostart = TRUE)
nanotest(is.integer(xc))
nanotest(inherits(n$dialer[[1L]], "nanoDialer"))
xc <- n$listen(url = "inproc://three")
nanotest(is.integer(xc))
nanotest(inherits(n$listener[[2L]], "nanoListener"))

nanotest(close(n$listener[[1]]) == 0L)
nanotestw(close(n$listener[[1]]) > 0L)
nanotest(close(n1$dialer[[1]]) == 0L)
nanotestw(close(n1$dialer[[1]]) > 0L)
nanotest(n$close() == 0L)
nanotest(n1$close() == 0L)
nanotestw(n1$close() > 0L)
nanotest(n$socket[["state"]] == "closed")
nanotest(n1$socket[state] == "closed")

n <- nano("req", listen = "inproc://testing")
n1 <- nano("rep", dial = "inproc://testing")
nanotest(n$socket_setopt("ms", "req:resend-time", 1000) == 0)
ctx <- n$context()
ctx1 <- context(n1$socket)
nanotest(inherits(ctx, "nanoContext"))
nanotest(inherits(ctx, "nano"))
nanotest(is.integer(ctx$id))
nanotest(ctx$state == "opened")
nanotest(ctx$protocol == "req")
nanotest(setopt(ctx, "ms", "send-timeout", 1000) == 0L)
csaio <- send_aio(ctx, data.frame(), mode = "seria", timeout = 500)
nanotestn(call_aio(csaio)$result)
nanotestwn(recv_aio(ctx1, timeout = 500, keep.raw = FALSE))
nanotestwn(send(ctx, "context test", mode ="raw", block = 300, echo = FALSE))
nanotestwn(recv(ctx1, mode = "ch", block = 300))
nanotestwn(send(ctx, data.frame(), mode = "seri", block = 400))
msg <- recv_aio(ctx1, mode = "ser", timeout = 400, keep.raw = FALSE)
nanotest(is.logical(unresolved(msg)))
nanotestn(call_aio(msg)$data)
nanotest(unresolved(msg) == FALSE)
nanotestwn(send(ctx, c(TRUE, FALSE, TRUE), mode = "raw", block = 300))
msg <- recv_aio(ctx1, mode = "l", timeout = 300)
nanotestn(msg$raw)
nanotestwn(request(ctx, c(1+3i, 4+2i), recv_mode = "complex", timeout = 300))
nanotestwn(reply(ctx1, execute = identity, send_mode = "ra", timeout = 300))
nanotest(close(ctx) == 0L)
nanotestw(close(ctx) > 0L)
nanotest(ctx$state == "closed")
ctx2 <- n1$context()
nanotest(close(ctx2) == 0L)

pub <- nano("pub", listen = "inproc://ps")
sub <- nano("sub", dial = "inproc://ps")
nanotest(sub$subscribe("test") == 0L)
nanotest(subscribe(sub$socket, NULL) == 0L)
nanotest(unsubscribe(sub$socket, NULL) == 0L)
nanotest(sub$unsubscribe("test") == 0L)
subctx <- sub$context()
nanotest(subscribe(subctx, 12) == 0L)
nanotest(unsubscribe(subctx, 12) == 0L)
nanotest(close(subctx) == 0L)
nanotest(sub$close() == 0L)
nanotest(pub$close() == 0L)

surv <- socket(protocol = "surveyor", listen = "inproc://sock1", dial = "inproc://sock2")
resp <- socket(protocol = "respondent", listen = "inproc://sock2", dial = "inproc://sock1")
surv$dialer <- NULL
nanotest(!is.null(surv$dialer) && !is.null(surv$listener))
nanotest(survey_time(surv, time = 5000) == 0L)
surctx <- context(surv)
nanotest(survey_time(surctx, time = 2000) == 0L)
nanotest(close(surctx) == 0L)
nanotest(close(surv) == 0L)
nanotest(close(resp) == 0L)

nanotestwn(ncurl("http://www.r-project.org/"))
nanotestwn(ncurl("http://httpbin.org/post", convert = FALSE, method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test"))
nanotestwn(ncurl("http://httpbin.org/post", convert = FALSE, method = "POST", headers = list(`Content-Type` = "text/plain")))
put1 <- ncurl("http://httpbin.org/put", async = TRUE, method = "PUT", headers = c(Authorization = "Bearer token"), data = "test")
nanotestn(put1$raw)
put2 <- ncurl("http://httpbin.org/put", async = TRUE, method = "PUT", headers = list(Authorization = "Bearer token"))
nanotestn(call_aio(put2)$data)
nanotest(is.null(stop_aio(put2)))
nanotestwn(stream(dial = "tcp://127.0.0.1:5555"))

nanotest(is.character(ver <- nng_version()) && length(ver) == 2L)
nanotest(is.character(nng_error(0L)))
nanotest(is_nul_byte(as.raw(0L)) && !is_nul_byte(NULL))
nanotest(!is_error_value(1L))
nanotestwn(messenger("invalidURL"))
nanotestn(tryCatch(.mirai_scm(), error = function(e) 0L))
nanotest(is.double(mclock()))
nanotest(is.null(msleep(1)))
nanotest(is.double(random()))

nanotest(inherits(bus <- socket(protocol = "bus"), "nanoSocket"))
nanotest(inherits(push <- socket(protocol = "push"), "nanoSocket"))
nanotest(inherits(pull <- socket(protocol = "pull"), "nanoSocket"))
nanotest(inherits(survey <- nano(protocol = "surveyor"), "nanoObject"))
nanotest(inherits(respond <- nano(protocol = "respondent"), "nanoObject"))
nanotest(is_nano(bus) == TRUE)
nanotest(close(bus) == 0L)
nanotest(close(push) == 0L)
nanotest(close(pull) == 0L)
nanotest(survey$close() == 0L)
nanotest(respond$close() == 0L)

