% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_error_value}
\alias{is_error_value}
\alias{is_nul_byte}
\title{Error Validators}
\usage{
is_error_value(x)

is_nul_byte(x)
}
\arguments{
\item{x}{an object.}
}
\value{
Logical value TRUE or FALSE.
}
\description{
Validator functions for error value types created by \pkg{nanonext}.
}
\details{
Is the object an error value generated by the package. All
    non-success integer return values are classed \sQuote{errorValue} to be
    distinguishable from integer message values. Includes error values
    returned after a timeout etc.

    Is the object a nul byte.
}
\examples{
s <- socket()
r <- recv_aio(s, timeout = 10)
call_aio(r)$data
close(s)
r$data == 5L
is_error_value(r$data)
is_error_value(5L)

is_nul_byte(as.raw(0L))
is_nul_byte(raw(length = 1L))
is_nul_byte(writeBin("", con = raw()))
is_nul_byte(0L)
is_nul_byte(NULL)
is_nul_byte(NA)

}
