% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{unresolved}
\alias{unresolved}
\title{Query if an Aio is Unresolved}
\usage{
unresolved(x)
}
\arguments{
\item{x}{an Aio or list of Aios (objects of class \sQuote{sendAio},
\sQuote{recvAio} or \sQuote{ncurlAio}), or Aio value stored at
\code{$result} or \code{$data} etc.}
}
\value{
Logical TRUE if \sQuote{aio} is an unresolved Aio or Aio value or the
  list of Aios contains at least one unresolved Aio, or FALSE otherwise.
}
\description{
Query whether an Aio, Aio value or list of Aios remains unresolved. Unlike
\code{\link{call_aio}}, this function does not wait for completion.
}
\details{
Suitable for use in control flow statements such as \code{while} or
\code{if}.

Note: querying resolution may cause a previously unresolved Aio to resolve.
}
\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
aio <- send_aio(s1, "test", timeout = 100)

while (unresolved(aio)) {
  # do stuff before checking resolution again
  cat("unresolved\n")
  msleep(20)
}

unresolved(aio)

close(s1)

}
