% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.r
\name{plot3d.hclust}
\alias{plot3d.hclust}
\title{Methods to identify and plot groups of neurons cut from an \code{hclust}
object}
\usage{
\method{plot3d}{hclust}(
  x,
  k = NULL,
  h = NULL,
  groups = NULL,
  col = rainbow,
  colour.selected = FALSE,
  ...
)
}
\arguments{
\item{x}{an \code{\link{hclust}} object generated by \code{\link{nhclust}}.}

\item{k}{number of clusters to cut from \code{\link{hclust}} object.}

\item{h}{height to cut \code{\link{hclust}} object.}

\item{groups}{numeric vector of groups to plot.}

\item{col}{colours for groups (directly specified or a function).}

\item{colour.selected}{When set to \code{TRUE} the colour palette only
applies to the displayed cluster groups (default \code{FALSE}).}

\item{...}{additional arguments for \code{plot3d}}
}
\value{
A list of \code{rgl} IDs for plotted objects (see
  \code{\link[rgl]{plot3d}}).
}
\description{
\code{plot3d.hclust} uses \code{plot3d} to plot neurons from
  each group, cut from the \code{hclust} object, by colour.
}
\details{
Note that the colours are in the order of the dendrogram as assigned
  by \code{colour_clusters}.
}
\examples{
# 20 Kenyon cells
data(kcs20, package='nat')
# calculate mean, normalised NBLAST scores
kcs20.aba=nblast_allbyall(kcs20)
kcs20.hc=nhclust(scoremat = kcs20.aba)
# plot the resultant dendrogram
plot(kcs20.hc)

# now plot the neurons in 3D coloured by cluster group
# note that specifying db explicitly could be avoided by use of the
# \code{nat.default.neuronlist} option.
plot3d(kcs20.hc, k=3, db=kcs20)

# only plot first two groups
# (will plot in same colours as when all groups are plotted)
plot3d(kcs20.hc, k=3, db=kcs20, groups=1:2)
# only plot first two groups
# (will be coloured with a two-tone palette)
plot3d(kcs20.hc, k=3, db=kcs20, groups=1:2, colour.selected=TRUE)
}
\seealso{
\code{\link{nhclust}, \link[rgl]{plot3d}, \link{slice},
\link{colour_clusters}}
}
