% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xform.R
\name{xform}
\alias{xform}
\alias{xform.character}
\alias{xform.default}
\alias{xform.dotprops}
\alias{xform.list}
\alias{xform.neuronlist}
\alias{xform.shape3d}
\title{Transform the 3d location of objects such as neurons}
\usage{
xform(x, reg, ...)

\method{xform}{default}(x, reg, na.action = c("warn", "none", "drop",
  "error"), ...)

\method{xform}{character}(x, reg, ...)

\method{xform}{list}(x, reg, FallBackToAffine = TRUE, na.action = "error",
  ...)

\method{xform}{shape3d}(x, reg, FallBackToAffine = TRUE,
  na.action = "error", ...)

\method{xform}{dotprops}(x, reg, FallBackToAffine = TRUE, ...)

\method{xform}{neuronlist}(x, reg, subset = NULL, ..., OmitFailures = NA,
  VectoriseRegistrations = FALSE)
}
\arguments{
\item{x}{an object to transform}

\item{reg}{A registration defined by a matrix, a function, a \code{cmtkreg}
object, or a character vector specifying a path to one or more CMTK
registrations on disk (see Registrations section).}

\item{...}{additional arguments passed to methods and eventually to
\code{\link{xformpoints}}}

\item{na.action}{How to handle NAs. NB drop may not work for some classes.}

\item{FallBackToAffine}{Whether to use an affine transform when a cmtk
warping transformation fails.}

\item{subset}{For \code{xform.neuronlist} indices (character/logical/integer)
that specify a subset of the members of \code{x} to be transformed.}

\item{OmitFailures}{Whether to omit neurons for which \code{FUN} gives an
error. The default value (\code{NA}) will result in nlapply stopping with
an error message the moment there is an eror. For other values, see
details.}

\item{VectoriseRegistrations}{When \code{FALSE}, the default, each element of
\code{reg} will be applied sequentially to each element of \code{x}. When
\code{TRUE}, it is assumed that there is one element of \code{reg} for each
element of \code{x}.}
}
\description{
\code{xform} is designed to operate on a variety of data types, especially
objects encapsulating neurons. \code{xform} depends on two specialised
downstream functions \code{\link{xformpoints}} and \code{\link{xformimage}}.
These are user visible any contain some useful documentation, but should only
be required for expert use; in almost all circumstances, you should use only
\code{xform}.

\code{xform.character} is designed to work with files on disk.
  Presently it is restricted to images, although other datatypes may be
  supported in future.
}
\details{
Methods are provided for some specialised S3 classes. Further
  methods can of course be constructed for user-defined S3 classes. However
  this will probalbly not be necessary if the \code{xyzmatrix} and
  \code{`xyzmatrix<-`} generics are suitably overloaded \emph{and} the S3
  object inherits from \code{list}.

TODO get this to work for matrices with more than 3 columns by
  working on xyzmatrix definition.

For the \code{xform.dotprops} method, dotprops tangent vectors will
  be recalculated from scratch after the points have been transformed (even
  though the tangent vectors could in theory be transformed more or less
  correctly). When there are multiple transformations, \code{xform} will take
  care to carry out all transformations before recalculating the vectors.

With \code{xform.neuronlist}, if you want to apply a different
  registration to each object in the neuronlist \code{x}, then you should use
  \code{VectoriseRegistrations=TRUE}.
}
\section{Registrations}{


  When \code{reg} is a character vector, xform's specialised downstream
  functions will check to see if it defines a path to one (or more) CMTK
  registrations, erroring out if this is not the case. If the path does
  indeed point to a CMTK registration, this method will hand off to
  \code{xformpoints.cmtkreg} or \code{xformimages.cmtkreg}. A future TODO
  would be to provide a mechanism for extending this behaviour for other
  registration formats.

  The character vector may optionally have an attribute, 'swap', a logical
  vector of the same length indicating whether the transformation direction
  should be swapped. At the moment only CMTK registration files are supported

  If \code{reg} is a character vector of length >=1 defining a sequence of
  registration files on disk they should proceed from sample to reference.

  Where \code{reg} is a function, it should have a signature like
  \code{myfun(x,), ...} where the \code{...} \strong{must} be provided in
  order to swallow any arguments passed from higher level functions that are
  not relevant to this particular transformation function.
}
\examples{
\dontrun{
kc1=kcs20[[1]]
kc1.default=xform(kc1,function(x,...) x)
stopifnot(isTRUE(all.equal(kc1,kc1.default)))
kc1.5=xform(kc1,function(x,...) x, k=5)
stopifnot(isTRUE(all.equal(kc1.5,kc1.default)))
kc1.20=xform(kc1,function(x,...) x, k=20)
stopifnot(!isTRUE(all.equal(kc1,kc1.20)))

# apply two registrations converting sample->IS2->JFRC2
reg_seq=c("IS2_sample.list", "JFRC2_IS2.list")
xform(kc1, reg_seq)
# apply two registrations, swapping the direction of the second one
# i.e. sample -> IS2 -> FCWB
reg_seq=structure(c("IS2_sample.list", "IS2_FCWB.list"), swap=c(FALSE, TRUE))
xform(kc1, reg_seq)
}
\dontrun{
# apply reg1 to Cell07PNs[[1]], reg2 to Cell07PNs[[2]] etc
regs=c(reg1, reg2, reg3)
nx=xform(Cell07PNs[1:3], reg=regs, VectoriseRegistrations=TRUE)
}
}
\seealso{
\code{\link{xformpoints}}
}

