% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hxsurf.R
\name{as.hxsurf}
\alias{as.hxsurf}
\alias{as.hxsurf.mesh3d}
\title{Convert an object to a nat hxsurf object}
\usage{
as.hxsurf(x, ...)

\method{as.hxsurf}{mesh3d}(x, region = "Interior", col = NULL, ...)
}
\arguments{
\item{x}{A surface object}

\item{...}{Additional arguments passed to methods}

\item{region}{The default name for the surface region}

\item{col}{The surface colour (default value of NULL implies the colour
specified in mesh3d object or \code{grey} when the \code{mesh3d} object has
no colour.)}
}
\value{
A new surface object of class \code{hxsurf} (see 
  \code{\link{read.hxsurf}}) for details.
}
\description{
Convert an object to a nat hxsurf object
}
\details{
\code{hxsurf} objects are based on the format of Amira's surface 
  objects (see \code{\link{read.hxsurf}}). They have the ability to include 
  multiple distinct regions. However, at the moment the only method that we 
  provide converts \code{mesh3d} objects, which can only include one region.
}
\examples{
tet=tetrahedron3d(col='red')
teth=as.hxsurf(tet)
\donttest{
plot3d(teth)
}
}
\seealso{
\code{\link{as.mesh3d}}

Other hxsurf: \code{\link{as.mesh3d}},
  \code{\link{materials}}, \code{\link{plot3d.hxsurf}},
  \code{\link{read.hxsurf}}, \code{\link{subset.hxsurf}},
  \code{\link{write.hxsurf}}
}
\concept{hxsurf}
