% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmtk_io.R
\name{write.cmtkreg}
\alias{write.cmtkreg}
\title{Write out CMTK registration list to folder}
\usage{
write.cmtkreg(reglist, foldername, version = "2.4")
}
\arguments{
\item{reglist}{List specifying CMTK registration parameters}

\item{foldername}{Path to registration folder (usually ending in .list)}

\item{version}{CMTK version for registration (default 2.4). Will be converted
to character vector if not already.}
}
\description{
Write out CMTK registration list to folder
}
\details{
Note that transformation in the forward direction (i.e. sample->ref)
  e.g. as calculated from a set of landmarks where set 1 is the sample is
  considered an inverse transformation by the IGS software. So in order to
  use such a transformation as an initial affine with the registration
  command the switch --initial-inverse must be used specifying the folder
  name created by this function.

CMTK v2.4 fixed a long-standing bug in affine (de)composition to
  CMTK params. This resulted in a non-backwards compatible change marked by
  writing the TYPEDSTREAM as version 2.4. The R code in this package
  implements both the new and old compose/decompose functions, using the new
  by default.
}
\seealso{
Other cmtk-io: 
\code{\link{cmtk.extract_affine}()},
\code{\link{read.cmtkreg}()},
\code{\link{read.cmtk}()},
\code{\link{write.cmtk}()}
}
\concept{cmtk-io}
