% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{LaLonde}
\alias{LaLonde}
\title{LaLonde data set}
\format{
A data frame with 3212 observations and 12 variables.
\describe{
  \item{exper}{an indicator for whether the observed unit was in the 
    experimental subset}
  \item{treat}{an indicator for whether the individual received the treatment}
  \item{age}{age in years}
  \item{educ}{schooling in years}
  \item{black}{an indicator for black}
  \item{hisp}{an indicator for Hispanic}
  \item{married}{an indicator for marriage status, one for married}
  \item{nodegr}{an indicator for no high school degree}
  \item{re74}{reported earnings in 1974}
  \item{re75}{reported earnings in 1975}
  \item{re78}{reported earnings in 1978}
  \item{re74.miss}{an indicator for whether the 1974 earnings variable is 
    missing}
}
Data not missing 1974 earnings are the Dehejia-Wahba subsample of the LaLonde
  data. Missing values for 1974 earnings set to zero. 1974 and 1975 earnings 
  are pre-treatment. 1978 earnings is taken as the outcome variable.
}
\source{
This version of the data is from \code{\link[CBPS]{LaLonde}} data in \code{CBPS} package.
}
\usage{
LaLonde
}
\description{
Data from the National Supported Work Demonstration Program and 
  the Panel Study for Income Dynamics. A benchmark data set, which is
  extensively analyzed by LaLonde (1986), Dehejia and Wahba (1999), and Imai
  and Ratkovic (2014).
}
\references{
Dehejia, Rajeev H., and Sadek Wahba. 1999. "Causal Effects in 
  Nonexperimental Studies: Reevaluating the Evaluation of Training Programs."
  Journal of the American Statistical Association 94 (448): 1053--62.

  Imai, Kosuke and Marc Ratkovic. 2014. "Covariate Balancing 
  Propensity Score." Journal of the Royal Statistical Society, Series B 
  (Statistical Methodology) 76 (1): 243--63.

  LaLonde, Robert J. 1986. "Evaluating the Econometric Evaluations 
  of Training Programs with Experimental Data." American Economic Review 76 
  (4): 604--20.
}
\keyword{datasets}
