% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeResults.R
\name{plotRt}
\alias{plotRt}
\title{Creates a plot of the effective reproductive number}
\usage{
plotRt(
  rData,
  includeRtAvg = FALSE,
  includeRtCI = FALSE,
  includeRtAvgCI = FALSE
)
}
\arguments{
\item{rData}{A list that is the output of \code{\link{estimateR}}. It should contain
the dataframes \code{RtDf}, \code{RtAvgDf}, and vectors \code{timeFrame} and \code{rangeForAvg}}

\item{includeRtAvg}{A logical. If TRUE, a horizontal line will be drawn for the average
Rt value over \code{rangeForAvg} and verticle lines will be drawn at the 
\code{rangeForAvg} values.}

\item{includeRtCI}{A logical. If TRUE, error bars will be added to the Rt values
representing the bootstrap confidence intervals.}

\item{includeRtAvgCI}{A logical. If TRUE, horizontal lines will be drawn around the Rt average
line representing the bootstrap confidence interval.}
}
\description{
The function \code{plotRt} creates a plot of the effective reproductive number (Rt) over
the course of the outbreak. Using various options, the plot can include the overall average
Rt value for the outbreak and the confidence intervals.
}
\details{
The main input \code{rData} should be the output of \code{\link{estimateRt}} with the
time-level reproductive numbers, overall average, range used to calculate that average,
and time frame.

The options \code{includeRtCI} and \code{includeRtAvgCI} add confidence interval bounds
to the plot. If set to true, \code{rData} should be from a call of \code{\link{estimateRt}}
with \code{bootSamples > 0} so that confidence intervals are available.
If \code{includeRtAvgCI} is set to \code{TRUE}, a line for the point estimate of the average
Rt value will be drawn even if \code{includeRtAvg} is set to \code{FALSE}.
}
\examples{

## Use the nbResults data frame included in the package which has the results
# of the nbProbabilities() function on a TB-like outbreak.

## Getting initial estimates of the reproductive number
# (ithout specifying nbResults and without confidence intervals)
rInitial <- estimateR(nbResults, dateVar = "infectionDate",
               indIDVar = "individualID", pVar = "pScaled",
               timeFrame = "months")
               
## Finding the stable portion of the outbreak for rangeForAvg using the plot
plotRt(rInitial)
cut1 <- 25
cut2 <- 125

## Finding the final reproductive number estimates with confidence intervals
# NOTE should run with bootSamples > 10.
rFinal <- estimateR(nbResults, dateVar = "infectionDate",
             indIDVar = "individualID", pVar = "pScaled",
             timeFrame = "months", rangeForAvg = c(cut1, cut2),
             bootSamples = 10, alpha = 0.05)

## Ploting the final result              
plotRt(rFinal, includeRtAvg = TRUE, includeRtCI = TRUE, includeRtAvgCI = TRUE)

}
\seealso{
\code{\link{nbProbabilities}} \code{\link{estimateR}}
}
