% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{package}
\name{nbpMatching-package}
\alias{nbpMatching}
\alias{nbpMatching-package}
\title{Nonbipartite Matching}
\description{
This package will take an input distance matrix and generate the set of
pairwise matches that minimizes the sum of distances between the pairs by
running nonbimatch.
}
\details{
The most current documentation is available at
\url{http://biostat.mc.vanderbilt.edu/wiki/Main/MatchedRandomization}.
}
\examples{
# create a covariate matrix
df <- data.frame(id=LETTERS[1:25], val1=rnorm(25), val2=rnorm(25))
# create distances
df.dist <- gendistance(df, idcol=1)
# create distancematrix object
df.mdm <- distancematrix(df.dist)
# create matches
df.match <- nonbimatch(df.mdm)
# review quality of matches
df.qom <- qom(df.dist$cov, df.match$matches)

# some helper functions are available
# runner -- start with the covariate, run through the entire process
df.1 <- runner(df, idcol=1)
# full.qom -- start with the covariate, generate a full quality of match report
df.2 <- full.qom(df)

\dontrun{
try a large matrix
nonbimatch(distancematrix(as.matrix(dist(sample(1:10^8, 5000, replace=TRUE)))))
}
}
\author{
Bo Lu, Robert Greevy, Cole Beck

Maintainer: Cole Beck \email{cole.beck@vanderbilt.edu}
}
\references{
Lu B, Greevy R, Xu X, Beck C. Optimal Nonbipartite Matching and
its Statistical Applications. The American Statistician. Vol. 65, no. 1. :
21-30. 2011.

Greevy RA Jr, Grijalva CG, Roumie CL, Beck C, Hung AM, Murff HJ, Liu X,
Griffin MR. Reweighted Mahalanobis distance matching for cluster-randomized
trials with missing data. Pharmacoepidemiol Drug Saf. 2012 May;21 Suppl
2:148-54. doi: 10.1002/pds.3260.
}
\keyword{array}
\keyword{cluster}
\keyword{package}

