% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFArray.R
\docType{class}
\name{CFArray}
\alias{CFArray}
\title{Array data extracted from a CF data variable}
\description{
This class holds the data that is extracted from a \link{CFVariable}
using the \code{data()}, \code{subset()} or \code{profile()} method. The instance of this
class will additionally have the axes and other relevant information such
as its attributes (as well as those of the axes) and the coordinate
reference system.

Otherwise, a \code{CFArray} is detached from the data set where it was derived
from. It is self-contained in the sense that all its constituent parts
(axes, bounds, attributes, etc) are available and directly linked to the
instance. For performance reasons, axes and their parts (e.g. bounds) are
shared between instances of \code{CFArray} and \code{CFVariable}.

The class has a number of utility functions to extract the data in specific
formats:
\itemize{
\item \code{raw()}: The data without any further processing. The axes are
as they are stored in the netCDF resource; there is thus no guarantee as to
how the data is organized in the array. Dimnames will be set.
\item \code{array()}: An array of the data which is organized as a standard R array
with the axes of the data permuted to Y-X-others and Y-values in decreasing
order. Dimnames will be set.
\item \code{terra()}: The data is returned as a \code{terra::SpatRaster} (3D) or
\code{terra::SpatRasterDataset} (4D) object, with all relevant structural
metadata set. Package \code{terra} must be installed for this to work.
\item \code{data.table()}: The data is returned as a \code{data.table}, with all data
points on individual rows. Metadata is not maintained. Package \code{data.table}
must be installed for this to work.

The temporal axis of the data, if present, may be summarised using the
\code{summarise()} method. The data is returned as a new \code{CFArray} instance.

In general, the metadata from the netCDF resource will be lost when
exporting to a different format insofar as those metadata are not
recognized by the different format.
}
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFVariableBase]{ncdfCF::CFVariableBase}} -> \code{CFArray}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{dimnames}}{(read-only) Retrieve dimnames of the data object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFArray-new}{\code{CFArray$new()}}
\item \href{#method-CFArray-print}{\code{CFArray$print()}}
\item \href{#method-CFArray-raw}{\code{CFArray$raw()}}
\item \href{#method-CFArray-array}{\code{CFArray$array()}}
\item \href{#method-CFArray-append}{\code{CFArray$append()}}
\item \href{#method-CFArray-terra}{\code{CFArray$terra()}}
\item \href{#method-CFArray-data.table}{\code{CFArray$data.table()}}
\item \href{#method-CFArray-save}{\code{CFArray$save()}}
\item \href{#method-CFArray-clone}{\code{CFArray$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="add_coordinates"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-add_coordinates'><code>ncdfCF::CFObject$add_coordinates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariableBase" data-id="profile"><a href='../../ncdfCF/html/CFVariableBase.html#method-CFVariableBase-profile'><code>ncdfCF::CFVariableBase$profile()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariableBase" data-id="summarise"><a href='../../ncdfCF/html/CFVariableBase.html#method-CFVariableBase-summarise'><code>ncdfCF::CFVariableBase$summarise()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariableBase" data-id="time"><a href='../../ncdfCF/html/CFVariableBase.html#method-CFVariableBase-time'><code>ncdfCF::CFVariableBase$time()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$new(name, group, values, values_type, axes, crs, attributes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the object.}

\item{\code{group}}{The group that this data should live in. This is usually an
in-memory group, but it could be a regular group if the data is
prepared for writing into a new netCDF file.}

\item{\code{values}}{The data of this object. The structure of the data depends
on the method that produced it.}

\item{\code{values_type}}{The unpacked netCDF data type for this object.}

\item{\code{axes}}{A \code{list} of \link{CFAxis} descendant instances that describe the
axes of the argument \code{values}.}

\item{\code{crs}}{The \link{CFGridMapping} instance of this data object, or \code{NULL}
when no grid mapping is available.}

\item{\code{attributes}}{A \code{data.frame} with the attributes associated with the
data in argument \code{values}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-print"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the data object to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed on to other functions. Of particular interest
is \verb{width = } to indicate a maximum width of attribute columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-raw"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-raw}{}}}
\subsection{Method \code{raw()}}{
Retrieve the data in the object exactly as it was produced
by the operation on \code{CFVariable}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$raw()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The data in the object. This is usually an \code{array} with the
contents along axes varying.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-array"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-array}{}}}
\subsection{Method \code{array()}}{
Retrieve the data in the object in the form of an R array,
with axis ordering Y-X-others and Y values going from the top down.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$array()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{array} of data in R ordering.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-append"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-append}{}}}
\subsection{Method \code{append()}}{
Append the data from another \code{CFArray} instance to the
current instance, along one of the axes. The operation will only
succeed if the axes other than the one to append along have the same
coordinates and the coordinates of the axis to append along have to be
monotonically increasing or decreasing after appending.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$append(from, along)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{The \code{CFArray} instance to append from.}

\item{\code{along}}{The name of the axis to append along. This must be a single
character string and the named axis has to be present both in \code{self}
and in the \code{CFArray} instance in argument \code{from}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly, with the arrays from \code{self} and \code{from}
appended.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-terra"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-terra}{}}}
\subsection{Method \code{terra()}}{
Convert the data to a \code{terra::SpatRaster} (3D) or a
\code{terra::SpatRasterDataset} (4D) object. The data
will be oriented to North-up. The 3rd dimension in the data will become
layers in the resulting \code{SpatRaster}, any 4th dimension the data sets.
The \code{terra} package needs to be installed for this method to work.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$terra()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{terra::SpatRaster} or \code{terra::SpatRasterDataset} instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-data.table"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-data.table}{}}}
\subsection{Method \code{data.table()}}{
Retrieve the data in the object in the form of a
\code{data.table}. The \code{data.table} package needs to be installed for this
method to work.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$data.table(var_as_column = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var_as_column}}{Logical to flag if the name of the variable should
become a column (\code{TRUE}) or be used as the name of the column with the
data values (\code{FALSE}, default). Including the name of the variable as a
column is useful when multiple \code{data.table}s are merged into one.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with all data points in individual rows. All axes
will become columns. Two attributes are added: \code{name} indicates the
long name of this data variable, \code{units} indicates the physical unit of
the data values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-save"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-save}{}}}
\subsection{Method \code{save()}}{
Save the data object to a netCDF file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$save(fn, pack = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{The name of the netCDF file to create.}

\item{\code{pack}}{Logical to indicate if the data should be packed. Packing is
only useful for numeric data; packing is not performed on integer values.
Packing is always to the "NC_SHORT" data type, i.e. 16-bits per value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFArray-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFArray-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFArray$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
