% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{spatial.plot}
\alias{spatial.plot}
\title{Simple wrapper around symbols to visualize spatial data}
\usage{
spatial.plot(x, y, z, ctr = TRUE, add = FALSE, inches = 0.2, ...)
}
\arguments{
\item{x}{vector of length n representing the x coordinates.}

\item{y}{vector of length n representing the y coordinates.}

\item{z}{vector of n representing the observation at each location.}

\item{ctr}{If TRUE, observations will be centered before plotting (zero-sized symbols represents average observations); if FALSE, the original observations are used.}

\item{add}{If TRUE, a lisa-plot will be added to a pre-existing plot.}

\item{inches}{scales the size of the symbols}

\item{\dots}{other arguments}
}
\value{
A bubble-plot of the spatial data is produced.
}
\description{
\code{spatial.plot} is a quick function to visualize spatial data using bubble plots
}
\details{
This is a simple function to visualize spatial data. Positive (or above average) observations are shown by red circles, Negative (or below average) observations are shown as black squares. For hot/coldspot analysis using Local indicators of spatial association use \code{\link{lisa}}.
}
\examples{
# first generate some sample data
x <- expand.grid(1:20, 1:5)[, 1]
y <- expand.grid(1:20, 1:5)[, 2]

# z data from an exponential random field
z <- rmvn.spa(x = x, y = y, p = 2, method = "gaus")

# plot data
\dontrun{spatial.plot(x = x, y = y, z = z, ctr = FALSE)}
}
\references{
Ripley, B.D. (1987). Stochastic Simulation. Wiley.
}
\seealso{
\code{\link{lisa}}
}
\author{
Ottar N. Bjornstad \email{onb1@psu.edu}
}
\keyword{spatial}
