% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem.R
\name{nem}
\alias{nem}
\title{Generating networks according to the selected local network mechanisms}
\usage{
nem(X, formula, theta, k = 5000, q, b = 0.25)
}
\arguments{
\item{X}{Initial network; of class \code{matrix}.}

\item{formula}{The list of local netork mechanisms to be considered.}

\item{theta}{A vector with the mechanisms' weights/strengths.}

\item{k}{The number of iterations.}

\item{q}{The probability of establishing a link.}

\item{b}{The share of alters among which an actor (i.e., ego) chooses to create or break a tie.}
}
\value{
The list with the following elements:
\itemize{
\item \code{initialNetwork} - Initial network; of class \code{matrix}.
\item \code{finalNetwork} - Final (generated) network; of class \code{matrix}.
\item \code{formula} - The list of functions that define mechanisms used.
\item \code{theta} - A vector with the mechanisms' weights/strengths used.
\item \code{k} - The number of iterations.
\item \code{q} - The probability of establishing a link.
\item \code{b} - The share of alters among which an actor (i.e., ego) chooses to create or break a tie.
}
}
\description{
It generates random network considering the selected local network mechanisms.
}
\examples{
formula <- list(mutuality, popularity, assortativity)
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
nem(X = X, formula = formula, theta = c(1, 1, 1), k = 100, q = 0.25)
}
\references{
Cugmas, M., Žiberna, A., & Ferligoj, A. (2019). Mechanisms generating asymmetric core-cohesive blockmodels. Advances in Methodology and Statistics, 16(1), 17-41.
}
\author{
Marjan Cugmas and Aleš Žiberna
}
