% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_01.R
\name{safety_01}
\alias{safety_01}
\title{Safety-01 Calculation}
\usage{
safety_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  eresponse_24_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{Column name containing the unique patient record
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column containing age.}

\item{epatient_16_col}{Column for age units.}

\item{eresponse_05_col}{Column containing response mode codes (e.g., 911
response codes).}

\item{eresponse_24_col}{Column detailing additional response descriptors as
text.}

\item{...}{arguments passed on to summarize.}
}
\value{
A tibble summarizing results for the Adults, Peds, and all records
with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (Adults, Peds, All).
\code{numerator}: Count of 911 responses where "lights and sirens" were not used
in an EMS dataset.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of 911 responses where "lights and sirens" were not used
in an EMS dataset.
\code{prop_label}: Proportion formatted as a percentage with a
specified number of decimal places.
}
\description{
The \code{safety_01} function calculates the proportion of 911 responses where
"lights and sirens" were not used in an EMS dataset. It generates age-based
population summaries, calculating the count and proportion of "lights and
sirens" responses among all incidents, and within adult and pediatric groups.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    eresponse_24 = rep("No Lights or Sirens", 5)
  )

  # Run the function
  safety_01(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    eresponse_24_col = eresponse_24
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
