% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_export.R
\name{neon_export}
\alias{neon_export}
\title{export local neon store as a zip archive}
\usage{
neon_export(
  archive = "neon.zip",
  product = NA,
  table = NA,
  site = NA,
  start_date = NA,
  end_date = NA,
  type = NA,
  ext = NA,
  hash = NULL,
  dir = neon_dir()
)
}
\arguments{
\item{archive}{path to the zip archive to be created.}

\item{product}{Include only files matching this NEON productCode(s)}

\item{table}{Include only files matching this table name (or regex pattern).
(optional).}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{type}{Should we prefer the basic or expanded version of this product?
See details.}

\item{ext}{only match files with this file extension(s)}

\item{hash}{name of a hashing algorithm to check file integrity. Can be
\code{"md5"}, \code{"sha1"}, or \code{"sha256"} currently; or set to \link{NULL} (default)
to skip hash computation.}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}
}
\value{
table of selected files and metadata, from \code{\link[=neon_index]{neon_index()}}, invisibly.
}
\description{
Export all or select files from your neon store as a zip archive.
This can be useful if you want to bypass accessing the API, such as for
archiving the files required for your analysis so that they can be
re-created by other users without an API key, or without waiting for
the individual download, or any other tiem you want to share or
distribute your local store.
}
\seealso{
\code{\link[=neon_import]{neon_import()}}, \code{\link[=neon_citation]{neon_citation()}}
}
