% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_contact.R
\name{set_contact}
\alias{set_contact}
\title{Set contact information for a new record.}
\usage{
set_contact(
  x = NA,
  contactid = NA_integer_,
  familyname = NA_character_,
  leadinginitials = NA_character_,
  givennames = NA_character_,
  contactname = NA_character_,
  suffix = NA_character_,
  ORCID = NA_character_,
  title = NA_character_,
  institution = NA_character_,
  email = NA_character_,
  phone = NA_character_,
  contactstatus = NA_character_,
  fax = NA_character_,
  url = NA_character_,
  address = NA_character_,
  notes = NA_character_
)
}
\arguments{
\item{x}{Object to be set as a contact}

\item{contactid}{An arbitrary Contact identification number.}

\item{familyname}{Family or surname name of a person.}

\item{leadinginitials}{Leading initials for given or forenames
without spaces (e.g. \code{G.G.}).}

\item{givennames}{Given or forenames of a person (e.g.
\code{George Gaylord}). Initials with spaces are used if full
given names are not known (e.g. \code{G. G}).}

\item{contactname}{Full name of a person (e.g. \code{George Gaylord Simpson}).}

\item{suffix}{Suffix of a person’s name (e.g. \code{Jr.}, \code{III}).}

\item{ORCID}{A unique ORCID (see \url{https://orcid.org}).}

\item{title}{A person’s title (e.g. \code{Dr.}, \code{Prof.},
\code{Prof. Dr}).}

\item{institution}{The institution where an individual works.}

\item{email}{An individuals email address}

\item{phone}{Their phone number}

\item{contactstatus}{Are they "active" or "retired"?}

\item{fax}{Do people still use fax machines?}

\item{url}{Their homepage}

\item{address}{A physical address}

\item{notes}{Notes about the individual}
}
\value{
\code{contact} object
}
\description{
Create a new contact for a record.
Within Neotoma all chronologies have unique numeric identifiers.
Within R, because of the need to use the indentifiers across objects,
and because we want to avoid conflicts between naming systems, a
universally unique identifier (UUID) is created for the object ID.This is not
to be updated to the database.
}
