% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findrelation.R
\name{findrelation}
\alias{findrelation}
\title{Find relationship between any two variables}
\usage{
findrelation(iVar, iResp, criterion = "adj.R2", modelNames, str = FALSE,
  cRes.all, cRes.best, cRes.print, x, nlsInits, nRes)
}
\arguments{
\item{iVar}{The first parameter.}

\item{iResp}{The second parameter.}

\item{criterion}{What model fit parameter is used for ranking? (Default: adj.R2)}

\item{modelNames}{A vector of model names chosen from "SL", "Quad", "SQuad", "Exp", "Log", "nls","CP"}

\item{str}{TRUE/FALSE Is this a 'strength' type model fitting? (whether to use ^2 and sqrt functions)}

\item{cRes.all}{A dataframe of all results, passed in by the netSEMm function}

\item{cRes.best}{A dataframe of best results, passed in by the netSEMm function}

\item{cRes.print}{A dataframe of results to print, passed in by the netSEMm function}

\item{x}{A dataframe of data values, passed in by the netSEMm function}

\item{nlsInits}{A vector of nls initialization coefficients, passed in by the netSEMm function}

\item{nRes}{number of cells in the print variable, value passed in by the netSEmm function}
}
\value{
a list of the following items: 
\itemize{
  \item "cRes.all": A dataframe of all results.
  \item "cRes.best": A dataframe of best results.
  \item "cRes.print": A dataframe of results to print
}
}
\description{
Find relationship between any two variables.
}
