#include <Rcpp.h>
using namespace Rcpp;

double sumMatrix(NumericMatrix matrix);

double getVectorMean(NumericVector vector);

double getSumLogExp(NumericVector trials, 
                    NumericVector XBetaStar, 
                    NumericVector resultantVByVRandomEffects, 
                    NumericVector resultantWByURandomEffects);

double vectorTransposeVectorMultiplicationRcpp(NumericVector vectorOne, 
                                               NumericVector vectorTwo);

NumericVector matrixVectorMultiplicationRcpp(NumericMatrix matrix, 
                                             NumericVector vector);

NumericVector getSubvector(NumericVector vector,
                           int startIndex,
                           int endIndex);

NumericVector getSubvectorIndecies(NumericVector vector,
                                   NumericVector indecies);

NumericVector getNonZeroEntries(NumericVector vector);

NumericVector doubleVectorMultiplicationRcpp(double number, 
                                             NumericVector vector);

double getSumVector(NumericVector vector);

NumericVector getExp(NumericVector logTheta);

double getSumLogExpIndecies(NumericVector trials,
                            NumericVector XBetaStar,
                            NumericVector resultantVByVRandomEffects,
                            NumericVector resultantWByURandomEffects,
                            NumericVector indecies);

double getSumExpNetwork(NumericVector XBetaStar, 
                        NumericVector resultantWByURandomEffects);

double getSumExpNetworkIndecies(NumericVector XBetaStar,
                                NumericVector resultantWByURandomEffects,
                                NumericVector uRandomEffectRepeatedVector,
                                NumericVector indecies);

NumericVector getMeanCenteredRandomEffects(NumericVector vector);

NumericMatrix matrixInverseRcppConversion(NumericMatrix matrix);

NumericVector eigenValuesRcppConversion(NumericMatrix matrix);

NumericMatrix matrixMatrixAdditionRcpp(NumericMatrix matrix1, 
                                       NumericMatrix matrix2);

NumericMatrix doubleMatrixMultiplicationRcpp(double number, 
                                             NumericMatrix matrix);

NumericMatrix getDiagonalMatrix(NumericVector vector);

NumericMatrix vectorVectorTransposeMultiplicationRcpp(NumericVector vectorOne, 
                                                      NumericVector vectorTwo);

NumericVector getExpDividedByOnePlusExp(NumericVector logitTheta);

NumericMatrix matrixMatrixSubtractionRcpp(NumericMatrix matrix1, 
                                          NumericMatrix matrix2);

double getSumExpNetworkLeroux(NumericVector XBetaStar, 
                              NumericVector resultantVByVRandomEffects, 
                              NumericVector resultantWByURandomEffects);

double getSumExpNetworkLerouxIndecies(NumericVector XBetaStar,
                                      NumericVector resultantVByVRandomEffects,
                                      NumericVector resultantWByURandomEffects,
                                      NumericVector indecies);

NumericMatrix kroneckerRcppConversion(NumericMatrix matrix1,
                                      NumericMatrix matrix2);

NumericMatrix choleskyDecompositionRcppConversion(NumericMatrix matrix);

List getMultivariateBernoulliNetworkLerouxDIC(NumericMatrix standardizedX,
                                              NumericVector y,
                                              NumericMatrix V,
                                              NumericMatrix W,
                                              NumericMatrix betaSamples,
                                              NumericMatrix vRandomEffectsSamples,
                                              NumericMatrix uRandomEffectsSamples,
                                              NumericMatrix logLikelihoodSamples,
                                              int numberOfResponses);

List getMultivariateBinomialNetworkLerouxFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                                       NumericVector trials,
                                                                                       NumericVector y,
                                                                                       NumericMatrix spatialAssignment,
                                                                                       NumericMatrix W,
                                                                                       NumericVector beta,
                                                                                       NumericVector spatialRandomEffects,
                                                                                       NumericVector uRandomEffects,
                                                                                       int numberOfResponses);

List univariatePoissonNetworkBetaUpdate(NumericMatrix standardizedX,
                                        NumericVector y,
                                        const int numberOfRowsInX,
                                        const int numberOfColumnsInX,
                                        NumericMatrix WInTripletForm,
                                        const int numberOfRowsInWTripletForm,
                                        NumericVector beta,
                                        NumericVector uRandomEffects,
                                        NumericVector meanBetaPrior,
                                        NumericVector covarianceBetaPrior,
                                        const int numberOfBetaBlocks,
                                        const int maxBetaBlockSize,
                                        NumericVector betaTuningParameter,
                                        NumericVector betaAcceptanceRate,
                                        NumericVector numberOfAcceptedBetaDraws,
                                        NumericVector numberOfAllAcceptedBetaDraws,
                                        int currentNumberOfIterations);

List univariatePoissonNetworkURandomEffectsUpdate(NumericMatrix standardizedX,
                                                  NumericMatrix W,
                                                  NumericVector y,
                                                  const int numberOfRowsInX,
                                                  const int numberOfColumnsInX,
                                                  NumericMatrix WInTripletForm,
                                                  const int numberOfRowsInWTripletForm,
                                                  NumericVector beta,
                                                  NumericVector uRandomEffects,
                                                  double sigmaSquaredU,
                                                  NumericVector uRandomEffectsTuningParameters,
                                                  NumericVector uRandomEffectsAcceptanceRate,
                                                  NumericVector numberOfAcceptedUREDraws,
                                                  NumericVector numberOfAllAcceptedUREDraws,
                                                  int currentNumberOfIterations, 
                                                  bool centerURandomEffects);

List getUnivariatePoissonNetworkFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                              NumericVector y,
                                                                              NumericMatrix W,
                                                                              NumericVector beta,
                                                                              NumericVector uRandomEffects);
double univariatePoissonNetworkSigmaSquaredUpdate(NumericVector randomEffects,
                                                  double a1,
                                                  double b1);

List univariatePoissonNetworkSingleUpdate(NumericMatrix standardizedX,
                                          NumericVector y,
                                          NumericMatrix W,
                                          NumericMatrix WInTripletForm,
                                          NumericVector beta,
                                          NumericVector uRandomEffects,
                                          double sigmaSquaredU,
                                          NumericVector meanBetaPrior,
                                          NumericVector covarianceBetaPrior,
                                          const int numberOfBetaBlocks,
                                          const int maxBetaBlockSize,
                                          NumericVector betaTuningParameter,
                                          NumericVector betaAcceptanceRate,
                                          NumericVector numberOfAcceptedBetaDraws,
                                          NumericVector numberOfAllAcceptedBetaDraws,
                                          NumericVector uRandomEffectsTuningParameters,
                                          NumericVector uRandomEffectsAcceptanceRate,
                                          NumericVector numberOfAcceptedUREDraws,
                                          NumericVector numberOfAllAcceptedUREDraws,
                                          double a1,
                                          double b1,
                                          int currentNumberOfIterations,
                                          bool betaFixed,
                                          bool uRandomEffectsFixed,
                                          bool sigmaSquaredUFixed,
                                          NumericVector trueBetaValues,
                                          NumericVector trueURandomEffectsValues,
                                          double trueSigmaSquaredUValues,
                                          bool centerURandomEffects);

List univariatePoissonNetworkAllUpdate(NumericMatrix standardizedX,
                                       NumericVector y,
                                       NumericMatrix W,
                                       NumericMatrix WInTripletForm,
                                       NumericVector beta,
                                       NumericVector uRandomEffects,
                                       double sigmaSquaredU,
                                       NumericVector meanBetaPrior,
                                       NumericVector covarianceBetaPrior,
                                       const int numberOfBetaBlocks,
                                       const int maxBetaBlockSize,
                                       NumericVector betaTuningParameter,
                                       NumericVector betaAcceptanceRate,
                                       NumericVector numberOfAcceptedBetaDraws,
                                       NumericVector numberOfAllAcceptedBetaDraws,
                                       NumericVector uRandomEffectsTuningParameters,
                                       NumericVector uRandomEffectsAcceptanceRate,
                                       NumericVector numberOfAcceptedUREDraws,
                                       NumericVector numberOfAllAcceptedUREDraws,
                                       double a1,
                                       double b1,
                                       int currentNumberOfIterations,
                                       const int numberOfSamples,
                                       const int burnin,
                                       const int thin,
                                       bool betaFixed,
                                       bool uRandomEffectsFixed,
                                       bool sigmaSquaredUFixed,
                                       NumericVector trueBetaValues,
                                       NumericVector trueURandomEffectsValues,
                                       double trueSigmaSquaredUValues,
                                       bool centerURandomEffects);

List getUnivariatePoissonNetworkDIC(NumericMatrix standardizedX,
                                    NumericVector y,
                                    NumericMatrix W,
                                    NumericMatrix betaSamples,
                                    NumericMatrix uRandomEffectsSamples,
                                    NumericMatrix logLikelihoodSamples);
  
List univariateBinomialNetworkLerouxBetaUpdate(NumericMatrix standardizedX,
                                               NumericVector trials,
                                               NumericVector y,
                                               const int numberOfRowsInX,
                                               const int numberOfColumnsInX,
                                               NumericMatrix spatialAssignmentMatrixInTripletForm,
                                               NumericMatrix WInTripletForm,
                                               const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                               const int numberOfRowsInWTripletForm,
                                               NumericVector beta,
                                               NumericVector spatialRandomEffects,
                                               NumericVector uRandomEffects,
                                               double covarianceBetaPrior,
                                               const int numberOfBetaBlocks,
                                               const int maxBetaBlockSize,
                                               NumericVector betaTuningParameter,
                                               NumericVector betaAcceptanceRate,
                                               NumericVector numberOfAcceptedBetaDraws,
                                               NumericVector numberOfAllAcceptedBetaDraws,
                                               int currentNumberOfIterations);

List univariateBinomialNetworkLerouxSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                               NumericMatrix spatialAssignment,
                                                               NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                               NumericVector trials,
                                                               NumericVector y,
                                                               const int numberOfRowsInX,
                                                               const int numberOfColumnsInX,
                                                               const int numberOfSpatialAreas,
                                                               NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                               NumericMatrix WInTripletForm,
                                                               const int numberOfRowsInSquareSpatialNeighbourhoodMatrix,
                                                               const int numberOfRowsInWTripletForm,
                                                               NumericVector beta,
                                                               NumericVector spatialRandomEffects,
                                                               NumericVector uRandomEffects,
                                                               double spatialTauSquared,
                                                               double spatialRho,
                                                               NumericVector spatialRandomEffectsTuningParameters,
                                                               NumericVector spatialRandomEffectsAcceptanceRate,
                                                               NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                               NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                               int currentNumberOfIterations,
                                                               bool centerSpatialRandomEffects);

List univariateBinomialNetworkLerouxURandomEffectsUpdate(NumericMatrix standardizedX,
                                                         NumericMatrix W,
                                                         NumericVector trials,
                                                         NumericVector y,
                                                         const int numberOfRowsInX,
                                                         const int numberOfColumnsInX,
                                                         NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                         NumericMatrix WInTripletForm,
                                                         const int numberOfRowsInSpatialAssignmentMatrixInTripletForm,
                                                         const int numberOfRowsInWTripletForm,
                                                         NumericVector beta,
                                                         NumericVector spatialRandomEffects,
                                                         NumericVector uRandomEffects,
                                                         double sigmaSquaredU,
                                                         NumericVector uRandomEffectsTuningParameters,
                                                         NumericVector uRandomEffectsAcceptanceRate,
                                                         NumericVector numberOfAcceptedUREDraws,
                                                         NumericVector numberOfAllAcceptedUREDraws,
                                                         int currentNumberOfIterations, 
                                                         bool centerURandomEffects);

List univariateBernoulliNetworkLerouxTauSquaredMHUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                        NumericVector spatialRandomEffects,
                                                        double spatialTauSquared,
                                                        double spatialTauSquaredTuningParameters,
                                                        double spatialTauSquaredAcceptanceRate,
                                                        double numberOfAcceptedSpatialTauSquaredDraws,
                                                        double numberOfAllAcceptedSpatialTauSquaredDraws,
                                                        double spatialRho,
                                                        double a1,
                                                        double b1,
                                                        NumericMatrix QSpatialMatrixComponent1,
                                                        int currentNumberOfIterations);

List univariateBernoulliNetworkLerouxTauMHHalfNormalPriorUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                NumericVector spatialRandomEffects,
                                                                double spatialTau,
                                                                double spatialTauTuningParameters,
                                                                double spatialTauAcceptanceRate,
                                                                double numberOfAcceptedSpatialTauDraws,
                                                                double numberOfAllAcceptedSpatialTauDraws,
                                                                double spatialRho,
                                                                double sigmaSquaredSpatialTau,
                                                                NumericMatrix QSpatialMatrixComponent1,
                                                                int currentNumberOfIterations);

List univariateBernoulliNetworkLerouxTauSquaredMHHalfCauchyPriorUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                       NumericVector spatialRandomEffects,
                                                                       double spatialTauSquared,
                                                                       double spatialTauSquaredTuningParameters,
                                                                       double spatialTauSquaredAcceptanceRate,
                                                                       double numberOfAcceptedSpatialTauSquaredDraws,
                                                                       double numberOfAllAcceptedSpatialTauSquaredDraws,
                                                                       double spatialRho,
                                                                       double scaleSpatialTau,
                                                                       NumericMatrix QSpatialMatrixComponent1,
                                                                       int currentNumberOfIterations);

List univariateBinomialNetworkLerouxRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                               NumericVector spatialRandomEffects,
                                               double spatialTauSquared,
                                               double spatialRho,
                                               double spatialRhoTuningParameters,
                                               double spatialRhoAcceptanceRate,
                                               double numberOfAcceptedSpatialRhoDraws,
                                               double numberOfAllAcceptedSpatialRhoDraws,
                                               NumericMatrix QSpatialMatrixComponent1,
                                               NumericVector QSpatialMatrixComponent1EigenValues,
                                               int currentNumberOfIterations);

double univariateBinomialNetworkLerouxSigmaSquaredUpdate(NumericVector randomEffects,
                                                          double a2,
                                                          double b2);

List getUnivariateBinomialNetworkLerouxFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                                     NumericVector trials,
                                                                                     NumericVector y,
                                                                                     NumericMatrix spatialAssignment,
                                                                                     NumericMatrix W,
                                                                                     NumericVector beta,
                                                                                     NumericVector spatialRandomEffects,
                                                                                     NumericVector uRandomEffects);

List getUnivariateBinomialNetworkLerouxDIC(NumericMatrix standardizedX,
                                           NumericVector trials,
                                           NumericVector y,
                                           NumericMatrix spatialAssignment,
                                           NumericMatrix W,
                                           NumericMatrix betaSamples,
                                           NumericMatrix spatialRandomEffectsSamples,
                                           NumericMatrix uRandomEffectsSamples,
                                           NumericMatrix logLikelihoodSamples);

List univariateBernoulliNetworkLerouxTauMHSingleUpdate(NumericMatrix standardizedX,
                                                       NumericVector y,
                                                       NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                       NumericMatrix spatialAssignment,
                                                       NumericMatrix W,
                                                       const int numberOfSpatialAreas,
                                                       NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                       NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                       NumericMatrix WInTripletForm,
                                                       NumericVector beta,
                                                       NumericVector spatialRandomEffects,
                                                       NumericVector uRandomEffects,
                                                       double spatialTauSquared,
                                                       double spatialRho,
                                                       double sigmaSquaredU,
                                                       double covarianceBetaPrior,
                                                       const int numberOfBetaBlocks,
                                                       const int maxBetaBlockSize,
                                                       NumericVector betaTuningParameter,
                                                       NumericVector betaAcceptanceRate,
                                                       NumericVector numberOfAcceptedBetaDraws,
                                                       NumericVector numberOfAllAcceptedBetaDraws,
                                                       NumericVector spatialRandomEffectsTuningParameters,
                                                       NumericVector spatialRandomEffectsAcceptanceRate,
                                                       NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                       NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                       NumericVector uRandomEffectsTuningParameters,
                                                       NumericVector uRandomEffectsAcceptanceRate,
                                                       NumericVector numberOfAcceptedUREDraws,
                                                       NumericVector numberOfAllAcceptedUREDraws,
                                                       double spatialTauSquaredTuningParameters,
                                                       double spatialTauSquaredAcceptanceRate,
                                                       int numberOfAcceptedSpatialTauSquaredDraws,
                                                       int numberOfAllAcceptedSpatialTauSquaredDraws,
                                                       double spatialRhoTuningParameters,
                                                       double spatialRhoAcceptanceRate,
                                                       int numberOfAcceptedSpatialRhoDraws,
                                                       int numberOfAllAcceptedSpatialRhoDraws,
                                                       NumericMatrix QSpatialMatrixComponent1,
                                                       NumericVector QSpatialMatrixComponent1EigenValues,
                                                       double a1,
                                                       double b1,
                                                       double a2,
                                                       double b2,
                                                       int currentNumberOfIterations,
                                                       bool betaFixed,
                                                       bool spatialRandomEffectsFixed,
                                                       bool uRandomEffectsFixed,
                                                       bool spatialTauSquaredFixed,
                                                       bool spatialRhoFixed,
                                                       bool sigmaSquaredUFixed,
                                                       NumericVector trueBetaValues,
                                                       NumericVector trueSpatialRandomEffectsValues,
                                                       NumericVector trueURandomEffectsValues,
                                                       double trueSpatialTauSquaredValues,
                                                       double trueSpatialRhoValues,
                                                       double trueSigmaSquaredUValues,
                                                       bool centerSpatialRandomEffects,
                                                       bool centerURandomEffects);

List univariateBernoulliNetworkLerouxTauMHAllUpdate(NumericMatrix standardizedX,
                                                    NumericVector y,
                                                    NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                    NumericMatrix spatialAssignment,
                                                    NumericMatrix W,
                                                    const int numberOfSpatialAreas,
                                                    NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                    NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                    NumericMatrix WInTripletForm,
                                                    NumericVector beta,
                                                    NumericVector spatialRandomEffects,
                                                    NumericVector uRandomEffects,
                                                    double spatialTauSquared,
                                                    double spatialRho,
                                                    double sigmaSquaredU,
                                                    double covarianceBetaPrior,
                                                    const int numberOfBetaBlocks,
                                                    const int maxBetaBlockSize,
                                                    NumericVector betaTuningParameter,
                                                    NumericVector betaAcceptanceRate,
                                                    NumericVector numberOfAcceptedBetaDraws,
                                                    NumericVector numberOfAllAcceptedBetaDraws,
                                                    NumericVector spatialRandomEffectsTuningParameters,
                                                    NumericVector spatialRandomEffectsAcceptanceRate,
                                                    NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                    NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                    NumericVector uRandomEffectsTuningParameters,
                                                    NumericVector uRandomEffectsAcceptanceRate,
                                                    NumericVector numberOfAcceptedUREDraws,
                                                    NumericVector numberOfAllAcceptedUREDraws,
                                                    double spatialTauSquaredTuningParameters,
                                                    double spatialTauSquaredAcceptanceRate,
                                                    int numberOfAcceptedSpatialTauSquaredDraws,
                                                    int numberOfAllAcceptedSpatialTauSquaredDraws,
                                                    double spatialRhoTuningParameters,
                                                    double spatialRhoAcceptanceRate,
                                                    int numberOfAcceptedSpatialRhoDraws,
                                                    int numberOfAllAcceptedSpatialRhoDraws,
                                                    double a1,
                                                    double b1,
                                                    double a2,
                                                    double b2,
                                                    int currentNumberOfIterations,
                                                    const int numberOfSamples,
                                                    const int burnin,
                                                    const int thin,
                                                    bool betaFixed,
                                                    bool spatialRandomEffectsFixed,
                                                    bool uRandomEffectsFixed,
                                                    bool spatialTauSquaredFixed,
                                                    bool spatialRhoFixed,
                                                    bool sigmaSquaredUFixed,
                                                    NumericVector trueBetaValues,
                                                    NumericVector trueSpatialRandomEffectsValues,
                                                    NumericVector trueURandomEffectsValues,
                                                    double trueSpatialTauSquaredValues,
                                                    double trueSpatialRhoValues,
                                                    double trueSigmaSquaredUValues,
                                                    bool centerSpatialRandomEffects,
                                                    bool centerURandomEffects);

List univariateBernoulliNetworkLerouxTauMHHalfNormalPriorSingleUpdate(NumericMatrix standardizedX,
                                                                      NumericVector y,
                                                                      NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                      NumericMatrix spatialAssignment,
                                                                      NumericMatrix W,
                                                                      const int numberOfSpatialAreas,
                                                                      NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                      NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                      NumericMatrix WInTripletForm,
                                                                      NumericVector beta,
                                                                      NumericVector spatialRandomEffects,
                                                                      NumericVector uRandomEffects,
                                                                      double spatialTau,
                                                                      double spatialRho,
                                                                      double sigmaSquaredU,
                                                                      double covarianceBetaPrior,
                                                                      const int numberOfBetaBlocks,
                                                                      const int maxBetaBlockSize,
                                                                      NumericVector betaTuningParameter,
                                                                      NumericVector betaAcceptanceRate,
                                                                      NumericVector numberOfAcceptedBetaDraws,
                                                                      NumericVector numberOfAllAcceptedBetaDraws,
                                                                      NumericVector spatialRandomEffectsTuningParameters,
                                                                      NumericVector spatialRandomEffectsAcceptanceRate,
                                                                      NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                      NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                      NumericVector uRandomEffectsTuningParameters,
                                                                      NumericVector uRandomEffectsAcceptanceRate,
                                                                      NumericVector numberOfAcceptedUREDraws,
                                                                      NumericVector numberOfAllAcceptedUREDraws,
                                                                      double spatialTauTuningParameters,
                                                                      double spatialTauAcceptanceRate,
                                                                      int numberOfAcceptedSpatialTauDraws,
                                                                      int numberOfAllAcceptedSpatialTauDraws,
                                                                      double spatialRhoTuningParameters,
                                                                      double spatialRhoAcceptanceRate,
                                                                      int numberOfAcceptedSpatialRhoDraws,
                                                                      int numberOfAllAcceptedSpatialRhoDraws,
                                                                      NumericMatrix QSpatialMatrixComponent1,
                                                                      NumericVector QSpatialMatrixComponent1EigenValues,
                                                                      double sigmaSquaredSpatialTau,
                                                                      double a2,
                                                                      double b2,
                                                                      int currentNumberOfIterations,
                                                                      bool betaFixed,
                                                                      bool spatialRandomEffectsFixed,
                                                                      bool uRandomEffectsFixed,
                                                                      bool spatialTauFixed,
                                                                      bool spatialRhoFixed,
                                                                      bool sigmaSquaredUFixed,
                                                                      NumericVector trueBetaValues,
                                                                      NumericVector trueSpatialRandomEffectsValues,
                                                                      NumericVector trueURandomEffectsValues,
                                                                      double trueSpatialTauValues,
                                                                      double trueSpatialRhoValues,
                                                                      double trueSigmaSquaredUValues,
                                                                      bool centerSpatialRandomEffects,
                                                                      bool centerURandomEffects);

List univariateBernoulliNetworkLerouxTauMHHalfNormalPriorAllUpdate(NumericMatrix standardizedX,
                                                                   NumericVector y,
                                                                   NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                   NumericMatrix spatialAssignment,
                                                                   NumericMatrix W,
                                                                   const int numberOfSpatialAreas,
                                                                   NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                   NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                   NumericMatrix WInTripletForm,
                                                                   NumericVector beta,
                                                                   NumericVector spatialRandomEffects,
                                                                   NumericVector uRandomEffects,
                                                                   double spatialTau,
                                                                   double spatialRho,
                                                                   double sigmaSquaredU,
                                                                   double covarianceBetaPrior,
                                                                   const int numberOfBetaBlocks,
                                                                   const int maxBetaBlockSize,
                                                                   NumericVector betaTuningParameter,
                                                                   NumericVector betaAcceptanceRate,
                                                                   NumericVector numberOfAcceptedBetaDraws,
                                                                   NumericVector numberOfAllAcceptedBetaDraws,
                                                                   NumericVector spatialRandomEffectsTuningParameters,
                                                                   NumericVector spatialRandomEffectsAcceptanceRate,
                                                                   NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                   NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                   NumericVector uRandomEffectsTuningParameters,
                                                                   NumericVector uRandomEffectsAcceptanceRate,
                                                                   NumericVector numberOfAcceptedUREDraws,
                                                                   NumericVector numberOfAllAcceptedUREDraws,
                                                                   double spatialTauTuningParameters,
                                                                   double spatialTauAcceptanceRate,
                                                                   int numberOfAcceptedSpatialTauDraws,
                                                                   int numberOfAllAcceptedSpatialTauDraws,
                                                                   double spatialRhoTuningParameters,
                                                                   double spatialRhoAcceptanceRate,
                                                                   int numberOfAcceptedSpatialRhoDraws,
                                                                   int numberOfAllAcceptedSpatialRhoDraws,
                                                                   double sigmaSquaredSpatialTau,
                                                                   double a2,
                                                                   double b2,
                                                                   int currentNumberOfIterations,
                                                                   const int numberOfSamples,
                                                                   const int burnin,
                                                                   const int thin,
                                                                   bool betaFixed,
                                                                   bool spatialRandomEffectsFixed,
                                                                   bool uRandomEffectsFixed,
                                                                   bool spatialTauFixed,
                                                                   bool spatialRhoFixed,
                                                                   bool sigmaSquaredUFixed,
                                                                   NumericVector trueBetaValues,
                                                                   NumericVector trueSpatialRandomEffectsValues,
                                                                   NumericVector trueURandomEffectsValues,
                                                                   double trueSpatialTauValues,
                                                                   double trueSpatialRhoValues,
                                                                   double trueSigmaSquaredUValues,
                                                                   bool centerSpatialRandomEffects,
                                                                   bool centerURandomEffects);

double univariateBinomialNetworkLerouxTauSquaredUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                       NumericVector spatialRandomEffects,
                                                       double spatialTauSquared,
                                                       double spatialRho,
                                                       double a1,
                                                       double b1,
                                                       NumericMatrix QSpatialMatrixComponent1);

List univariateBinomialNetworkLerouxSingleUpdate(NumericMatrix standardizedX,
                                                 NumericVector trials,
                                                 NumericVector y,
                                                 NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                 NumericMatrix spatialAssignment,
                                                 NumericMatrix W,
                                                 const int numberOfSpatialAreas,
                                                 NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                 NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                 NumericMatrix WInTripletForm,
                                                 NumericVector beta,
                                                 NumericVector spatialRandomEffects,
                                                 NumericVector uRandomEffects,
                                                 double spatialTauSquared,
                                                 double spatialRho,
                                                 double sigmaSquaredU,
                                                 double covarianceBetaPrior,
                                                 const int numberOfBetaBlocks,
                                                 const int maxBetaBlockSize,
                                                 NumericVector betaTuningParameter,
                                                 NumericVector betaAcceptanceRate,
                                                 NumericVector numberOfAcceptedBetaDraws,
                                                 NumericVector numberOfAllAcceptedBetaDraws,
                                                 NumericVector spatialRandomEffectsTuningParameters,
                                                 NumericVector spatialRandomEffectsAcceptanceRate,
                                                 NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                 NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                 NumericVector uRandomEffectsTuningParameters,
                                                 NumericVector uRandomEffectsAcceptanceRate,
                                                 NumericVector numberOfAcceptedUREDraws,
                                                 NumericVector numberOfAllAcceptedUREDraws,
                                                 double spatialRhoTuningParameters,
                                                 double spatialRhoAcceptanceRate,
                                                 int numberOfAcceptedSpatialRhoDraws,
                                                 int numberOfAllAcceptedSpatialRhoDraws,
                                                 NumericMatrix QSpatialMatrixComponent1,
                                                 NumericVector QSpatialMatrixComponent1EigenValues,
                                                 double a1,
                                                 double b1,
                                                 double a2,
                                                 double b2,
                                                 int currentNumberOfIterations,
                                                 bool betaFixed,
                                                 bool spatialRandomEffectsFixed,
                                                 bool uRandomEffectsFixed,
                                                 bool spatialTauSquaredFixed,
                                                 bool spatialRhoFixed,
                                                 bool sigmaSquaredUFixed,
                                                 NumericVector trueBetaValues,
                                                 NumericVector trueSpatialRandomEffectsValues,
                                                 NumericVector trueURandomEffectsValues,
                                                 double trueSpatialTauSquaredValues,
                                                 double trueSpatialRhoValues,
                                                 double trueSigmaSquaredUValues,
                                                 bool centerSpatialRandomEffects,
                                                 bool centerURandomEffects);

List univariateBinomialNetworkLerouxAllUpdate(NumericMatrix standardizedX,
                                              NumericVector trials,
                                              NumericVector y,
                                              NumericMatrix squareSpatialNeighbourhoodMatrix,
                                              NumericMatrix spatialAssignment,
                                              NumericMatrix W,
                                              const int numberOfSpatialAreas,
                                              NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                              NumericMatrix spatialAssignmentMatrixInTripletForm,
                                              NumericMatrix WInTripletForm,
                                              NumericVector beta,
                                              NumericVector spatialRandomEffects,
                                              NumericVector uRandomEffects,
                                              double spatialTauSquared,
                                              double spatialRho,
                                              double sigmaSquaredU,
                                              double covarianceBetaPrior,
                                              const int numberOfBetaBlocks,
                                              const int maxBetaBlockSize,
                                              NumericVector betaTuningParameter,
                                              NumericVector betaAcceptanceRate,
                                              NumericVector numberOfAcceptedBetaDraws,
                                              NumericVector numberOfAllAcceptedBetaDraws,
                                              NumericVector spatialRandomEffectsTuningParameters,
                                              NumericVector spatialRandomEffectsAcceptanceRate,
                                              NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                              NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                              NumericVector uRandomEffectsTuningParameters,
                                              NumericVector uRandomEffectsAcceptanceRate,
                                              NumericVector numberOfAcceptedUREDraws,
                                              NumericVector numberOfAllAcceptedUREDraws,
                                              double spatialRhoTuningParameters,
                                              double spatialRhoAcceptanceRate,
                                              int numberOfAcceptedSpatialRhoDraws,
                                              int numberOfAllAcceptedSpatialRhoDraws,
                                              double a1,
                                              double b1,
                                              double a2,
                                              double b2,
                                              int currentNumberOfIterations,
                                              const int numberOfSamples,
                                              const int burnin,
                                              const int thin,
                                              bool betaFixed,
                                              bool spatialRandomEffectsFixed,
                                              bool uRandomEffectsFixed,
                                              bool spatialTauSquaredFixed,
                                              bool spatialRhoFixed,
                                              bool sigmaSquaredUFixed,
                                              NumericVector trueBetaValues,
                                              NumericVector trueSpatialRandomEffectsValues,
                                              NumericVector trueURandomEffectsValues,
                                              double trueSpatialTauSquaredValues,
                                              double trueSpatialRhoValues,
                                              double trueSigmaSquaredUValues,
                                              bool centerSpatialRandomEffects,
                                              bool centerURandomEffects);

List univariatePoissonNetworkLerouxBetaUpdate(NumericMatrix standardizedX,
                                              NumericVector y,
                                              const int numberOfRowsInX,
                                              const int numberOfColumnsInX,
                                              NumericMatrix spatialAssignmentMatrixInTripletForm,
                                              NumericMatrix WInTripletForm,
                                              const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                              const int numberOfRowsInWTripletForm,
                                              NumericVector beta,
                                              NumericVector spatialRandomEffects,
                                              NumericVector uRandomEffects,
                                              double covarianceBetaPrior,
                                              const int numberOfBetaBlocks,
                                              const int maxBetaBlockSize,
                                              NumericVector betaTuningParameter,
                                              NumericVector betaAcceptanceRate,
                                              NumericVector numberOfAcceptedBetaDraws,
                                              NumericVector numberOfAllAcceptedBetaDraws,
                                              int currentNumberOfIterations);

List univariatePoissonNetworkLerouxSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                              NumericMatrix spatialAssignment,
                                                              NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                              NumericVector y,
                                                              const int numberOfRowsInX,
                                                              const int numberOfColumnsInX,
                                                              const int numberOfSpatialAreas,
                                                              NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                              NumericMatrix WInTripletForm,
                                                              const int numberOfRowsInSquareSpatialNeighbourhoodMatrix,
                                                              const int numberOfRowsInWTripletForm,
                                                              NumericVector beta,
                                                              NumericVector spatialRandomEffects,
                                                              NumericVector uRandomEffects,
                                                              double spatialTauSquared,
                                                              double spatialRho,
                                                              NumericVector spatialRandomEffectsTuningParameters,
                                                              NumericVector spatialRandomEffectsAcceptanceRate,
                                                              NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                              NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                              int currentNumberOfIterations,
                                                              bool centerSpatialRandomEffects);

List univariatePoissonNetworkLerouxSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                              NumericMatrix spatialAssignment,
                                                              NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                              NumericVector y,
                                                              const int numberOfRowsInX,
                                                              const int numberOfColumnsInX,
                                                              const int numberOfSpatialAreas,
                                                              NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                              NumericMatrix WInTripletForm,
                                                              const int numberOfRowsInSquareSpatialNeighbourhoodMatrix,
                                                              const int numberOfRowsInWTripletForm,
                                                              NumericVector beta,
                                                              NumericVector spatialRandomEffects,
                                                              NumericVector uRandomEffects,
                                                              double spatialTauSquared,
                                                              double spatialRho,
                                                              NumericVector spatialRandomEffectsTuningParameters,
                                                              NumericVector spatialRandomEffectsAcceptanceRate,
                                                              NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                              NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                              int currentNumberOfIterations,
                                                              bool centerSpatialRandomEffects);

List univariatePoissonNetworkLerouxURandomEffectsUpdate(NumericMatrix standardizedX,
                                                        NumericMatrix W,
                                                        NumericVector y,
                                                        const int numberOfRowsInX,
                                                        const int numberOfColumnsInX,
                                                        NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                        NumericMatrix WInTripletForm,
                                                        const int numberOfRowsInSpatialAssignmentMatrixInTripletForm,
                                                        const int numberOfRowsInWTripletForm,
                                                        NumericVector beta,
                                                        NumericVector spatialRandomEffects,
                                                        NumericVector uRandomEffects,
                                                        double sigmaSquaredU,
                                                        NumericVector uRandomEffectsTuningParameters,
                                                        NumericVector uRandomEffectsAcceptanceRate,
                                                        NumericVector numberOfAcceptedUREDraws,
                                                        NumericVector numberOfAllAcceptedUREDraws,
                                                        int currentNumberOfIterations, 
                                                        bool centerURandomEffects);

List univariatePoissonNetworkLerouxTauSquaredMHUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                      NumericVector spatialRandomEffects,
                                                      double spatialTauSquared,
                                                      double spatialTauSquaredTuningParameters,
                                                      double spatialTauSquaredAcceptanceRate,
                                                      double numberOfAcceptedSpatialTauSquaredDraws,
                                                      double numberOfAllAcceptedSpatialTauSquaredDraws,
                                                      double spatialRho,
                                                      double a1,
                                                      double b1,
                                                      NumericMatrix QSpatialMatrixComponent1,
                                                      int currentNumberOfIterations);

List univariatePoissonNetworkLerouxTauMHHalfNormalPriorUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                              NumericVector spatialRandomEffects,
                                                              double spatialTau,
                                                              double spatialTauTuningParameters,
                                                              double spatialTauAcceptanceRate,
                                                              double numberOfAcceptedSpatialTauDraws,
                                                              double numberOfAllAcceptedSpatialTauDraws,
                                                              double spatialRho,
                                                              double sigmaSquaredSpatialTau,
                                                              NumericMatrix QSpatialMatrixComponent1,
                                                              int currentNumberOfIterations);

List univariatePoissonNetworkLerouxRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                             NumericVector spatialRandomEffects,
                                             double spatialTauSquared,
                                             double spatialRho,
                                             double spatialRhoTuningParameters,
                                             double spatialRhoAcceptanceRate,
                                             double numberOfAcceptedSpatialRhoDraws,
                                             double numberOfAllAcceptedSpatialRhoDraws,
                                             NumericMatrix QSpatialMatrixComponent1,
                                             NumericVector QSpatialMatrixComponent1EigenValues,
                                             int currentNumberOfIterations);

double univariatePoissonNetworkLerouxSigmaSquaredUpdate(NumericVector randomEffects,
                                                        double a2,
                                                        double b2);

List getUnivariatePoissonNetworkLerouxDIC(NumericMatrix standardizedX,
                                          NumericVector y,
                                          NumericMatrix spatialAssignment,
                                          NumericMatrix W,
                                          NumericMatrix betaSamples,
                                          NumericMatrix spatialRandomEffectsSamples,
                                          NumericMatrix uRandomEffectsSamples,
                                          NumericMatrix logLikelihoodSamples);

List getUnivariatePoissonNetworkLerouxFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                                    NumericVector y,
                                                                                    NumericMatrix spatialAssignment,
                                                                                    NumericMatrix W,
                                                                                    NumericVector beta,
                                                                                    NumericVector spatialRandomEffects,
                                                                                    NumericVector uRandomEffects);

List univariatePoissonNetworkLerouxTauMHSingleUpdate(NumericMatrix standardizedX,
                                                     NumericVector y,
                                                     NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                     NumericMatrix spatialAssignment,
                                                     NumericMatrix W,
                                                     const int numberOfSpatialAreas,
                                                     NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                     NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                     NumericMatrix WInTripletForm,
                                                     NumericVector beta,
                                                     NumericVector spatialRandomEffects,
                                                     NumericVector uRandomEffects,
                                                     double spatialTauSquared,
                                                     double spatialRho,
                                                     double sigmaSquaredU,
                                                     double covarianceBetaPrior,
                                                     const int numberOfBetaBlocks,
                                                     const int maxBetaBlockSize,
                                                     NumericVector betaTuningParameter,
                                                     NumericVector betaAcceptanceRate,
                                                     NumericVector numberOfAcceptedBetaDraws,
                                                     NumericVector numberOfAllAcceptedBetaDraws,
                                                     NumericVector spatialRandomEffectsTuningParameters,
                                                     NumericVector spatialRandomEffectsAcceptanceRate,
                                                     NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                     NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                     NumericVector uRandomEffectsTuningParameters,
                                                     NumericVector uRandomEffectsAcceptanceRate,
                                                     NumericVector numberOfAcceptedUREDraws,
                                                     NumericVector numberOfAllAcceptedUREDraws,
                                                     double spatialTauSquaredTuningParameters,
                                                     double spatialTauSquaredAcceptanceRate,
                                                     int numberOfAcceptedSpatialTauSquaredDraws,
                                                     int numberOfAllAcceptedSpatialTauSquaredDraws,
                                                     double spatialRhoTuningParameters,
                                                     double spatialRhoAcceptanceRate,
                                                     int numberOfAcceptedSpatialRhoDraws,
                                                     int numberOfAllAcceptedSpatialRhoDraws,
                                                     NumericMatrix QSpatialMatrixComponent1,
                                                     NumericVector QSpatialMatrixComponent1EigenValues,
                                                     double a1,
                                                     double b1,
                                                     double a2,
                                                     double b2,
                                                     int currentNumberOfIterations,
                                                     bool betaFixed,
                                                     bool spatialRandomEffectsFixed,
                                                     bool uRandomEffectsFixed,
                                                     bool spatialTauSquaredFixed,
                                                     bool spatialRhoFixed,
                                                     bool sigmaSquaredUFixed,
                                                     NumericVector trueBetaValues,
                                                     NumericVector trueSpatialRandomEffectsValues,
                                                     NumericVector trueURandomEffectsValues,
                                                     double trueSpatialTauSquaredValues,
                                                     double trueSpatialRhoValues,
                                                     double trueSigmaSquaredUValues,
                                                     bool centerSpatialRandomEffects,
                                                     bool centerURandomEffects);

List univariatePoissonNetworkLerouxTauMHAllUpdate(NumericMatrix standardizedX,
                                                  NumericVector y,
                                                  NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                  NumericMatrix spatialAssignment,
                                                  NumericMatrix W,
                                                  const int numberOfSpatialAreas,
                                                  NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                  NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                  NumericMatrix WInTripletForm,
                                                  NumericVector beta,
                                                  NumericVector spatialRandomEffects,
                                                  NumericVector uRandomEffects,
                                                  double spatialTauSquared,
                                                  double spatialRho,
                                                  double sigmaSquaredU,
                                                  double covarianceBetaPrior,
                                                  const int numberOfBetaBlocks,
                                                  const int maxBetaBlockSize,
                                                  NumericVector betaTuningParameter,
                                                  NumericVector betaAcceptanceRate,
                                                  NumericVector numberOfAcceptedBetaDraws,
                                                  NumericVector numberOfAllAcceptedBetaDraws,
                                                  NumericVector spatialRandomEffectsTuningParameters,
                                                  NumericVector spatialRandomEffectsAcceptanceRate,
                                                  NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                  NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                  NumericVector uRandomEffectsTuningParameters,
                                                  NumericVector uRandomEffectsAcceptanceRate,
                                                  NumericVector numberOfAcceptedUREDraws,
                                                  NumericVector numberOfAllAcceptedUREDraws,
                                                  double spatialTauSquaredTuningParameters,
                                                  double spatialTauSquaredAcceptanceRate,
                                                  int numberOfAcceptedSpatialTauSquaredDraws,
                                                  int numberOfAllAcceptedSpatialTauSquaredDraws,
                                                  double spatialRhoTuningParameters,
                                                  double spatialRhoAcceptanceRate,
                                                  int numberOfAcceptedSpatialRhoDraws,
                                                  int numberOfAllAcceptedSpatialRhoDraws,
                                                  double a1,
                                                  double b1,
                                                  double a2,
                                                  double b2,
                                                  int currentNumberOfIterations,
                                                  const int numberOfSamples,
                                                  const int burnin,
                                                  const int thin,
                                                  bool betaFixed,
                                                  bool spatialRandomEffectsFixed,
                                                  bool uRandomEffectsFixed,
                                                  bool spatialTauSquaredFixed,
                                                  bool spatialRhoFixed,
                                                  bool sigmaSquaredUFixed,
                                                  NumericVector trueBetaValues,
                                                  NumericVector trueSpatialRandomEffectsValues,
                                                  NumericVector trueURandomEffectsValues,
                                                  double trueSpatialTauSquaredValues,
                                                  double trueSpatialRhoValues,
                                                  double trueSigmaSquaredUValues,
                                                  bool centerSpatialRandomEffects,
                                                  bool centerURandomEffects);

double univariatePoissonNetworkLerouxTauSquaredUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                      NumericVector spatialRandomEffects,
                                                      double spatialTauSquared,
                                                      double spatialRho,
                                                      double a1,
                                                      double b1,
                                                      NumericMatrix QSpatialMatrixComponent1);

List univariatePoissonNetworkLerouxSingleUpdate(NumericMatrix standardizedX,
                                                NumericVector y,
                                                NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                NumericMatrix spatialAssignment,
                                                NumericMatrix W,
                                                const int numberOfSpatialAreas,
                                                NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                NumericMatrix WInTripletForm,
                                                NumericVector beta,
                                                NumericVector spatialRandomEffects,
                                                NumericVector uRandomEffects,
                                                double spatialTauSquared,
                                                double spatialRho,
                                                double sigmaSquaredU,
                                                double covarianceBetaPrior,
                                                const int numberOfBetaBlocks,
                                                const int maxBetaBlockSize,
                                                NumericVector betaTuningParameter,
                                                NumericVector betaAcceptanceRate,
                                                NumericVector numberOfAcceptedBetaDraws,
                                                NumericVector numberOfAllAcceptedBetaDraws,
                                                NumericVector spatialRandomEffectsTuningParameters,
                                                NumericVector spatialRandomEffectsAcceptanceRate,
                                                NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                NumericVector uRandomEffectsTuningParameters,
                                                NumericVector uRandomEffectsAcceptanceRate,
                                                NumericVector numberOfAcceptedUREDraws,
                                                NumericVector numberOfAllAcceptedUREDraws,
                                                double spatialRhoTuningParameters,
                                                double spatialRhoAcceptanceRate,
                                                int numberOfAcceptedSpatialRhoDraws,
                                                int numberOfAllAcceptedSpatialRhoDraws,
                                                NumericMatrix QSpatialMatrixComponent1,
                                                NumericVector QSpatialMatrixComponent1EigenValues,
                                                double a1,
                                                double b1,
                                                double a2,
                                                double b2,
                                                int currentNumberOfIterations,
                                                bool betaFixed,
                                                bool spatialRandomEffectsFixed,
                                                bool uRandomEffectsFixed,
                                                bool spatialTauSquaredFixed,
                                                bool spatialRhoFixed,
                                                bool sigmaSquaredUFixed,
                                                NumericVector trueBetaValues,
                                                NumericVector trueSpatialRandomEffectsValues,
                                                NumericVector trueURandomEffectsValues,
                                                double trueSpatialTauSquaredValues,
                                                double trueSpatialRhoValues,
                                                double trueSigmaSquaredUValues,
                                                bool centerSpatialRandomEffects,
                                                bool centerURandomEffects);

List univariatePoissonNetworkLerouxTauMHHalfNormalPriorSingleUpdate(NumericMatrix standardizedX,
                                                                    NumericVector y,
                                                                    NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                    NumericMatrix spatialAssignment,
                                                                    NumericMatrix W,
                                                                    const int numberOfSpatialAreas,
                                                                    NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                    NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                    NumericMatrix WInTripletForm,
                                                                    NumericVector beta,
                                                                    NumericVector spatialRandomEffects,
                                                                    NumericVector uRandomEffects,
                                                                    double spatialTau,
                                                                    double spatialRho,
                                                                    double sigmaSquaredU,
                                                                    double covarianceBetaPrior,
                                                                    const int numberOfBetaBlocks,
                                                                    const int maxBetaBlockSize,
                                                                    NumericVector betaTuningParameter,
                                                                    NumericVector betaAcceptanceRate,
                                                                    NumericVector numberOfAcceptedBetaDraws,
                                                                    NumericVector numberOfAllAcceptedBetaDraws,
                                                                    NumericVector spatialRandomEffectsTuningParameters,
                                                                    NumericVector spatialRandomEffectsAcceptanceRate,
                                                                    NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                    NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                    NumericVector uRandomEffectsTuningParameters,
                                                                    NumericVector uRandomEffectsAcceptanceRate,
                                                                    NumericVector numberOfAcceptedUREDraws,
                                                                    NumericVector numberOfAllAcceptedUREDraws,
                                                                    double spatialTauTuningParameters,
                                                                    double spatialTauAcceptanceRate,
                                                                    int numberOfAcceptedSpatialTauDraws,
                                                                    int numberOfAllAcceptedSpatialTauDraws,
                                                                    double spatialRhoTuningParameters,
                                                                    double spatialRhoAcceptanceRate,
                                                                    int numberOfAcceptedSpatialRhoDraws,
                                                                    int numberOfAllAcceptedSpatialRhoDraws,
                                                                    NumericMatrix QSpatialMatrixComponent1,
                                                                    NumericVector QSpatialMatrixComponent1EigenValues,
                                                                    double sigmaSquaredSpatialTau,
                                                                    double a2,
                                                                    double b2,
                                                                    int currentNumberOfIterations,
                                                                    bool betaFixed,
                                                                    bool spatialRandomEffectsFixed,
                                                                    bool uRandomEffectsFixed,
                                                                    bool spatialTauFixed,
                                                                    bool spatialRhoFixed,
                                                                    bool sigmaSquaredUFixed,
                                                                    NumericVector trueBetaValues,
                                                                    NumericVector trueSpatialRandomEffectsValues,
                                                                    NumericVector trueURandomEffectsValues,
                                                                    double trueSpatialTauValues,
                                                                    double trueSpatialRhoValues,
                                                                    double trueSigmaSquaredUValues,
                                                                    bool centerSpatialRandomEffects,
                                                                    bool centerURandomEffects);

List univariatePoissonNetworkLerouxTauMHHalfNormalPriorAllUpdate(NumericMatrix standardizedX,
                                                                 NumericVector y,
                                                                 NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                 NumericMatrix spatialAssignment,
                                                                 NumericMatrix W,
                                                                 const int numberOfSpatialAreas,
                                                                 NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                 NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                 NumericMatrix WInTripletForm,
                                                                 NumericVector beta,
                                                                 NumericVector spatialRandomEffects,
                                                                 NumericVector uRandomEffects,
                                                                 double spatialTau,
                                                                 double spatialRho,
                                                                 double sigmaSquaredU,
                                                                 double covarianceBetaPrior,
                                                                 const int numberOfBetaBlocks,
                                                                 const int maxBetaBlockSize,
                                                                 NumericVector betaTuningParameter,
                                                                 NumericVector betaAcceptanceRate,
                                                                 NumericVector numberOfAcceptedBetaDraws,
                                                                 NumericVector numberOfAllAcceptedBetaDraws,
                                                                 NumericVector spatialRandomEffectsTuningParameters,
                                                                 NumericVector spatialRandomEffectsAcceptanceRate,
                                                                 NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                 NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                 NumericVector uRandomEffectsTuningParameters,
                                                                 NumericVector uRandomEffectsAcceptanceRate,
                                                                 NumericVector numberOfAcceptedUREDraws,
                                                                 NumericVector numberOfAllAcceptedUREDraws,
                                                                 double spatialTauTuningParameters,
                                                                 double spatialTauAcceptanceRate,
                                                                 int numberOfAcceptedSpatialTauDraws,
                                                                 int numberOfAllAcceptedSpatialTauDraws,
                                                                 double spatialRhoTuningParameters,
                                                                 double spatialRhoAcceptanceRate,
                                                                 int numberOfAcceptedSpatialRhoDraws,
                                                                 int numberOfAllAcceptedSpatialRhoDraws,
                                                                 double sigmaSquaredSpatialTau,
                                                                 double a2,
                                                                 double b2,
                                                                 int currentNumberOfIterations,
                                                                 const int numberOfSamples,
                                                                 const int burnin,
                                                                 const int thin,
                                                                 bool betaFixed,
                                                                 bool spatialRandomEffectsFixed,
                                                                 bool uRandomEffectsFixed,
                                                                 bool spatialTauFixed,
                                                                 bool spatialRhoFixed,
                                                                 bool sigmaSquaredUFixed,
                                                                 NumericVector trueBetaValues,
                                                                 NumericVector trueSpatialRandomEffectsValues,
                                                                 NumericVector trueURandomEffectsValues,
                                                                 double trueSpatialTauValues,
                                                                 double trueSpatialRhoValues,
                                                                 double trueSigmaSquaredUValues,
                                                                 bool centerSpatialRandomEffects,
                                                                 bool centerURandomEffects);
  
NumericVector univariateGaussianNetworkLerouxBetaUpdate(NumericMatrix standardizedX,
                                                        NumericVector y,
                                                        const int numberOfRowsInX,
                                                        const int numberOfColumnsInX,
                                                        NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                        NumericMatrix WInTripletForm,
                                                        const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                                        const int numberOfRowsInWTripletForm,
                                                        NumericVector beta,
                                                        NumericVector spatialRandomEffects,
                                                        NumericVector uRandomEffects,
                                                        double sigmaSquaredE,
                                                        double covarianceBetaPrior);

List univariateGaussianNetworkLerouxSpatialRandomEffectsMHUpdate(NumericMatrix standardizedX,
                                                                 NumericMatrix spatialAssignment,
                                                                 NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                 NumericVector y,
                                                                 const int numberOfRowsInX,
                                                                 const int numberOfColumnsInX,
                                                                 NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                 NumericMatrix WInTripletForm,
                                                                 const int numberOfRowsInWTripletForm,
                                                                 NumericVector beta,
                                                                 NumericVector spatialRandomEffects,
                                                                 NumericVector uRandomEffects,
                                                                 double spatialTauSquared,
                                                                 double spatialRho,
                                                                 double sigmaSquaredE,
                                                                 NumericVector spatialRandomEffectsTuningParameters,
                                                                 NumericVector spatialRandomEffectsAcceptanceRate,
                                                                 NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                 NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                 int currentNumberOfIterations,
                                                                 bool centerSpatialRandomEffects);

NumericVector univariateGaussianNetworkLerouxURandomEffectsUpdate(NumericMatrix standardizedX,
                                                                  NumericMatrix W,
                                                                  NumericVector y,
                                                                  const int numberOfRowsInX,
                                                                  NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                  NumericMatrix WInTripletForm,
                                                                  const int numberOfRowsInSpatialAssignmentMatrixInTripletForm,
                                                                  const int numberOfRowsInWTripletForm,
                                                                  NumericVector beta,
                                                                  NumericVector spatialRandomEffects,
                                                                  NumericVector uRandomEffects,
                                                                  double sigmaSquaredU,
                                                                  double sigmaSquaredE, 
                                                                  bool centerURandomEffects);

double univariateGaussianNetworkLerouxSigmaSquaredUUpdate(NumericVector randomEffects,
                                                          double a2,
                                                          double b2);

List univariateGaussianNetworkLerouxRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                              NumericVector spatialRandomEffects,
                                              double spatialTauSquared,
                                              double spatialRho,
                                              double spatialRhoTuningParameters,
                                              double spatialRhoAcceptanceRate,
                                              double numberOfAcceptedSpatialRhoDraws,
                                              double numberOfAllAcceptedSpatialRhoDraws,
                                              NumericMatrix QSpatialMatrixComponent1,
                                              NumericVector QSpatialMatrixComponent1EigenValues,
                                              int currentNumberOfIterations);

double univariateGaussianNetworkLerouxTauSquaredUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                       NumericVector spatialRandomEffects,
                                                       double spatialTauSquared,
                                                       double spatialRho,
                                                       double a1,
                                                       double b1,
                                                       NumericMatrix QSpatialMatrixComponent1);

List univariateGaussianNetworkLerouxTauMHHalfNormalPriorUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                               NumericVector spatialRandomEffects,
                                                               double spatialTau,
                                                               double spatialTauTuningParameters,
                                                               double spatialTauAcceptanceRate,
                                                               double numberOfAcceptedSpatialTauDraws,
                                                               double numberOfAllAcceptedSpatialTauDraws,
                                                               double spatialRho,
                                                               double sigmaSquaredSpatialTau,
                                                               NumericMatrix QSpatialMatrixComponent1,
                                                               int currentNumberOfIterations);

double univariateGaussianNetworkLerouxSigmaSquaredEUpdate(NumericMatrix standardizedX,
                                                          NumericVector y,
                                                          NumericMatrix spatialAssignment,
                                                          NumericMatrix W,
                                                          NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                          NumericMatrix WInTripletForm,
                                                          const int numberOfRowsInX,
                                                          const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                                          const int numberOfRowsInWTripletForm,
                                                          NumericVector beta,
                                                          NumericVector spatialRandomEffects,
                                                          NumericVector uRandomEffects,
                                                          double a3,
                                                          double b3);

List getUnivariateGaussianNetworkLerouxFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                                     NumericVector y,
                                                                                     NumericMatrix spatialAssignment,
                                                                                     NumericMatrix W,
                                                                                     NumericVector beta,
                                                                                     NumericVector spatialRandomEffects,
                                                                                     NumericVector uRandomEffects,
                                                                                     double sigmaSquaredE);

List univariateGaussianNetworkLerouxSingleMHUpdate(NumericMatrix standardizedX,
                                                   NumericVector y,
                                                   NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                   NumericMatrix spatialAssignment,
                                                   NumericMatrix W,
                                                   NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                   NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                   NumericMatrix WInTripletForm,
                                                   NumericVector beta,
                                                   NumericVector spatialRandomEffects,
                                                   NumericVector uRandomEffects,
                                                   double spatialTauSquared,
                                                   double spatialRho,
                                                   double sigmaSquaredU,
                                                   double sigmaSquaredE,
                                                   double covarianceBetaPrior,
                                                   NumericVector spatialRandomEffectsTuningParameters,
                                                   NumericVector spatialRandomEffectsAcceptanceRate,
                                                   NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                   NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                   double spatialRhoTuningParameters,
                                                   double spatialRhoAcceptanceRate,
                                                   int numberOfAcceptedSpatialRhoDraws,
                                                   int numberOfAllAcceptedSpatialRhoDraws,
                                                   NumericMatrix QSpatialMatrixComponent1,
                                                   NumericVector QSpatialMatrixComponent1EigenValues,
                                                   double a1,
                                                   double b1,
                                                   double a2,
                                                   double b2,
                                                   double a3,
                                                   double b3,
                                                   int currentNumberOfIterations,
                                                   bool betaFixed,
                                                   bool spatialRandomEffectsFixed,
                                                   bool uRandomEffectsFixed,
                                                   bool spatialTauSquaredFixed,
                                                   bool spatialRhoFixed,
                                                   bool sigmaSquaredUFixed,
                                                   bool sigmaSquaredEFixed,
                                                   NumericVector trueBetaValues,
                                                   NumericVector trueSpatialRandomEffectsValues,
                                                   NumericVector trueURandomEffectsValues,
                                                   double trueSpatialTauSquaredValues,
                                                   double trueSpatialRhoValues,
                                                   double trueSigmaSquaredUValues,
                                                   double trueSigmaSquaredEValues,
                                                   bool centerSpatialRandomEffects,
                                                   bool centerURandomEffects);

List getUnivariateGaussianNetworkLerouxDIC(NumericMatrix standardizedX,
                                           NumericVector y,
                                           NumericMatrix spatialAssignment,
                                           NumericMatrix W,
                                           NumericMatrix betaSamples,
                                           NumericMatrix spatialRandomEffectsSamples,
                                           NumericMatrix uRandomEffectsSamples,
                                           NumericVector sigmaSquaredESamples,
                                           NumericMatrix logLikelihoodSamples);

List univariateGaussianNetworkLerouxAllMHUpdate(NumericMatrix standardizedX,
                                                NumericVector y,
                                                NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                NumericMatrix spatialAssignment,
                                                NumericMatrix W,
                                                NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                NumericMatrix WInTripletForm,
                                                NumericVector beta,
                                                NumericVector spatialRandomEffects,
                                                NumericVector uRandomEffects,
                                                double spatialTauSquared,
                                                double spatialRho,
                                                double sigmaSquaredU,
                                                double sigmaSquaredE,
                                                double covarianceBetaPrior,
                                                NumericVector spatialRandomEffectsTuningParameters,
                                                NumericVector spatialRandomEffectsAcceptanceRate,
                                                NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                double spatialRhoTuningParameters,
                                                double spatialRhoAcceptanceRate,
                                                int numberOfAcceptedSpatialRhoDraws,
                                                int numberOfAllAcceptedSpatialRhoDraws,
                                                double a1,
                                                double b1,
                                                double a2,
                                                double b2,
                                                double a3,
                                                double b3,
                                                int currentNumberOfIterations,
                                                const int numberOfSamples,
                                                const int burnin,
                                                const int thin,
                                                bool betaFixed,
                                                bool spatialRandomEffectsFixed,
                                                bool uRandomEffectsFixed,
                                                bool spatialTauSquaredFixed,
                                                bool spatialRhoFixed,
                                                bool sigmaSquaredUFixed,
                                                bool sigmaSquaredEFixed,
                                                NumericVector trueBetaValues,
                                                NumericVector trueSpatialRandomEffectsValues,
                                                NumericVector trueURandomEffectsValues,
                                                double trueSpatialTauSquaredValues,
                                                double trueSpatialRhoValues,
                                                double trueSigmaSquaredUValues,
                                                double trueSigmaSquaredEValues,
                                                bool centerSpatialRandomEffects,
                                                bool centerURandomEffects);

List univariateGaussianNetworkLerouxTauMHHalfNormalPriorSingleUpdate(NumericMatrix standardizedX,
                                                                     NumericVector y,
                                                                     NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                     NumericMatrix spatialAssignment,
                                                                     NumericMatrix W,
                                                                     NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                     NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                     NumericMatrix WInTripletForm,
                                                                     NumericVector beta,
                                                                     NumericVector spatialRandomEffects,
                                                                     NumericVector uRandomEffects,
                                                                     double spatialTau,
                                                                     double spatialRho,
                                                                     double sigmaSquaredU,
                                                                     double sigmaSquaredE,
                                                                     double covarianceBetaPrior,
                                                                     double spatialTauTuningParameters,
                                                                     double spatialTauAcceptanceRate,
                                                                     int numberOfAcceptedSpatialTauDraws,
                                                                     int numberOfAllAcceptedSpatialTauDraws,
                                                                     double spatialRhoTuningParameters,
                                                                     double spatialRhoAcceptanceRate,
                                                                     int numberOfAcceptedSpatialRhoDraws,
                                                                     int numberOfAllAcceptedSpatialRhoDraws,
                                                                     NumericMatrix QSpatialMatrixComponent1,
                                                                     NumericVector QSpatialMatrixComponent1EigenValues,
                                                                     double sigmaSquaredSpatialTau,
                                                                     double a2,
                                                                     double b2,
                                                                     double a3,
                                                                     double b3,
                                                                     int currentNumberOfIterations,
                                                                     bool betaFixed,
                                                                     bool spatialRandomEffectsFixed,
                                                                     bool uRandomEffectsFixed,
                                                                     bool spatialTauFixed,
                                                                     bool spatialRhoFixed,
                                                                     bool sigmaSquaredUFixed,
                                                                     bool sigmaSquaredEFixed,
                                                                     NumericVector trueBetaValues,
                                                                     NumericVector trueSpatialRandomEffectsValues,
                                                                     NumericVector trueURandomEffectsValues,
                                                                     double trueSpatialTauValues,
                                                                     double trueSpatialRhoValues,
                                                                     double trueSigmaSquaredUValues,
                                                                     double trueSigmaSquaredEValues,
                                                                     bool centerSpatialRandomEffects,
                                                                     bool centerURandomEffects);

List univariateGaussianNetworkLerouxTauMHHalfNormalPriorAllUpdate(NumericMatrix standardizedX,
                                                                  NumericVector y,
                                                                  NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                  NumericMatrix spatialAssignment,
                                                                  NumericMatrix W,
                                                                  NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                  NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                  NumericMatrix WInTripletForm,
                                                                  NumericVector beta,
                                                                  NumericVector spatialRandomEffects,
                                                                  NumericVector uRandomEffects,
                                                                  double spatialTau,
                                                                  double spatialRho,
                                                                  double sigmaSquaredU,
                                                                  double sigmaSquaredE,
                                                                  double covarianceBetaPrior,
                                                                  double spatialTauTuningParameters,
                                                                  double spatialTauAcceptanceRate,
                                                                  int numberOfAcceptedSpatialTauDraws,
                                                                  int numberOfAllAcceptedSpatialTauDraws,
                                                                  double spatialRhoTuningParameters,
                                                                  double spatialRhoAcceptanceRate,
                                                                  int numberOfAcceptedSpatialRhoDraws,
                                                                  int numberOfAllAcceptedSpatialRhoDraws,
                                                                  double sigmaSquaredSpatialTau,
                                                                  double a2,
                                                                  double b2,
                                                                  double a3,
                                                                  double b3,
                                                                  int currentNumberOfIterations,
                                                                  const int numberOfSamples,
                                                                  const int burnin,
                                                                  const int thin,
                                                                  bool betaFixed,
                                                                  bool spatialRandomEffectsFixed,
                                                                  bool uRandomEffectsFixed,
                                                                  bool spatialTauFixed,
                                                                  bool spatialRhoFixed,
                                                                  bool sigmaSquaredUFixed,
                                                                  bool sigmaSquaredEFixed,
                                                                  NumericVector trueBetaValues,
                                                                  NumericVector trueSpatialRandomEffectsValues,
                                                                  NumericVector trueURandomEffectsValues,
                                                                  double trueSpatialTauValues,
                                                                  double trueSpatialRhoValues,
                                                                  double trueSigmaSquaredUValues,
                                                                  double trueSigmaSquaredEValues,
                                                                  bool centerSpatialRandomEffects,
                                                                  bool centerURandomEffects);

List multivariateBinomialNetworkLerouxBetaUpdate(NumericMatrix standardizedX,
                                                 NumericVector trials,
                                                 NumericVector y,
                                                 const int numberOfResponses,
                                                 NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                 NumericMatrix WInTripletForm,
                                                 const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                                 const int numberOfRowsInWTripletForm,
                                                 NumericVector beta,
                                                 NumericVector spatialRandomEffects,
                                                 NumericVector uRandomEffects,
                                                 double covarianceBetaPrior,
                                                 const int numberOfBetaBlocks,
                                                 const int maxBetaBlockSize,
                                                 NumericVector betaTuningParameter,
                                                 NumericVector betaAcceptanceRate,
                                                 NumericVector numberOfAcceptedBetaDraws,
                                                 NumericVector numberOfAllAcceptedBetaDraws,
                                                 int currentNumberOfIterations);

List multivariateBinomialNetworkLerouxSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                                 const int numberOfResponses,
                                                                 NumericMatrix spatialAssignment,
                                                                 NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                 NumericVector trials,
                                                                 NumericVector y,
                                                                 const int numberOfSpatialAreas,
                                                                 NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                 NumericMatrix WInTripletForm,
                                                                 const int numberOfRowsInSquareSpatialNeighbourhoodMatrix,
                                                                 const int numberOfRowsInWTripletForm,
                                                                 NumericVector beta,
                                                                 NumericVector spatialRandomEffects,
                                                                 NumericVector uRandomEffects,
                                                                 NumericVector spatialTauSquared,
                                                                 NumericVector spatialRho,
                                                                 NumericVector spatialRandomEffectsTuningParameters,
                                                                 NumericVector spatialRandomEffectsAcceptanceRate,
                                                                 NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                 NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                 int currentNumberOfIterations,
                                                                 bool centerSpatialRandomEffects);

List multivariateBinomialNetworkLerouxURandomEffectsUpdate(NumericMatrix standardizedX,
                                                           NumericVector trials,
                                                           NumericVector y,
                                                           NumericMatrix W,
                                                           const int numberOfResponses,
                                                           NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                           NumericMatrix WInTripletForm,
                                                           const int numberOfRowsInSpatialAssignmentMatrixInTripletForm,
                                                           const int numberOfRowsInWTripletForm,
                                                           NumericVector beta,
                                                           NumericVector spatialRandomEffects,
                                                           NumericVector uRandomEffects,
                                                           NumericMatrix varianceCovarianceU,
                                                           NumericVector uRandomEffectsTuningParameters,
                                                           NumericVector uRandomEffectsAcceptanceRate,
                                                           NumericVector numberOfAcceptedUREDraws,
                                                           NumericVector numberOfAllAcceptedUREDraws,
                                                           int currentNumberOfIterations,
                                                           bool centerURandomEffects);

NumericVector multivariateBinomialNetworkLerouxTauSquaredUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                 NumericVector spatialRandomEffects,
                                                                 const int numberOfResponses,
                                                                 NumericVector spatialTauSquared,
                                                                 NumericVector spatialRho,
                                                                 double a1,
                                                                 double b1,
                                                                 NumericMatrix QSpatialMatrixComponent1);

List multivariateBernoulliNetworkLerouxTauMHHalfNormalPriorUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                           NumericVector spatialRandomEffects,
                                                                           const int numberOfResponses,
                                                                           NumericVector spatialTau,
                                                                           NumericVector spatialTauTuningParameters,
                                                                           NumericVector spatialTauAcceptanceRate,
                                                                           NumericVector numberOfAcceptedSpatialTauDraws,
                                                                           NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                           NumericVector spatialRho,
                                                                           double sigmaSquaredSpatialTau,
                                                                           NumericMatrix QSpatialMatrixComponent1,
                                                                           int currentNumberOfIterations);

List multivariateBinomialNetworkLerouxRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                 NumericVector spatialRandomEffects,
                                                 const int numberOfResponses,
                                                 NumericVector spatialTauSquared,
                                                 NumericVector spatialRho,
                                                 NumericVector spatialRhoTuningParameters,
                                                 NumericVector spatialRhoAcceptanceRate,
                                                 NumericVector numberOfAcceptedSpatialRhoDraws,
                                                 NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                 NumericMatrix QSpatialMatrixComponent1,
                                                 NumericVector QSpatialMatrixComponent1EigenValues,
                                                 int currentNumberOfIterations);

NumericMatrix multivariateBinomialNetworkLerouxVarianceCovarianceUUpdate(NumericVector randomEffects,
                                                                          const int numberOfResponses,
                                                                          double xi,
                                                                          NumericMatrix omega);

List getMultivariateBernoulliNetworkLerouxFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                         NumericVector y,
                                                                         NumericMatrix spatialAssignment,
                                                                         NumericMatrix W,
                                                                         NumericVector beta,
                                                                         NumericVector spatialRandomEffects,
                                                                         NumericVector uRandomEffects,
                                                                         int numberOfResponses);

List multivariateBinomialNetworkLerouxSingleUpdate(NumericMatrix standardizedX,
                                                   NumericVector trials,
                                                   NumericVector y,
                                                   const int numberOfResponses,
                                                   NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                   NumericMatrix spatialAssignment,
                                                   NumericMatrix W,
                                                   const int numberOfSpatialAreas,
                                                   NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                   NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                   NumericMatrix WInTripletForm,
                                                   NumericVector beta,
                                                   NumericVector spatialRandomEffects,
                                                   NumericVector uRandomEffects,
                                                   NumericVector spatialTauSquared,
                                                   NumericVector spatialRho,
                                                   NumericMatrix varianceCovarianceU,
                                                   double covarianceBetaPrior,
                                                   const int numberOfBetaBlocks,
                                                   const int maxBetaBlockSize,
                                                   NumericVector betaTuningParameter,
                                                   NumericVector betaAcceptanceRate,
                                                   NumericVector numberOfAcceptedBetaDraws,
                                                   NumericVector numberOfAllAcceptedBetaDraws,
                                                   NumericVector spatialRandomEffectsTuningParameters,
                                                   NumericVector spatialRandomEffectsAcceptanceRate,
                                                   NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                   NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                   NumericVector uRandomEffectsTuningParameters,
                                                   NumericVector uRandomEffectsAcceptanceRate,
                                                   NumericVector numberOfAcceptedUREDraws,
                                                   NumericVector numberOfAllAcceptedUREDraws,
                                                   NumericVector spatialRhoTuningParameters,
                                                   NumericVector spatialRhoAcceptanceRate,
                                                   NumericVector numberOfAcceptedSpatialRhoDraws,
                                                   NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                   NumericMatrix QSpatialMatrixComponent1,
                                                   NumericVector QSpatialMatrixComponent1EigenValues,
                                                   double a1,
                                                   double b1,
                                                   double xi,
                                                   NumericMatrix omega,
                                                   int currentNumberOfIterations,
                                                   bool betaFixed,
                                                   bool spatialRandomEffectsFixed,
                                                   bool uRandomEffectsFixed,
                                                   bool spatialTauSquaredFixed,
                                                   bool spatialRhoFixed,
                                                   bool varianceCovarianceUFixed,
                                                   NumericVector trueBetaValues,
                                                   NumericVector trueSpatialRandomEffectsValues,
                                                   NumericVector trueURandomEffectsValues,
                                                   NumericVector trueSpatialTauSquaredValues,
                                                   NumericVector trueSpatialRhoValues,
                                                   NumericMatrix trueVarianceCovarianceUValues,
                                                   bool centerSpatialRandomEffects,
                                                   bool centerURandomEffects);

List getMultivariateBinomialNetworkLerouxDIC(NumericMatrix standardizedX,
                                             NumericVector trials,
                                             NumericVector y,
                                             NumericMatrix spatialAssignment,
                                             NumericMatrix W,
                                             NumericMatrix betaSamples,
                                             NumericMatrix spatialRandomEffectsSamples,
                                             NumericMatrix uRandomEffectsSamples,
                                             NumericMatrix logLikelihoodSamples,
                                             int numberOfResponses);

List multivariateBinomialNetworkLerouxAllUpdate(NumericMatrix standardizedX,
                                                NumericVector trials,
                                                NumericVector y,
                                                const int numberOfResponses,
                                                NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                NumericMatrix spatialAssignment,
                                                NumericMatrix W,
                                                const int numberOfSpatialAreas,
                                                NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                NumericMatrix WInTripletForm,
                                                NumericVector beta,
                                                NumericVector spatialRandomEffects,
                                                NumericVector uRandomEffects,
                                                NumericVector spatialTauSquared,
                                                NumericVector spatialRho,
                                                NumericMatrix varianceCovarianceU,
                                                double covarianceBetaPrior,
                                                const int numberOfBetaBlocks,
                                                const int maxBetaBlockSize,
                                                NumericVector betaTuningParameter,
                                                NumericVector betaAcceptanceRate,
                                                NumericVector numberOfAcceptedBetaDraws,
                                                NumericVector numberOfAllAcceptedBetaDraws,
                                                NumericVector spatialRandomEffectsTuningParameters,
                                                NumericVector spatialRandomEffectsAcceptanceRate,
                                                NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                NumericVector uRandomEffectsTuningParameters,
                                                NumericVector uRandomEffectsAcceptanceRate,
                                                NumericVector numberOfAcceptedUREDraws,
                                                NumericVector numberOfAllAcceptedUREDraws,
                                                NumericVector spatialRhoTuningParameters,
                                                NumericVector spatialRhoAcceptanceRate,
                                                NumericVector numberOfAcceptedSpatialRhoDraws,
                                                NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                double a1,
                                                double b1,
                                                double xi,
                                                NumericMatrix omega,
                                                int currentNumberOfIterations,
                                                const int numberOfSamples,
                                                const int burnin,
                                                const int thin,
                                                bool betaFixed,
                                                bool spatialRandomEffectsFixed,
                                                bool uRandomEffectsFixed,
                                                bool spatialTauSquaredFixed,
                                                bool spatialRhoFixed,
                                                bool varianceCovarianceUFixed,
                                                NumericVector trueBetaValues,
                                                NumericVector trueSpatialRandomEffectsValues,
                                                NumericVector trueURandomEffectsValues,
                                                NumericVector trueSpatialTauSquaredValues,
                                                NumericVector trueSpatialRhoValues,
                                                NumericMatrix trueVarianceCovarianceUValues,
                                                bool centerSpatialRandomEffects,
                                                bool centerURandomEffects);

List multivariateBernoulliNetworkLerouxTauMHHalfNormalPriorSingleUpdate(NumericMatrix standardizedX,
                                                                        NumericVector y,
                                                                        const int numberOfResponses,
                                                                        NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                        NumericMatrix spatialAssignment,
                                                                        NumericMatrix W,
                                                                        const int numberOfSpatialAreas,
                                                                        NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                        NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                        NumericMatrix WInTripletForm,
                                                                        NumericVector beta,
                                                                        NumericVector spatialRandomEffects,
                                                                        NumericVector uRandomEffects,
                                                                        NumericVector spatialTau,
                                                                        NumericVector spatialRho,
                                                                        NumericMatrix varianceCovarianceU,
                                                                        double covarianceBetaPrior,
                                                                        const int numberOfBetaBlocks,
                                                                        const int maxBetaBlockSize,
                                                                        NumericVector betaTuningParameter,
                                                                        NumericVector betaAcceptanceRate,
                                                                        NumericVector numberOfAcceptedBetaDraws,
                                                                        NumericVector numberOfAllAcceptedBetaDraws,
                                                                        NumericVector spatialRandomEffectsTuningParameters,
                                                                        NumericVector spatialRandomEffectsAcceptanceRate,
                                                                        NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                        NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                        NumericVector uRandomEffectsTuningParameters,
                                                                        NumericVector uRandomEffectsAcceptanceRate,
                                                                        NumericVector numberOfAcceptedUREDraws,
                                                                        NumericVector numberOfAllAcceptedUREDraws,
                                                                        NumericVector spatialTauTuningParameters,
                                                                        NumericVector spatialTauAcceptanceRate,
                                                                        NumericVector numberOfAcceptedSpatialTauDraws,
                                                                        NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                        NumericVector spatialRhoTuningParameters,
                                                                        NumericVector spatialRhoAcceptanceRate,
                                                                        NumericVector numberOfAcceptedSpatialRhoDraws,
                                                                        NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                                        NumericMatrix QSpatialMatrixComponent1,
                                                                        NumericVector QSpatialMatrixComponent1EigenValues,
                                                                        double sigmaSquaredSpatialTau,
                                                                        double xi,
                                                                        NumericMatrix omega,
                                                                        int currentNumberOfIterations,
                                                                        bool betaFixed,
                                                                        bool spatialRandomEffectsFixed,
                                                                        bool uRandomEffectsFixed,
                                                                        bool spatialTauFixed,
                                                                        bool spatialRhoFixed,
                                                                        bool varianceCovarianceUFixed,
                                                                        NumericVector trueBetaValues,
                                                                        NumericVector trueSpatialRandomEffectsValues,
                                                                        NumericVector trueURandomEffectsValues,
                                                                        NumericVector trueSpatialTauValues,
                                                                        NumericVector trueSpatialRhoValues,
                                                                        NumericMatrix trueVarianceCovarianceUValues,
                                                                        bool centerSpatialRandomEffects,
                                                                        bool centerURandomEffects);

List multivariateBernoulliNetworkLerouxTauMHHalfNormalPriorAllUpdate(NumericMatrix standardizedX,
                                                                     NumericVector y,
                                                                     const int numberOfResponses,
                                                                     NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                     NumericMatrix spatialAssignment,
                                                                     NumericMatrix W,
                                                                     const int numberOfSpatialAreas,
                                                                     NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                     NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                     NumericMatrix WInTripletForm,
                                                                     NumericVector beta,
                                                                     NumericVector spatialRandomEffects,
                                                                     NumericVector uRandomEffects,
                                                                     NumericVector spatialTau,
                                                                     NumericVector spatialRho,
                                                                     NumericMatrix varianceCovarianceU,
                                                                     double covarianceBetaPrior,
                                                                     const int numberOfBetaBlocks,
                                                                     const int maxBetaBlockSize,
                                                                     NumericVector betaTuningParameter,
                                                                     NumericVector betaAcceptanceRate,
                                                                     NumericVector numberOfAcceptedBetaDraws,
                                                                     NumericVector numberOfAllAcceptedBetaDraws,
                                                                     NumericVector spatialRandomEffectsTuningParameters,
                                                                     NumericVector spatialRandomEffectsAcceptanceRate,
                                                                     NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                     NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                     NumericVector uRandomEffectsTuningParameters,
                                                                     NumericVector uRandomEffectsAcceptanceRate,
                                                                     NumericVector numberOfAcceptedUREDraws,
                                                                     NumericVector numberOfAllAcceptedUREDraws,
                                                                     NumericVector spatialTauTuningParameters,
                                                                     NumericVector spatialTauAcceptanceRate,
                                                                     NumericVector numberOfAcceptedSpatialTauDraws,
                                                                     NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                     NumericVector spatialRhoTuningParameters,
                                                                     NumericVector spatialRhoAcceptanceRate,
                                                                     NumericVector numberOfAcceptedSpatialRhoDraws,
                                                                     NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                                     double sigmaSquaredSpatialTau,
                                                                     double xi,
                                                                     NumericMatrix omega,
                                                                     int currentNumberOfIterations,
                                                                     const int numberOfSamples,
                                                                     const int burnin,
                                                                     const int thin,
                                                                     bool betaFixed,
                                                                     bool spatialRandomEffectsFixed,
                                                                     bool uRandomEffectsFixed,
                                                                     bool spatialTauFixed,
                                                                     bool spatialRhoFixed,
                                                                     bool varianceCovarianceUFixed,
                                                                     NumericVector trueBetaValues,
                                                                     NumericVector trueSpatialRandomEffectsValues,
                                                                     NumericVector trueURandomEffectsValues,
                                                                     NumericVector trueSpatialTauValues,
                                                                     NumericVector trueSpatialRhoValues,
                                                                     NumericMatrix trueVarianceCovarianceUValues,
                                                                     bool centerSpatialRandomEffects,
                                                                     bool centerURandomEffects);


List multivariatePoissonNetworkLerouxBetaUpdate(NumericMatrix standardizedX,
                                                NumericVector y,
                                                const int numberOfResponses,
                                                NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                NumericMatrix WInTripletForm,
                                                const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                                const int numberOfRowsInWTripletForm,
                                                NumericVector beta,
                                                NumericVector spatialRandomEffects,
                                                NumericVector uRandomEffects,
                                                double covarianceBetaPrior,
                                                const int numberOfBetaBlocks,
                                                const int maxBetaBlockSize,
                                                NumericVector betaTuningParameter,
                                                NumericVector betaAcceptanceRate,
                                                NumericVector numberOfAcceptedBetaDraws,
                                                NumericVector numberOfAllAcceptedBetaDraws,
                                                int currentNumberOfIterations);

List multivariatePoissonNetworkLerouxSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                                const int numberOfResponses,
                                                                NumericMatrix spatialAssignment,
                                                                NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                NumericVector y,
                                                                const int numberOfSpatialAreas,
                                                                NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                NumericMatrix WInTripletForm,
                                                                const int numberOfRowsInSquareSpatialNeighbourhoodMatrix,
                                                                const int numberOfRowsInWTripletForm,
                                                                NumericVector beta,
                                                                NumericVector spatialRandomEffects,
                                                                NumericVector uRandomEffects,
                                                                NumericVector spatialTauSquared,
                                                                NumericVector spatialRho,
                                                                NumericVector spatialRandomEffectsTuningParameters,
                                                                NumericVector spatialRandomEffectsAcceptanceRate,
                                                                NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                int currentNumberOfIterations,
                                                                bool centerSpatialRandomEffects);

List multivariatePoissonNetworkLerouxURandomEffectsUpdate(NumericMatrix standardizedX,
                                                          NumericVector y,
                                                          NumericMatrix W,
                                                          const int numberOfResponses,
                                                          NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                          NumericMatrix WInTripletForm,
                                                          const int numberOfRowsInSpatialAssignmentMatrixInTripletForm,
                                                          const int numberOfRowsInWTripletForm,
                                                          NumericVector beta,
                                                          NumericVector spatialRandomEffects,
                                                          NumericVector uRandomEffects,
                                                          NumericMatrix varianceCovarianceU,
                                                          NumericVector uRandomEffectsTuningParameters,
                                                          NumericVector uRandomEffectsAcceptanceRate,
                                                          NumericVector numberOfAcceptedUREDraws,
                                                          NumericVector numberOfAllAcceptedUREDraws,
                                                          int currentNumberOfIterations,
                                                          bool centerURandomEffects);

NumericVector multivariatePoissonNetworkLerouxTauSquaredUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                               NumericVector spatialRandomEffects,
                                                               const int numberOfResponses,
                                                               NumericVector spatialTauSquared,
                                                               NumericVector spatialRho,
                                                               double a1,
                                                               double b1,
                                                               NumericMatrix QSpatialMatrixComponent1);

List multivariatePoissonNetworkLerouxTauMHHalfNormalPriorUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                         NumericVector spatialRandomEffects,
                                                                         const int numberOfResponses,
                                                                         NumericVector spatialTau,
                                                                         NumericVector spatialTauTuningParameters,
                                                                         NumericVector spatialTauAcceptanceRate,
                                                                         NumericVector numberOfAcceptedSpatialTauDraws,
                                                                         NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                         NumericVector spatialRho,
                                                                         double sigmaSquaredSpatialTau,
                                                                         NumericMatrix QSpatialMatrixComponent1,
                                                                         int currentNumberOfIterations);

List multivariatePoissonNetworkLerouxRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                               NumericVector spatialRandomEffects,
                                               const int numberOfResponses,
                                               NumericVector spatialTauSquared,
                                               NumericVector spatialRho,
                                               NumericVector spatialRhoTuningParameters,
                                               NumericVector spatialRhoAcceptanceRate,
                                               NumericVector numberOfAcceptedSpatialRhoDraws,
                                               NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                               NumericMatrix QSpatialMatrixComponent1,
                                               NumericVector QSpatialMatrixComponent1EigenValues,
                                               int currentNumberOfIterations);

NumericMatrix multivariatePoissonNetworkLerouxVarianceCovarianceUUpdate(NumericVector randomEffects,
                                                                        const int numberOfResponses,
                                                                        double xi,
                                                                        NumericMatrix omega);

List getMultivariatePoissonNetworkLerouxFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                                      NumericVector y,
                                                                                      NumericMatrix spatialAssignment,
                                                                                      NumericMatrix W,
                                                                                      NumericVector beta,
                                                                                      NumericVector spatialRandomEffects,
                                                                                      NumericVector uRandomEffects,
                                                                                      int numberOfResponses);

List multivariatePoissonNetworkLerouxSingleUpdate(NumericMatrix standardizedX,
                                                  NumericVector y,
                                                  const int numberOfResponses,
                                                  NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                  NumericMatrix spatialAssignment,
                                                  NumericMatrix W,
                                                  const int numberOfSpatialAreas,
                                                  NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                  NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                  NumericMatrix WInTripletForm,
                                                  NumericVector beta,
                                                  NumericVector spatialRandomEffects,
                                                  NumericVector uRandomEffects,
                                                  NumericVector spatialTauSquared,
                                                  NumericVector spatialRho,
                                                  NumericMatrix varianceCovarianceU,
                                                  double covarianceBetaPrior,
                                                  const int numberOfBetaBlocks,
                                                  const int maxBetaBlockSize,
                                                  NumericVector betaTuningParameter,
                                                  NumericVector betaAcceptanceRate,
                                                  NumericVector numberOfAcceptedBetaDraws,
                                                  NumericVector numberOfAllAcceptedBetaDraws,
                                                  NumericVector spatialRandomEffectsTuningParameters,
                                                  NumericVector spatialRandomEffectsAcceptanceRate,
                                                  NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                  NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                  NumericVector uRandomEffectsTuningParameters,
                                                  NumericVector uRandomEffectsAcceptanceRate,
                                                  NumericVector numberOfAcceptedUREDraws,
                                                  NumericVector numberOfAllAcceptedUREDraws,
                                                  NumericVector spatialRhoTuningParameters,
                                                  NumericVector spatialRhoAcceptanceRate,
                                                  NumericVector numberOfAcceptedSpatialRhoDraws,
                                                  NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                  NumericMatrix QSpatialMatrixComponent1,
                                                  NumericVector QSpatialMatrixComponent1EigenValues,
                                                  double a1,
                                                  double b1,
                                                  double xi,
                                                  NumericMatrix omega,
                                                  int currentNumberOfIterations,
                                                  bool betaFixed,
                                                  bool spatialRandomEffectsFixed,
                                                  bool uRandomEffectsFixed,
                                                  bool spatialTauSquaredFixed,
                                                  bool spatialRhoFixed,
                                                  bool varianceCovarianceUFixed,
                                                  NumericVector trueBetaValues,
                                                  NumericVector trueSpatialRandomEffectsValues,
                                                  NumericVector trueURandomEffectsValues,
                                                  NumericVector trueSpatialTauSquaredValues,
                                                  NumericVector trueSpatialRhoValues,
                                                  NumericMatrix trueVarianceCovarianceUValues,
                                                  bool centerSpatialRandomEffects,
                                                  bool centerURandomEffects);

List getMultivariatePoissonNetworkLerouxDIC(NumericMatrix standardizedX,
                                            NumericVector y,
                                            NumericMatrix spatialAssignment,
                                            NumericMatrix W,
                                            NumericMatrix betaSamples,
                                            NumericMatrix spatialRandomEffectsSamples,
                                            NumericMatrix uRandomEffectsSamples,
                                            NumericMatrix logLikelihoodSamples,
                                            int numberOfResponses);

List multivariatePoissonNetworkLerouxAllUpdate(NumericMatrix standardizedX,
                                               NumericVector y,
                                               const int numberOfResponses,
                                               NumericMatrix squareSpatialNeighbourhoodMatrix,
                                               NumericMatrix spatialAssignment,
                                               NumericMatrix W,
                                               const int numberOfSpatialAreas,
                                               NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                               NumericMatrix spatialAssignmentMatrixInTripletForm,
                                               NumericMatrix WInTripletForm,
                                               NumericVector beta,
                                               NumericVector spatialRandomEffects,
                                               NumericVector uRandomEffects,
                                               NumericVector spatialTauSquared,
                                               NumericVector spatialRho,
                                               NumericMatrix varianceCovarianceU,
                                               double covarianceBetaPrior,
                                               const int numberOfBetaBlocks,
                                               const int maxBetaBlockSize,
                                               NumericVector betaTuningParameter,
                                               NumericVector betaAcceptanceRate,
                                               NumericVector numberOfAcceptedBetaDraws,
                                               NumericVector numberOfAllAcceptedBetaDraws,
                                               NumericVector spatialRandomEffectsTuningParameters,
                                               NumericVector spatialRandomEffectsAcceptanceRate,
                                               NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                               NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                               NumericVector uRandomEffectsTuningParameters,
                                               NumericVector uRandomEffectsAcceptanceRate,
                                               NumericVector numberOfAcceptedUREDraws,
                                               NumericVector numberOfAllAcceptedUREDraws,
                                               NumericVector spatialRhoTuningParameters,
                                               NumericVector spatialRhoAcceptanceRate,
                                               NumericVector numberOfAcceptedSpatialRhoDraws,
                                               NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                               double a1,
                                               double b1,
                                               double xi,
                                               NumericMatrix omega,
                                               int currentNumberOfIterations,
                                               const int numberOfSamples,
                                               const int burnin,
                                               const int thin,
                                               bool betaFixed,
                                               bool spatialRandomEffectsFixed,
                                               bool uRandomEffectsFixed,
                                               bool spatialTauSquaredFixed,
                                               bool spatialRhoFixed,
                                               bool varianceCovarianceUFixed,
                                               NumericVector trueBetaValues,
                                               NumericVector trueSpatialRandomEffectsValues,
                                               NumericVector trueURandomEffectsValues,
                                               NumericVector trueSpatialTauSquaredValues,
                                               NumericVector trueSpatialRhoValues,
                                               NumericMatrix trueVarianceCovarianceUValues,
                                               bool centerSpatialRandomEffects,
                                               bool centerURandomEffects);

List multivariatePoissonNetworkLerouxTauMHHalfNormalPriorSingleUpdate(NumericMatrix standardizedX,
                                                                      NumericVector y,
                                                                      const int numberOfResponses,
                                                                      NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                      NumericMatrix spatialAssignment,
                                                                      NumericMatrix W,
                                                                      const int numberOfSpatialAreas,
                                                                      NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                      NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                      NumericMatrix WInTripletForm,
                                                                      NumericVector beta,
                                                                      NumericVector spatialRandomEffects,
                                                                      NumericVector uRandomEffects,
                                                                      NumericVector spatialTau,
                                                                      NumericVector spatialRho,
                                                                      NumericMatrix varianceCovarianceU,
                                                                      double covarianceBetaPrior,
                                                                      const int numberOfBetaBlocks,
                                                                      const int maxBetaBlockSize,
                                                                      NumericVector betaTuningParameter,
                                                                      NumericVector betaAcceptanceRate,
                                                                      NumericVector numberOfAcceptedBetaDraws,
                                                                      NumericVector numberOfAllAcceptedBetaDraws,
                                                                      NumericVector spatialRandomEffectsTuningParameters,
                                                                      NumericVector spatialRandomEffectsAcceptanceRate,
                                                                      NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                      NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                      NumericVector uRandomEffectsTuningParameters,
                                                                      NumericVector uRandomEffectsAcceptanceRate,
                                                                      NumericVector numberOfAcceptedUREDraws,
                                                                      NumericVector numberOfAllAcceptedUREDraws,
                                                                      NumericVector spatialTauTuningParameters,
                                                                      NumericVector spatialTauAcceptanceRate,
                                                                      NumericVector numberOfAcceptedSpatialTauDraws,
                                                                      NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                      NumericVector spatialRhoTuningParameters,
                                                                      NumericVector spatialRhoAcceptanceRate,
                                                                      NumericVector numberOfAcceptedSpatialRhoDraws,
                                                                      NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                                      NumericMatrix QSpatialMatrixComponent1,
                                                                      NumericVector QSpatialMatrixComponent1EigenValues,
                                                                      double sigmaSquaredSpatialTau,
                                                                      double xi,
                                                                      NumericMatrix omega,
                                                                      int currentNumberOfIterations,
                                                                      bool betaFixed,
                                                                      bool spatialRandomEffectsFixed,
                                                                      bool uRandomEffectsFixed,
                                                                      bool spatialTauFixed,
                                                                      bool spatialRhoFixed,
                                                                      bool varianceCovarianceUFixed,
                                                                      NumericVector trueBetaValues,
                                                                      NumericVector trueSpatialRandomEffectsValues,
                                                                      NumericVector trueURandomEffectsValues,
                                                                      NumericVector trueSpatialTauValues,
                                                                      NumericVector trueSpatialRhoValues,
                                                                      NumericMatrix trueVarianceCovarianceUValues,
                                                                      bool centerSpatialRandomEffects,
                                                                      bool centerURandomEffects);

List multivariatePoissonNetworkLerouxTauMHHalfNormalPriorAllUpdate(NumericMatrix standardizedX,
                                                                   NumericVector y,
                                                                   const int numberOfResponses,
                                                                   NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                   NumericMatrix spatialAssignment,
                                                                   NumericMatrix W,
                                                                   const int numberOfSpatialAreas,
                                                                   NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                   NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                   NumericMatrix WInTripletForm,
                                                                   NumericVector beta,
                                                                   NumericVector spatialRandomEffects,
                                                                   NumericVector uRandomEffects,
                                                                   NumericVector spatialTau,
                                                                   NumericVector spatialRho,
                                                                   NumericMatrix varianceCovarianceU,
                                                                   double covarianceBetaPrior,
                                                                   const int numberOfBetaBlocks,
                                                                   const int maxBetaBlockSize,
                                                                   NumericVector betaTuningParameter,
                                                                   NumericVector betaAcceptanceRate,
                                                                   NumericVector numberOfAcceptedBetaDraws,
                                                                   NumericVector numberOfAllAcceptedBetaDraws,
                                                                   NumericVector spatialRandomEffectsTuningParameters,
                                                                   NumericVector spatialRandomEffectsAcceptanceRate,
                                                                   NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                   NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                   NumericVector uRandomEffectsTuningParameters,
                                                                   NumericVector uRandomEffectsAcceptanceRate,
                                                                   NumericVector numberOfAcceptedUREDraws,
                                                                   NumericVector numberOfAllAcceptedUREDraws,
                                                                   NumericVector spatialTauTuningParameters,
                                                                   NumericVector spatialTauAcceptanceRate,
                                                                   NumericVector numberOfAcceptedSpatialTauDraws,
                                                                   NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                   NumericVector spatialRhoTuningParameters,
                                                                   NumericVector spatialRhoAcceptanceRate,
                                                                   NumericVector numberOfAcceptedSpatialRhoDraws,
                                                                   NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                                   double sigmaSquaredSpatialTau,
                                                                   double xi,
                                                                   NumericMatrix omega,
                                                                   int currentNumberOfIterations,
                                                                   const int numberOfSamples,
                                                                   const int burnin,
                                                                   const int thin,
                                                                   bool betaFixed,
                                                                   bool spatialRandomEffectsFixed,
                                                                   bool uRandomEffectsFixed,
                                                                   bool spatialTauFixed,
                                                                   bool spatialRhoFixed,
                                                                   bool varianceCovarianceUFixed,
                                                                   NumericVector trueBetaValues,
                                                                   NumericVector trueSpatialRandomEffectsValues,
                                                                   NumericVector trueURandomEffectsValues,
                                                                   NumericVector trueSpatialTauValues,
                                                                   NumericVector trueSpatialRhoValues,
                                                                   NumericMatrix trueVarianceCovarianceUValues,
                                                                   bool centerSpatialRandomEffects,
                                                                   bool centerURandomEffects);


NumericVector multivariateGaussianNetworkLerouxBetaUpdate(NumericMatrix standardizedX,
                                                           NumericVector y,
                                                           const int numberOfResponses,
                                                           NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                           NumericMatrix WInTripletForm,
                                                           const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                                           const int numberOfRowsInWTripletForm,
                                                           NumericVector beta,
                                                           NumericVector spatialRandomEffects,
                                                           NumericVector uRandomEffects,
                                                           NumericVector sigmaSquaredE,
                                                           double covarianceBetaPrior);

List multivariateGaussianNetworkLerouxSpatialRandomEffectsMHUpdate(NumericMatrix standardizedX,
                                                                   const int numberOfResponses,
                                                                   NumericMatrix spatialAssignment,
                                                                   NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                   NumericVector y,
                                                                   NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                   NumericMatrix WInTripletForm,
                                                                   const int numberOfRowsInWTripletForm,
                                                                   NumericVector beta,
                                                                   NumericVector spatialRandomEffects,
                                                                   NumericVector uRandomEffects,
                                                                   NumericVector spatialTauSquared,
                                                                   NumericVector spatialRho,
                                                                   NumericVector spatialRandomEffectsTuningParameters,
                                                                   NumericVector spatialRandomEffectsAcceptanceRate,
                                                                   NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                   NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                   NumericVector sigmaSquaredE,
                                                                   int currentNumberOfIterations,
                                                                   bool centerSpatialRandomEffects);

NumericVector multivariateGaussianNetworkLerouxURandomEffectsUpdate(NumericMatrix standardizedX,
                                                                    NumericVector y,
                                                                    NumericMatrix W,
                                                                    const int numberOfResponses,
                                                                    NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                    NumericMatrix WInTripletForm,
                                                                    const int numberOfRowsInSpatialAssignmentMatrixInTripletForm,
                                                                    const int numberOfRowsInWTripletForm,
                                                                    NumericVector beta,
                                                                    NumericVector spatialRandomEffects,
                                                                    NumericVector uRandomEffects,
                                                                    NumericMatrix varianceCovarianceU,
                                                                    NumericVector sigmaSquaredE,
                                                                    bool centerURandomEffects);

NumericVector multivariateGaussianNetworkLerouxTauSquaredUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                NumericVector spatialRandomEffects,
                                                                const int numberOfResponses,
                                                                NumericVector spatialTauSquared,
                                                                NumericVector spatialRho,
                                                                double a1,
                                                                double b1,
                                                                NumericMatrix QSpatialMatrixComponent1);

List multivariateGaussianNetworkLerouxTauMHHalfNormalPriorUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                          NumericVector spatialRandomEffects,
                                                                          const int numberOfResponses,
                                                                          NumericVector spatialTau,
                                                                          NumericVector spatialTauTuningParameters,
                                                                          NumericVector spatialTauAcceptanceRate,
                                                                          NumericVector numberOfAcceptedSpatialTauDraws,
                                                                          NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                          NumericVector spatialRho,
                                                                          double sigmaSquaredSpatialTau,
                                                                          NumericMatrix QSpatialMatrixComponent1,
                                                                          int currentNumberOfIterations);

List multivariateGaussianNetworkLerouxRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                NumericVector spatialRandomEffects,
                                                const int numberOfResponses,
                                                NumericVector spatialTauSquared,
                                                NumericVector spatialRho,
                                                NumericVector spatialRhoTuningParameters,
                                                NumericVector spatialRhoAcceptanceRate,
                                                NumericVector numberOfAcceptedSpatialRhoDraws,
                                                NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                NumericMatrix QSpatialMatrixComponent1,
                                                NumericVector QSpatialMatrixComponent1EigenValues,
                                                int currentNumberOfIterations);

NumericMatrix multivariateGaussianNetworkLerouxVarianceCovarianceUUpdate(NumericVector randomEffects,
                                                                         const int numberOfResponses,
                                                                         double xi,
                                                                         NumericMatrix omega);

NumericVector multivariateGaussianNetworkLerouxSigmaSquaredEUpdate(NumericMatrix standardizedX,
                                                                   const int numberOfResponses,
                                                                   NumericVector y,
                                                                   NumericMatrix spatialAssignment,
                                                                   NumericMatrix W,
                                                                   NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                   NumericMatrix WInTripletForm,
                                                                   const int numberOfRowsInSpatialAssignmentMatrixTripletForm,
                                                                   const int numberOfRowsInWTripletForm,
                                                                   NumericVector beta,
                                                                   NumericVector spatialRandomEffects,
                                                                   NumericVector uRandomEffects,
                                                                   double a3,
                                                                   double b3);

List getMultivariateGaussianNetworkLerouxFittedValuesAndLikelihoodForDICEveryIteration(NumericMatrix standardizedX,
                                                                                       NumericVector y,
                                                                                       NumericMatrix spatialAssignment,
                                                                                       NumericMatrix W,
                                                                                       NumericVector beta,
                                                                                       NumericVector spatialRandomEffects,
                                                                                       NumericVector uRandomEffects,
                                                                                       NumericVector sigmaSquaredE,
                                                                                       int numberOfResponses);

List multivariateGaussianNetworkLerouxSingleMHUpdate(NumericMatrix standardizedX,
                                                   NumericVector y,
                                                   const int numberOfResponses,
                                                   NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                   NumericMatrix spatialAssignment,
                                                   NumericMatrix W,
                                                   const int numberOfSpatialAreas,
                                                   NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                   NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                   NumericMatrix WInTripletForm,
                                                   NumericVector beta,
                                                   NumericVector spatialRandomEffects,
                                                   NumericVector uRandomEffects,
                                                   NumericVector spatialTauSquared,
                                                   NumericVector spatialRho,
                                                   NumericMatrix varianceCovarianceU,
                                                   NumericVector sigmaSquaredE,
                                                   double covarianceBetaPrior,
                                                   NumericVector spatialRandomEffectsTuningParameters,
                                                   NumericVector spatialRandomEffectsAcceptanceRate,
                                                   NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                   NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                   NumericVector spatialRhoTuningParameters,
                                                   NumericVector spatialRhoAcceptanceRate,
                                                   NumericVector numberOfAcceptedSpatialRhoDraws,
                                                   NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                   NumericMatrix QSpatialMatrixComponent1,
                                                   NumericVector QSpatialMatrixComponent1EigenValues,
                                                   double a1,
                                                   double b1,
                                                   double xi,
                                                   NumericMatrix omega,
                                                   double a3,
                                                   double b3,
                                                   int currentNumberOfIterations,
                                                   bool betaFixed,
                                                   bool spatialRandomEffectsFixed,
                                                   bool uRandomEffectsFixed,
                                                   bool spatialTauSquaredFixed,
                                                   bool spatialRhoFixed,
                                                   bool varianceCovarianceUFixed,
                                                   bool sigmaSquaredEFixed,
                                                   NumericVector trueBetaValues,
                                                   NumericVector trueSpatialRandomEffectsValues,
                                                   NumericVector trueURandomEffectsValues,
                                                   NumericVector trueSpatialTauSquaredValues,
                                                   NumericVector trueSpatialRhoValues,
                                                   NumericMatrix trueVarianceCovarianceUValues,
                                                   NumericVector trueSigmaSquaredEValues,
                                                   bool centerSpatialRandomEffects,
                                                   bool centerURandomEffects);

List getMultivariateGaussianNetworkLerouxDIC(NumericMatrix standardizedX,
                                             NumericVector y,
                                             NumericMatrix spatialAssignment,
                                             NumericMatrix W,
                                             NumericMatrix betaSamples,
                                             NumericMatrix spatialRandomEffectsSamples,
                                             NumericMatrix uRandomEffectsSamples,
                                             NumericMatrix sigmaSquaredESamples,
                                             NumericMatrix logLikelihoodSamples,
                                             int numberOfResponses);

List multivariateGaussianNetworkLerouxAllMHUpdate(NumericMatrix standardizedX,
                                                  NumericVector y,
                                                  const int numberOfResponses,
                                                  NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                  NumericMatrix spatialAssignment,
                                                  NumericMatrix W,
                                                  const int numberOfSpatialAreas,
                                                  NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                  NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                  NumericMatrix WInTripletForm,
                                                  NumericVector beta,
                                                  NumericVector spatialRandomEffects,
                                                  NumericVector uRandomEffects,
                                                  NumericVector spatialTauSquared,
                                                  NumericVector spatialRho,
                                                  NumericMatrix varianceCovarianceU,
                                                  NumericVector sigmaSquaredE,
                                                  double covarianceBetaPrior,
                                                  NumericVector spatialRandomEffectsTuningParameters,
                                                  NumericVector spatialRandomEffectsAcceptanceRate,
                                                  NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                  NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                  NumericVector spatialRhoTuningParameters,
                                                  NumericVector spatialRhoAcceptanceRate,
                                                  NumericVector numberOfAcceptedSpatialRhoDraws,
                                                  NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                  double a1,
                                                  double b1,
                                                  double xi,
                                                  NumericMatrix omega,
                                                  double a3,
                                                  double b3,
                                                  int currentNumberOfIterations,
                                                  const int numberOfSamples,
                                                  const int burnin,
                                                  const int thin,
                                                  bool betaFixed,
                                                  bool spatialRandomEffectsFixed,
                                                  bool uRandomEffectsFixed,
                                                  bool spatialTauSquaredFixed,
                                                  bool spatialRhoFixed,
                                                  bool varianceCovarianceUFixed,
                                                  bool sigmaSquaredEFixed,
                                                  NumericVector trueBetaValues,
                                                  NumericVector trueSpatialRandomEffectsValues,
                                                  NumericVector trueURandomEffectsValues,
                                                  NumericVector trueSpatialTauSquaredValues,
                                                  NumericVector trueSpatialRhoValues,
                                                  NumericMatrix trueVarianceCovarianceUValues,
                                                  NumericVector trueSigmaSquaredEValues,
                                                  bool centerSpatialRandomEffects,
                                                  bool centerURandomEffects);

List multivariateGaussianNetworkLerouxTauMHHalfNormalPriorSingleUpdate(NumericMatrix standardizedX,
                                                                       NumericVector y,
                                                                       const int numberOfResponses,
                                                                       NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                       NumericMatrix spatialAssignment,
                                                                       NumericMatrix W,
                                                                       const int numberOfSpatialAreas,
                                                                       NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                       NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                       NumericMatrix WInTripletForm,
                                                                       NumericVector beta,
                                                                       NumericVector spatialRandomEffects,
                                                                       NumericVector uRandomEffects,
                                                                       NumericVector spatialTau,
                                                                       NumericVector spatialRho,
                                                                       NumericMatrix varianceCovarianceU,
                                                                       NumericVector sigmaSquaredE,
                                                                       double covarianceBetaPrior,
                                                                       NumericVector spatialTauTuningParameters,
                                                                       NumericVector spatialTauAcceptanceRate,
                                                                       NumericVector numberOfAcceptedSpatialTauDraws,
                                                                       NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                       NumericVector spatialRhoTuningParameters,
                                                                       NumericVector spatialRhoAcceptanceRate,
                                                                       NumericVector numberOfAcceptedSpatialRhoDraws,
                                                                       NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                                       NumericMatrix QSpatialMatrixComponent1,
                                                                       NumericVector QSpatialMatrixComponent1EigenValues,
                                                                       double sigmaSquaredSpatialTau,
                                                                       double xi,
                                                                       NumericMatrix omega,
                                                                       double a3,
                                                                       double b3,
                                                                       int currentNumberOfIterations,
                                                                       bool betaFixed,
                                                                       bool spatialRandomEffectsFixed,
                                                                       bool uRandomEffectsFixed,
                                                                       bool spatialTauFixed,
                                                                       bool spatialRhoFixed,
                                                                       bool varianceCovarianceUFixed,
                                                                       bool sigmaSquaredEFixed,
                                                                       NumericVector trueBetaValues,
                                                                       NumericVector trueSpatialRandomEffectsValues,
                                                                       NumericVector trueURandomEffectsValues,
                                                                       NumericVector trueSpatialTauValues,
                                                                       NumericVector trueSpatialRhoValues,
                                                                       NumericMatrix trueVarianceCovarianceUValues,
                                                                       NumericVector trueSigmaSquaredEValues,
                                                                       bool centerSpatialRandomEffects,
                                                                       bool centerURandomEffects);

List multivariateGaussianNetworkLerouxTauMHHalfNormalPriorAllUpdate(NumericMatrix standardizedX,
                                                                    NumericVector y,
                                                                    const int numberOfResponses,
                                                                    NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                    NumericMatrix spatialAssignment,
                                                                    NumericMatrix W,
                                                                    const int numberOfSpatialAreas,
                                                                    NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                    NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                                    NumericMatrix WInTripletForm,
                                                                    NumericVector beta,
                                                                    NumericVector spatialRandomEffects,
                                                                    NumericVector uRandomEffects,
                                                                    NumericVector spatialTau,
                                                                    NumericVector spatialRho,
                                                                    NumericMatrix varianceCovarianceU,
                                                                    NumericVector sigmaSquaredE,
                                                                    double covarianceBetaPrior,
                                                                    NumericVector spatialTauTuningParameters,
                                                                    NumericVector spatialTauAcceptanceRate,
                                                                    NumericVector numberOfAcceptedSpatialTauDraws,
                                                                    NumericVector numberOfAllAcceptedSpatialTauDraws,
                                                                    NumericVector spatialRhoTuningParameters,
                                                                    NumericVector spatialRhoAcceptanceRate,
                                                                    NumericVector numberOfAcceptedSpatialRhoDraws,
                                                                    NumericVector numberOfAllAcceptedSpatialRhoDraws,
                                                                    double sigmaSquaredSpatialTau,
                                                                    double xi,
                                                                    NumericMatrix omega,
                                                                    double a3,
                                                                    double b3,
                                                                    int currentNumberOfIterations,
                                                                    const int numberOfSamples,
                                                                    const int burnin,
                                                                    const int thin,
                                                                    bool betaFixed,
                                                                    bool spatialRandomEffectsFixed,
                                                                    bool uRandomEffectsFixed,
                                                                    bool spatialTauFixed,
                                                                    bool spatialRhoFixed,
                                                                    bool varianceCovarianceUFixed,
                                                                    bool sigmaSquaredEFixed,
                                                                    NumericVector trueBetaValues,
                                                                    NumericVector trueSpatialRandomEffectsValues,
                                                                    NumericVector trueURandomEffectsValues,
                                                                    NumericVector trueSpatialTauValues,
                                                                    NumericVector trueSpatialRhoValues,
                                                                    NumericMatrix trueVarianceCovarianceUValues,
                                                                    NumericVector trueSigmaSquaredEValues,
                                                                    bool centerSpatialRandomEffects,
                                                                    bool centerURandomEffects);


NumericMatrix multivariateBinomialNetworkLerouxKroneckerVarianceCovarianceSpatialUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                                const int numberOfResponses,
                                                                                NumericVector spatialRandomEffects,
                                                                                double rho,
                                                                                double xiSpatial,
                                                                                NumericMatrix omegaSpatial);

List multivariateBinomialNetworkLerouxKroneckerRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                          const int numberOfResponses,
                                                          NumericVector spatialRandomEffects,
                                                          double spatialRho,
                                                          double spatialRhoTuningParameters,
                                                          double spatialRhoAcceptanceRate,
                                                          double numberOfAcceptedSpatialRhoDraws,
                                                          double numberOfAllAcceptedSpatialRhoDraws,
                                                          NumericMatrix varianceCovarianceSpatial,
                                                          NumericMatrix QSpatialMatrixComponent1,
                                                          NumericVector QSpatialMatrixComponent1EigenValues,
                                                          int currentNumberOfIterations);

List multivariateBinomialNetworkLerouxKroneckerSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                                          const int numberOfResponses,
                                                                          NumericMatrix spatialAssignment,
                                                                          NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                          NumericVector trials,
                                                                          NumericVector y,
                                                                          const int numberOfSpatialAreas,
                                                                          NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                          NumericMatrix WInTripletForm,
                                                                          const int numberOfRowsInSquareSpatialNeighbourhoodMatrix,
                                                                          const int numberOfRowsInWTripletForm,
                                                                          NumericVector beta,
                                                                          NumericVector spatialRandomEffects,
                                                                          NumericVector uRandomEffects,
                                                                          double spatialRho,
                                                                          NumericVector spatialRandomEffectsTuningParameters,
                                                                          NumericVector spatialRandomEffectsAcceptanceRate,
                                                                          NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                          NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                          NumericMatrix varianceCovarianceSpatial,
                                                                          int currentNumberOfIterations,
                                                                          bool centerSpatialRandomEffects);

List multivariateBinomialNetworkLerouxKroneckerSingleUpdate(NumericMatrix standardizedX,
                                                            NumericVector trials,
                                                            NumericVector y,
                                                            const int numberOfResponses,
                                                            NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                            NumericMatrix spatialAssignment,
                                                            NumericMatrix W,
                                                            const int numberOfSpatialAreas,
                                                            NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                            NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                            NumericMatrix WInTripletForm,
                                                            NumericVector beta,
                                                            NumericVector spatialRandomEffects,
                                                            NumericVector uRandomEffects,
                                                            NumericMatrix varianceCovarianceSpatial,
                                                            double spatialRho,
                                                            NumericMatrix varianceCovarianceU,
                                                            double covarianceBetaPrior,
                                                            const int numberOfBetaBlocks,
                                                            const int maxBetaBlockSize,
                                                            NumericVector betaTuningParameter,
                                                            NumericVector betaAcceptanceRate,
                                                            NumericVector numberOfAcceptedBetaDraws,
                                                            NumericVector numberOfAllAcceptedBetaDraws,
                                                            NumericVector spatialRandomEffectsTuningParameters,
                                                            NumericVector spatialRandomEffectsAcceptanceRate,
                                                            NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                            NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                            NumericVector uRandomEffectsTuningParameters,
                                                            NumericVector uRandomEffectsAcceptanceRate,
                                                            NumericVector numberOfAcceptedUREDraws,
                                                            NumericVector numberOfAllAcceptedUREDraws,
                                                            double spatialRhoTuningParameters,
                                                            double spatialRhoAcceptanceRate,
                                                            int numberOfAcceptedSpatialRhoDraws,
                                                            int numberOfAllAcceptedSpatialRhoDraws,
                                                            NumericMatrix QSpatialMatrixComponent1,
                                                            NumericVector QSpatialMatrixComponent1EigenValues,
                                                            double xiSpatial,
                                                            NumericMatrix omegaSpatial,
                                                            double xi,
                                                            NumericMatrix omega,
                                                            int currentNumberOfIterations,
                                                            bool betaFixed,
                                                            bool spatialRandomEffectsFixed,
                                                            bool uRandomEffectsFixed,
                                                            bool varianceCovarianceSpatialFixed,
                                                            bool spatialRhoFixed,
                                                            bool varianceCovarianceUFixed,
                                                            NumericVector trueBetaValues,
                                                            NumericVector trueSpatialRandomEffectsValues,
                                                            NumericVector trueURandomEffectsValues,
                                                            NumericMatrix trueVarianceCovarianceSpatialValues,
                                                            double trueSpatialRhoValues,
                                                            NumericMatrix trueVarianceCovarianceUValues,
                                                            bool centerSpatialRandomEffects,
                                                            bool centerURandomEffects);

List multivariateBinomialNetworkLerouxKroneckerAllUpdate(NumericMatrix standardizedX,
                                                         NumericVector trials,
                                                         NumericVector y,
                                                         const int numberOfResponses,
                                                         NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                         NumericMatrix spatialAssignment,
                                                         NumericMatrix W,
                                                         const int numberOfSpatialAreas,
                                                         NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                         NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                         NumericMatrix WInTripletForm,
                                                         NumericVector beta,
                                                         NumericVector spatialRandomEffects,
                                                         NumericVector uRandomEffects,
                                                         NumericMatrix varianceCovarianceSpatial,
                                                         double spatialRho,
                                                         NumericMatrix varianceCovarianceU,
                                                         double covarianceBetaPrior,
                                                         const int numberOfBetaBlocks,
                                                         const int maxBetaBlockSize,
                                                         NumericVector betaTuningParameter,
                                                         NumericVector betaAcceptanceRate,
                                                         NumericVector numberOfAcceptedBetaDraws,
                                                         NumericVector numberOfAllAcceptedBetaDraws,
                                                         NumericVector spatialRandomEffectsTuningParameters,
                                                         NumericVector spatialRandomEffectsAcceptanceRate,
                                                         NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                         NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                         NumericVector uRandomEffectsTuningParameters,
                                                         NumericVector uRandomEffectsAcceptanceRate,
                                                         NumericVector numberOfAcceptedUREDraws,
                                                         NumericVector numberOfAllAcceptedUREDraws,
                                                         double spatialRhoTuningParameters,
                                                         double spatialRhoAcceptanceRate,
                                                         int numberOfAcceptedSpatialRhoDraws,
                                                         int numberOfAllAcceptedSpatialRhoDraws,
                                                         double xiSpatial,
                                                         NumericMatrix omegaSpatial,
                                                         double xi,
                                                         NumericMatrix omega,
                                                         int currentNumberOfIterations,
                                                         const int numberOfSamples,
                                                         const int burnin,
                                                         const int thin,
                                                         bool betaFixed,
                                                         bool spatialRandomEffectsFixed,
                                                         bool uRandomEffectsFixed,
                                                         bool varianceCovarianceSpatialFixed,
                                                         bool spatialRhoFixed,
                                                         bool varianceCovarianceUFixed,
                                                         NumericVector trueBetaValues,
                                                         NumericVector trueSpatialRandomEffectsValues,
                                                         NumericVector trueURandomEffectsValues,
                                                         NumericMatrix trueVarianceCovarianceSpatialValues,
                                                         double trueSpatialRhoValues,
                                                         NumericMatrix trueVarianceCovarianceUValues,
                                                         bool centerSpatialRandomEffects,
                                                         bool centerURandomEffects);

NumericMatrix multivariatePoissonNetworkLerouxKroneckerVarianceCovarianceSpatialUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                              const int numberOfResponses,
                                                                              NumericVector spatialRandomEffects,
                                                                              double spatialRho,
                                                                              double xiSpatial,
                                                                              NumericMatrix omegaSpatial);

List multivariatePoissonNetworkLerouxKroneckerRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                        const int numberOfResponses,
                                                        NumericVector spatialRandomEffects,
                                                        double spatialRho,
                                                        double spatialRhoTuningParameters,
                                                        double spatialRhoAcceptanceRate,
                                                        double numberOfAcceptedSpatialRhoDraws,
                                                        double numberOfAllAcceptedSpatialRhoDraws,
                                                        NumericMatrix varianceCovarianceSpatial,
                                                        NumericMatrix QSpatialMatrixComponent1,
                                                        NumericVector QSpatialMatrixComponent1EigenValues,
                                                        int currentNumberOfIterations);

List multivariatePoissonNetworkLerouxKroneckerSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                                         const int numberOfResponses,
                                                                         NumericMatrix spatialAssignment,
                                                                         NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                         NumericVector y,
                                                                         const int numberOfSpatialAreas,
                                                                         NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                                         NumericMatrix WInTripletForm,
                                                                         const int numberOfRowsInSquareSpatialNeighbourhoodMatrix,
                                                                         const int numberOfRowsInWTripletForm,
                                                                         NumericVector beta,
                                                                         NumericVector spatialRandomEffects,
                                                                         NumericVector uRandomEffects,
                                                                         double spatialRho,
                                                                         NumericVector spatialRandomEffectsTuningParameters,
                                                                         NumericVector spatialRandomEffectsAcceptanceRate,
                                                                         NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                                         NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                                         NumericMatrix varianceCovarianceSpatial,
                                                                         int currentNumberOfIterations,
                                                                         bool centerSpatialRandomEffects);

List multivariatePoissonNetworkLerouxKroneckerSingleUpdate(NumericMatrix standardizedX,
                                                           NumericVector y,
                                                           const int numberOfResponses,
                                                           NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                           NumericMatrix spatialAssignment,
                                                           NumericMatrix W,
                                                           const int numberOfSpatialAreas,
                                                           NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                           NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                           NumericMatrix WInTripletForm,
                                                           NumericVector beta,
                                                           NumericVector spatialRandomEffects,
                                                           NumericVector uRandomEffects,
                                                           NumericMatrix varianceCovarianceSpatial,
                                                           double spatialRho,
                                                           NumericMatrix varianceCovarianceU,
                                                           double covarianceBetaPrior,
                                                           const int numberOfBetaBlocks,
                                                           const int maxBetaBlockSize,
                                                           NumericVector betaTuningParameter,
                                                           NumericVector betaAcceptanceRate,
                                                           NumericVector numberOfAcceptedBetaDraws,
                                                           NumericVector numberOfAllAcceptedBetaDraws,
                                                           NumericVector spatialRandomEffectsTuningParameters,
                                                           NumericVector spatialRandomEffectsAcceptanceRate,
                                                           NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                           NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                           NumericVector uRandomEffectsTuningParameters,
                                                           NumericVector uRandomEffectsAcceptanceRate,
                                                           NumericVector numberOfAcceptedUREDraws,
                                                           NumericVector numberOfAllAcceptedUREDraws,
                                                           double spatialRhoTuningParameters,
                                                           double spatialRhoAcceptanceRate,
                                                           int numberOfAcceptedSpatialRhoDraws,
                                                           int numberOfAllAcceptedSpatialRhoDraws,
                                                           NumericMatrix QSpatialMatrixComponent1,
                                                           NumericVector QSpatialMatrixComponent1EigenValues,
                                                           double xiSpatial,
                                                           NumericMatrix omegaSpatial,
                                                           double xi,
                                                           NumericMatrix omega,
                                                           int currentNumberOfIterations,
                                                           bool betaFixed,
                                                           bool spatialRandomEffectsFixed,
                                                           bool uRandomEffectsFixed,
                                                           bool varianceCovarianceSpatialFixed,
                                                           bool spatialRhoFixed,
                                                           bool varianceCovarianceUFixed,
                                                           NumericVector trueBetaValues,
                                                           NumericVector trueSpatialRandomEffectsValues,
                                                           NumericVector trueURandomEffectsValues,
                                                           NumericMatrix trueVarianceCovarianceSpatialValues,
                                                           double trueSpatialRhoValues,
                                                           NumericMatrix trueVarianceCovarianceUValues,
                                                           bool centerSpatialRandomEffects,
                                                           bool centerURandomEffects);

List multivariatePoissonNetworkLerouxKroneckerAllUpdate(NumericMatrix standardizedX,
                                                        NumericVector y,
                                                        const int numberOfResponses,
                                                        NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                        NumericMatrix spatialAssignment,
                                                        NumericMatrix W,
                                                        const int numberOfSpatialAreas,
                                                        NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                        NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                        NumericMatrix WInTripletForm,
                                                        NumericVector beta,
                                                        NumericVector spatialRandomEffects,
                                                        NumericVector uRandomEffects,
                                                        NumericMatrix varianceCovarianceSpatial,
                                                        double spatialRho,
                                                        NumericMatrix varianceCovarianceU,
                                                        double covarianceBetaPrior,
                                                        const int numberOfBetaBlocks,
                                                        const int maxBetaBlockSize,
                                                        NumericVector betaTuningParameter,
                                                        NumericVector betaAcceptanceRate,
                                                        NumericVector numberOfAcceptedBetaDraws,
                                                        NumericVector numberOfAllAcceptedBetaDraws,
                                                        NumericVector spatialRandomEffectsTuningParameters,
                                                        NumericVector spatialRandomEffectsAcceptanceRate,
                                                        NumericVector numberOfAcceptedSpatialRandomEffectsDraws,
                                                        NumericVector numberOfAllAcceptedSpatialRandomEffectsDraws,
                                                        NumericVector uRandomEffectsTuningParameters,
                                                        NumericVector uRandomEffectsAcceptanceRate,
                                                        NumericVector numberOfAcceptedUREDraws,
                                                        NumericVector numberOfAllAcceptedUREDraws,
                                                        double spatialRhoTuningParameters,
                                                        double spatialRhoAcceptanceRate,
                                                        int numberOfAcceptedSpatialRhoDraws,
                                                        int numberOfAllAcceptedSpatialRhoDraws,
                                                        double xiSpatial,
                                                        NumericMatrix omegaSpatial,
                                                        double xi,
                                                        NumericMatrix omega,
                                                        int currentNumberOfIterations,
                                                        const int numberOfSamples,
                                                        const int burnin,
                                                        const int thin,
                                                        bool betaFixed,
                                                        bool spatialRandomEffectsFixed,
                                                        bool uRandomEffectsFixed,
                                                        bool varianceCovarianceSpatialFixed,
                                                        bool spatialRhoFixed,
                                                        bool varianceCovarianceUFixed,
                                                        NumericVector trueBetaValues,
                                                        NumericVector trueSpatialRandomEffectsValues,
                                                        NumericVector trueURandomEffectsValues,
                                                        NumericMatrix trueVarianceCovarianceSpatialValues,
                                                        double trueSpatialRhoValues,
                                                        NumericMatrix trueVarianceCovarianceUValues,
                                                        bool centerSpatialRandomEffects,
                                                        bool centerURandomEffects);

NumericVector multivariateGaussianNetworkLerouxKroneckerSpatialRandomEffectsUpdate(NumericMatrix standardizedX,
                                                                                   const int numberOfResponses,
                                                                                   NumericMatrix spatialAssignment,
                                                                                   NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                                   NumericVector y,
                                                                                   NumericMatrix WInTripletForm,
                                                                                   const int numberOfRowsInWTripletForm,
                                                                                   NumericVector beta,
                                                                                   NumericVector spatialRandomEffects,
                                                                                   NumericVector uRandomEffects,
                                                                                   double spatialRho,
                                                                                   NumericVector sigmaSquaredE,
                                                                                   NumericMatrix varianceCovarianceSpatial,
                                                                                   bool centerSpatialRandomEffects);

List multivariateGaussianNetworkLerouxKroneckerRhoUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                         const int numberOfResponses,
                                                         NumericVector spatialRandomEffects,
                                                         double spatialRho,
                                                         double spatialRhoTuningParameters,
                                                         double spatialRhoAcceptanceRate,
                                                         double numberOfAcceptedSpatialRhoDraws,
                                                         double numberOfAllAcceptedSpatialRhoDraws,
                                                         NumericMatrix varianceCovarianceSpatial,
                                                         NumericMatrix QSpatialMatrixComponent1,
                                                         NumericVector QSpatialMatrixComponent1EigenValues,
                                                         int currentNumberOfIterations);

NumericMatrix multivariateGaussianNetworkLerouxKroneckerVarianceCovarianceSpatialUpdate(NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                                                        const int numberOfResponses,
                                                                                        NumericVector spatialRandomEffects,
                                                                                        double spatialRho,
                                                                                        double xiSpatial,
                                                                                        NumericMatrix omegaSpatial);

List multivariateGaussianNetworkLerouxKroneckerSingleUpdate(NumericMatrix standardizedX,
                                                            NumericVector y,
                                                            const int numberOfResponses,
                                                            NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                            NumericMatrix spatialAssignment,
                                                            NumericMatrix W,
                                                            const int numberOfSpatialAreas,
                                                            NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                            NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                            NumericMatrix WInTripletForm,
                                                            NumericVector beta,
                                                            NumericVector spatialRandomEffects,
                                                            NumericVector uRandomEffects,
                                                            NumericMatrix varianceCovarianceSpatial,
                                                            double spatialRho,
                                                            NumericMatrix varianceCovarianceU,
                                                            NumericVector sigmaSquaredE,
                                                            double covarianceBetaPrior,
                                                            double spatialRhoTuningParameters,
                                                            double spatialRhoAcceptanceRate,
                                                            int numberOfAcceptedSpatialRhoDraws,
                                                            int numberOfAllAcceptedSpatialRhoDraws,
                                                            NumericMatrix QSpatialMatrixComponent1,
                                                            NumericVector QSpatialMatrixComponent1EigenValues,
                                                            double xiSpatial,
                                                            NumericMatrix omegaSpatial,
                                                            double xi,
                                                            NumericMatrix omega,
                                                            double a3,
                                                            double b3,
                                                            int currentNumberOfIterations,
                                                            bool betaFixed,
                                                            bool spatialRandomEffectsFixed,
                                                            bool uRandomEffectsFixed,
                                                            bool varianceCovarianceSpatialFixed,
                                                            bool spatialRhoFixed,
                                                            bool varianceCovarianceUFixed,
                                                            bool sigmaSquaredEFixed,
                                                            NumericVector trueBetaValues,
                                                            NumericVector trueSpatialRandomEffectsValues,
                                                            NumericVector trueURandomEffectsValues,
                                                            NumericMatrix trueVarianceCovarianceSpatialValues,
                                                            double trueSpatialRhoValues,
                                                            NumericMatrix trueVarianceCovarianceUValues,
                                                            NumericVector trueSigmaSquaredEValues,
                                                            bool centerSpatialRandomEffects,
                                                            bool centerURandomEffects);

List multivariateGaussianNetworkLerouxKroneckerAllUpdate(NumericMatrix standardizedX,
                                                         NumericVector y,
                                                         const int numberOfResponses,
                                                         NumericMatrix squareSpatialNeighbourhoodMatrix,
                                                         NumericMatrix spatialAssignment,
                                                         NumericMatrix W,
                                                         const int numberOfSpatialAreas,
                                                         NumericMatrix squareSpatialNeighbourhoodMatrixInTripletForm,
                                                         NumericMatrix spatialAssignmentMatrixInTripletForm,
                                                         NumericMatrix WInTripletForm,
                                                         NumericVector beta,
                                                         NumericVector spatialRandomEffects,
                                                         NumericVector uRandomEffects,
                                                         NumericMatrix varianceCovarianceSpatial,
                                                         double spatialRho,
                                                         NumericMatrix varianceCovarianceU,
                                                         NumericVector sigmaSquaredE,
                                                         double covarianceBetaPrior,
                                                         double spatialRhoTuningParameters,
                                                         double spatialRhoAcceptanceRate,
                                                         int numberOfAcceptedSpatialRhoDraws,
                                                         int numberOfAllAcceptedSpatialRhoDraws,
                                                         double xiSpatial,
                                                         NumericMatrix omegaSpatial,
                                                         double xi,
                                                         NumericMatrix omega,
                                                         double a3,
                                                         double b3,
                                                         int currentNumberOfIterations,
                                                         const int numberOfSamples,
                                                         const int burnin,
                                                         const int thin,
                                                         bool betaFixed,
                                                         bool spatialRandomEffectsFixed,
                                                         bool uRandomEffectsFixed,
                                                         bool varianceCovarianceSpatialFixed,
                                                         bool spatialRhoFixed,
                                                         bool varianceCovarianceUFixed,
                                                         bool sigmaSquaredEFixed,
                                                         NumericVector trueBetaValues,
                                                         NumericVector trueSpatialRandomEffectsValues,
                                                         NumericVector trueURandomEffectsValues,
                                                         NumericMatrix trueVarianceCovarianceSpatialValues,
                                                         double trueSpatialRhoValues,
                                                         NumericMatrix trueVarianceCovarianceUValues,
                                                         NumericVector trueSigmaSquaredEValues,
                                                         bool centerSpatialRandomEffects,
                                                         bool centerURandomEffects);

List multivariateBinomialNetworkRandVRandomEffectsUpdate(NumericMatrix standardizedX,
                                                         NumericVector trials,
                                                         NumericVector y,
                                                         NumericMatrix V,
                                                         NumericMatrix W,
                                                         const int numberOfResponses,
                                                         NumericMatrix WInTripletForm,
                                                         const int numberOfRowsInWTripletForm,
                                                         NumericVector beta,
                                                         NumericVector vRandomEffects,
                                                         NumericVector uRandomEffects,
                                                         NumericMatrix varianceCovarianceV,
                                                         NumericVector vRandomEffectsTuningParameters,
                                                         NumericVector vRandomEffectsAcceptanceRate,
                                                         NumericVector numberOfAcceptedVREDraws,
                                                         NumericVector numberOfAllAcceptedVREDraws,
                                                         int currentNumberOfIterations,
                                                         bool centerVRandomEffects);

List multivariateBinomialNetworkRandSingleUpdate(NumericMatrix standardizedX,
                                                 NumericVector trials,
                                                 NumericVector y,
                                                 const int numberOfResponses,
                                                 NumericMatrix V,
                                                 NumericMatrix W,
                                                 NumericMatrix VInTripletForm,
                                                 NumericMatrix WInTripletForm,
                                                 NumericVector beta,
                                                 NumericVector vRandomEffects,
                                                 NumericVector uRandomEffects,
                                                 NumericMatrix varianceCovarianceV,
                                                 NumericMatrix varianceCovarianceU,
                                                 double covarianceBetaPrior,
                                                 const int numberOfBetaBlocks,
                                                 const int maxBetaBlockSize,
                                                 NumericVector betaTuningParameter,
                                                 NumericVector betaAcceptanceRate,
                                                 NumericVector numberOfAcceptedBetaDraws,
                                                 NumericVector numberOfAllAcceptedBetaDraws,
                                                 NumericVector vRandomEffectsTuningParameters,
                                                 NumericVector vRandomEffectsAcceptanceRate,
                                                 NumericVector numberOfAcceptedVREDraws,
                                                 NumericVector numberOfAllAcceptedVREDraws,
                                                 NumericVector uRandomEffectsTuningParameters,
                                                 NumericVector uRandomEffectsAcceptanceRate,
                                                 NumericVector numberOfAcceptedUREDraws,
                                                 NumericVector numberOfAllAcceptedUREDraws,
                                                 double xiV,
                                                 NumericMatrix omegaV,
                                                 double xi,
                                                 NumericMatrix omega,
                                                 int currentNumberOfIterations,
                                                 bool betaFixed,
                                                 bool vRandomEffectsFixed,
                                                 bool uRandomEffectsFixed,
                                                 bool varianceCovarianceVFixed,
                                                 bool varianceCovarianceUFixed,
                                                 NumericVector trueBetaValues,
                                                 NumericVector trueVRandomEffectsValues,
                                                 NumericVector trueURandomEffectsValues,
                                                 NumericMatrix trueVarianceCovarianceVValues,
                                                 NumericMatrix trueVarianceCovarianceUValues,
                                                 bool centerVRandomEffects,
                                                 bool centerURandomEffects);

List multivariateBinomialNetworkRandAllUpdate(NumericMatrix standardizedX,
                                              NumericVector trials,
                                              NumericVector y,
                                              const int numberOfResponses,
                                              NumericMatrix V,
                                              NumericMatrix W,
                                              NumericMatrix VInTripletForm,
                                              NumericMatrix WInTripletForm,
                                              NumericVector beta,
                                              NumericVector vRandomEffects,
                                              NumericVector uRandomEffects,
                                              NumericMatrix varianceCovarianceV,
                                              NumericMatrix varianceCovarianceU,
                                              double covarianceBetaPrior,
                                              const int numberOfBetaBlocks,
                                              const int maxBetaBlockSize,
                                              NumericVector betaTuningParameter,
                                              NumericVector betaAcceptanceRate,
                                              NumericVector numberOfAcceptedBetaDraws,
                                              NumericVector numberOfAllAcceptedBetaDraws,
                                              NumericVector vRandomEffectsTuningParameters,
                                              NumericVector vRandomEffectsAcceptanceRate,
                                              NumericVector numberOfAcceptedVREDraws,
                                              NumericVector numberOfAllAcceptedVREDraws,
                                              NumericVector uRandomEffectsTuningParameters,
                                              NumericVector uRandomEffectsAcceptanceRate,
                                              NumericVector numberOfAcceptedUREDraws,
                                              NumericVector numberOfAllAcceptedUREDraws,
                                              double xiV,
                                              NumericMatrix omegaV,
                                              double xi,
                                              NumericMatrix omega,
                                              int currentNumberOfIterations,
                                              const int numberOfSamples,
                                              const int burnin,
                                              const int thin,
                                              bool betaFixed,
                                              bool vRandomEffectsFixed,
                                              bool uRandomEffectsFixed,
                                              bool varianceCovarianceVFixed,
                                              bool varianceCovarianceUFixed,
                                              NumericVector trueBetaValues,
                                              NumericVector trueVRandomEffectsValues,
                                              NumericVector trueURandomEffectsValues,
                                              NumericMatrix trueVarianceCovarianceVValues,
                                              NumericMatrix trueVarianceCovarianceUValues,
                                              bool centerVRandomEffects,
                                              bool centerURandomEffects);

List multivariatePoissonNetworkRandVRandomEffectsUpdate(NumericMatrix standardizedX,
                                                        NumericVector y,
                                                        NumericMatrix V,
                                                        NumericMatrix W,
                                                        const int numberOfResponses,
                                                        NumericMatrix WInTripletForm,
                                                        const int numberOfRowsInWTripletForm,
                                                        NumericVector beta,
                                                        NumericVector vRandomEffects,
                                                        NumericVector uRandomEffects,
                                                        NumericMatrix varianceCovarianceV,
                                                        NumericVector vRandomEffectsTuningParameters,
                                                        NumericVector vRandomEffectsAcceptanceRate,
                                                        NumericVector numberOfAcceptedVREDraws,
                                                        NumericVector numberOfAllAcceptedVREDraws,
                                                        int currentNumberOfIterations,
                                                        bool centerVRandomEffects);

List multivariatePoissonNetworkRandSingleUpdate(NumericMatrix standardizedX,
                                                NumericVector y,
                                                const int numberOfResponses,
                                                NumericMatrix V,
                                                NumericMatrix W,
                                                NumericMatrix VInTripletForm,
                                                NumericMatrix WInTripletForm,
                                                NumericVector beta,
                                                NumericVector vRandomEffects,
                                                NumericVector uRandomEffects,
                                                NumericMatrix varianceCovarianceV,
                                                NumericMatrix varianceCovarianceU,
                                                double covarianceBetaPrior,
                                                const int numberOfBetaBlocks,
                                                const int maxBetaBlockSize,
                                                NumericVector betaTuningParameter,
                                                NumericVector betaAcceptanceRate,
                                                NumericVector numberOfAcceptedBetaDraws,
                                                NumericVector numberOfAllAcceptedBetaDraws,
                                                NumericVector vRandomEffectsTuningParameters,
                                                NumericVector vRandomEffectsAcceptanceRate,
                                                NumericVector numberOfAcceptedVREDraws,
                                                NumericVector numberOfAllAcceptedVREDraws,
                                                NumericVector uRandomEffectsTuningParameters,
                                                NumericVector uRandomEffectsAcceptanceRate,
                                                NumericVector numberOfAcceptedUREDraws,
                                                NumericVector numberOfAllAcceptedUREDraws,
                                                double xiV,
                                                NumericMatrix omegaV,
                                                double xi,
                                                NumericMatrix omega,
                                                int currentNumberOfIterations,
                                                bool betaFixed,
                                                bool vRandomEffectsFixed,
                                                bool uRandomEffectsFixed,
                                                bool varianceCovarianceVFixed,
                                                bool varianceCovarianceUFixed,
                                                NumericVector trueBetaValues,
                                                NumericVector trueVRandomEffectsValues,
                                                NumericVector trueURandomEffectsValues,
                                                NumericMatrix trueVarianceCovarianceVValues,
                                                NumericMatrix trueVarianceCovarianceUValues,
                                                bool centerVRandomEffects,
                                                bool centerURandomEffects);

List multivariatePoissonNetworkRandAllUpdate(NumericMatrix standardizedX,
                                             NumericVector y,
                                             const int numberOfResponses,
                                             NumericMatrix V,
                                             NumericMatrix W,
                                             NumericMatrix VInTripletForm,
                                             NumericMatrix WInTripletForm,
                                             NumericVector beta,
                                             NumericVector vRandomEffects,
                                             NumericVector uRandomEffects,
                                             NumericMatrix varianceCovarianceV,
                                             NumericMatrix varianceCovarianceU,
                                             double covarianceBetaPrior,
                                             const int numberOfBetaBlocks,
                                             const int maxBetaBlockSize,
                                             NumericVector betaTuningParameter,
                                             NumericVector betaAcceptanceRate,
                                             NumericVector numberOfAcceptedBetaDraws,
                                             NumericVector numberOfAllAcceptedBetaDraws,
                                             NumericVector vRandomEffectsTuningParameters,
                                             NumericVector vRandomEffectsAcceptanceRate,
                                             NumericVector numberOfAcceptedVREDraws,
                                             NumericVector numberOfAllAcceptedVREDraws,
                                             NumericVector uRandomEffectsTuningParameters,
                                             NumericVector uRandomEffectsAcceptanceRate,
                                             NumericVector numberOfAcceptedUREDraws,
                                             NumericVector numberOfAllAcceptedUREDraws,
                                             double xiV,
                                             NumericMatrix omegaV,
                                             double xi,
                                             NumericMatrix omega,
                                             int currentNumberOfIterations,
                                             const int numberOfSamples,
                                             const int burnin,
                                             const int thin,
                                             bool betaFixed,
                                             bool vRandomEffectsFixed,
                                             bool uRandomEffectsFixed,
                                             bool varianceCovarianceVFixed,
                                             bool varianceCovarianceUFixed,
                                             NumericVector trueBetaValues,
                                             NumericVector trueVRandomEffectsValues,
                                             NumericVector trueURandomEffectsValues,
                                             NumericMatrix trueVarianceCovarianceVValues,
                                             NumericMatrix trueVarianceCovarianceUValues,
                                             bool centerVRandomEffects,
                                             bool centerURandomEffects);

NumericVector multivariateGaussianNetworkRandVRandomEffectsUpdate(NumericMatrix standardizedX,
                                                                  NumericVector y,
                                                                  NumericMatrix V,
                                                                  NumericMatrix W,
                                                                  const int numberOfResponses,
                                                                  NumericMatrix WInTripletForm,
                                                                  const int numberOfRowsInWTripletForm,
                                                                  NumericVector beta,
                                                                  NumericVector vRandomEffects,
                                                                  NumericVector uRandomEffects,
                                                                  NumericMatrix varianceCovarianceV,
                                                                  NumericVector sigmaSquaredE,
                                                                  bool centerVRandomEffects);

List multivariateGaussianNetworkRandSingleUpdate(NumericMatrix standardizedX,
                                                 NumericVector y,
                                                 const int numberOfResponses,
                                                 NumericMatrix V,
                                                 NumericMatrix W,
                                                 NumericMatrix VInTripletForm,
                                                 NumericMatrix WInTripletForm,
                                                 NumericVector beta,
                                                 NumericVector vRandomEffects,
                                                 NumericVector uRandomEffects,
                                                 NumericMatrix varianceCovarianceV,
                                                 NumericMatrix varianceCovarianceU,
                                                 NumericVector sigmaSquaredE,
                                                 double covarianceBetaPrior,
                                                 double xiV,
                                                 NumericMatrix omegaV,
                                                 double xi,
                                                 NumericMatrix omega,
                                                 double a3,
                                                 double b3,
                                                 int currentNumberOfIterations,
                                                 bool betaFixed,
                                                 bool vRandomEffectsFixed,
                                                 bool uRandomEffectsFixed,
                                                 bool varianceCovarianceVFixed,
                                                 bool varianceCovarianceUFixed,
                                                 bool sigmaSquaredEFixed,
                                                 NumericVector trueBetaValues,
                                                 NumericVector trueVRandomEffectsValues,
                                                 NumericVector trueURandomEffectsValues,
                                                 NumericMatrix trueVarianceCovarianceVValues,
                                                 NumericMatrix trueVarianceCovarianceUValues,
                                                 NumericVector trueSigmaSquaredEValues,
                                                 bool centerVRandomEffects,
                                                 bool centerURandomEffects);

List multivariateGaussianNetworkRandAllUpdate(NumericMatrix standardizedX,
                                              NumericVector y,
                                              const int numberOfResponses,
                                              NumericMatrix V,
                                              NumericMatrix W,
                                              NumericMatrix VInTripletForm,
                                              NumericMatrix WInTripletForm,
                                              NumericVector beta,
                                              NumericVector vRandomEffects,
                                              NumericVector uRandomEffects,
                                              NumericMatrix varianceCovarianceV,
                                              NumericMatrix varianceCovarianceU,
                                              NumericVector sigmaSquaredE,
                                              double covarianceBetaPrior,
                                              double xiV,
                                              NumericMatrix omegaV,
                                              double xi,
                                              NumericMatrix omega,
                                              double a3,
                                              double b3,
                                              int currentNumberOfIterations,
                                              const int numberOfSamples,
                                              const int burnin,
                                              const int thin,
                                              bool betaFixed,
                                              bool vRandomEffectsFixed,
                                              bool uRandomEffectsFixed,
                                              bool varianceCovarianceVFixed,
                                              bool varianceCovarianceUFixed,
                                              bool sigmaSquaredEFixed,
                                              NumericVector trueBetaValues,
                                              NumericVector trueVRandomEffectsValues,
                                              NumericVector trueURandomEffectsValues,
                                              NumericMatrix trueVarianceCovarianceVValues,
                                              NumericMatrix trueVarianceCovarianceUValues,
                                              NumericVector trueSigmaSquaredEValues,
                                              bool centerVRandomEffects,
                                              bool centerURandomEffects);
