% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointMatching.R
\name{getOptimalPointMatching}
\alias{getOptimalPointMatching}
\title{Computes optimal point assignment for two sets of points of equal size.}
\usage{
getOptimalPointMatching(x, y, method = "lp")
}
\arguments{
\item{x}{[\code{Network} | \code{matrix}]\cr
First network or matrix of coordinates of the first point set.}

\item{y}{[\code{Network} | \code{matrix}]\cr
Second network or matrix of coordinates of the second point set.}

\item{method}{[\code{character(1)}]\cr
Method used to solve the assignment problem. There are currently two methods
available:
\describe{
  \item{lp}{Solves the problem be means of linear programming with the
  \pkg{lpSolve} package. This is the default.}
  \item{push_relabel}{The assignment problem can be formulated as a
  matching problem on bipartite graphs. This method makes use of the
  push-relabel algorithm from the \pkg{igraph}.}
  \item{random}{Random point matching.}
}}
}
\value{
[\code{matrix}]
  Each row consists of the indizes of the pairwise matchings.
}
\description{
Internally it handles the points and the possible matchings as a bi-partite
graphs and finds an optimal matching due to euclidean distance by an
efficient linear programming solver.
}
\seealso{
\code{\link{visualizePointMatching}}
}

