% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_apply.R
\docType{methods}
\name{net_stat_apply}
\alias{net_stat_apply}
\alias{net_stat_apply,NetSet-method}
\alias{net_stat_apply,NetSampleSet-method}
\title{Apply a network statistic function to a \code{NetSet} or \code{NetSampleSet} object.}
\usage{
net_stat_apply(netSet, net.stat.fun, net.stat.fun.args, net.stat.name)

\S4method{net_stat_apply}{NetSet}(netSet, net.stat.fun, net.stat.fun.args,
  net.stat.name)

\S4method{net_stat_apply}{NetSampleSet}(netSet, net.stat.fun, net.stat.fun.args,
  net.stat.name)
}
\arguments{
\item{netSet}{A \code{NetSet} or \code{NetSampleSet} object.}

\item{net.stat.fun}{The network statistic function}

\item{net.stat.fun.args}{A list of additional arguments to the network
statistic function}

\item{net.stat.name}{A descriptive name for the network statistic (defaults to
deparsed name of statistic function)}
}
\value{
A \code{NetStatSet} or \code{NetSampleStatSet}
}
\description{
This function applies a network statistic function to a \code{NetSet} or \code{NetSampleSet}
object, and returns the calculated network statistics.
}
\section{Methods (by class)}{
\itemize{
\item \code{NetSet}: net_stat_apply for NetSet

\item \code{NetSampleSet}: Converter for NetSampleSet
}}

\examples{
data(GroupA)
GroupA_Net = as_NetSample(GroupA, 1:20, node.variables = list(community = c(rep(1, 10), rep(2,10))),
 sample.variables = list(group = c(rep(1, 10), rep(2,10))))
Jackknife_GroupA_Net = net_apply(GroupA_Net, node_jackknife)
GlobEff_GroupA_Net = net_stat_apply(Jackknife_GroupA_Net, global_efficiency)
}
