% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rankogram.R
\name{print.rankogram}
\alias{print.rankogram}
\title{Print method for rankograms}
\usage{
\method{print}{rankogram}(
  x,
  common = x$common,
  random = x$random,
  cumulative.rankprob = x$cumulative.rankprob,
  sort = TRUE,
  nchar.trts = x$nchar.trts,
  digits = gs("digits.prop"),
  legend = gs("legend"),
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An R object of class \code{rankogram}.}

\item{common}{A logical indicating to print ranking probabilities
and SUCRAs for the common effects model.}

\item{random}{A logical indicating to print ranking probabilities
and SUCRAs for the random effects model.}

\item{cumulative.rankprob}{A logical indicating whether cumulative
ranking probabilities should be printed.}

\item{sort}{A logical indicating whether treatments should be
sorted by decreasing SUCRAs.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{digits}{Minimal number of significant digits, see
\code{\link{print.default}}.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments for printing.}
}
\description{
Print method for objects of class \code{rankogram}.
}
\examples{
pw1 <- pairwise(treatment, event = r, n = N, studlab = author,
  data = dat.woods2010, sm = "OR")
net1 <- netmeta(pw1, small.values = "desirable")

ran1 <- rankogram(net1, nsim = 100)
ran1
print(ran1, cumulative.rankprob = TRUE)

}
\references{
Salanti G, Ades AE, Ioannidis JP (2011):
Graphical methods and numerical summaries for presenting results
from multiple-treatment meta-analysis: an overview and tutorial.
\emph{Journal of Clinical Epidemiology},
\bold{64}, 163--71
}
\seealso{
\code{\link{rankogram}}, \code{\link{plot.rankogram}},
  \code{\link[metadat]{dat.woods2010}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
