% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.ranks.R
\name{compare_ranks}
\alias{compare_ranks}
\title{Count occurrences of pairs in rankings}
\usage{
compare_ranks(x, y)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector with the same length as \code{x}.}
}
\value{
A list containing
\item{concordant}{number of concordant pairs: \code{x[i]} > \code{x[j]} and \code{y[i]} > \code{y[j]}}
\item{discordant}{number of discordant pairs: \code{x[i]} > \code{x[j]} and \code{y[i]} < \code{y[j]}}
\item{ties}{number of tied pairs:  \code{x[i]} == \code{x[j]} and \code{y[i]} == \code{y[j]}}
\item{left}{number of left ties: \code{x[i]} == \code{x[j]} and \code{y[i]} != \code{y[j]}}
\item{right}{number of right ties: \code{x[i]} != \code{x[j]} and \code{y[i]} == \code{y[j]}}
}
\description{
Counts the number of concordant, discordant and (left/right) ties between two rankings.
}
\details{
Explicitly calculating the number of occurring cases is more robust
than using correlation indices as given in the \code{cor} function. Especially
left and right ties can significantly alter correlations.
}
\examples{
library(igraph)
tg <- threshold_graph(100, 0.2)
compare_ranks(degree(tg), closeness(tg)) # only concordant pairs
compare_ranks(degree(tg), betweenness(tg)) # no discordant pairs
## Rank Correlation
cor(degree(tg), closeness(tg), method = "kendall") # 1
cor(degree(tg), betweenness(tg), method = "kendall") # not 1, although no discordant pairs
}
\author{
David Schoch
}
