// Generated by rstantools.  Do not edit by hand.

/*
    networkscaleup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    networkscaleup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with networkscaleup.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_Uncorrelated_zglobal_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_Uncorrelated_zglobal");
    reader.add_event(50, 48, "end", "model_Uncorrelated_zglobal");
    return reader;
}
#include <stan_meta_header.hpp>
class model_Uncorrelated_zglobal
  : public stan::model::model_base_crtp<model_Uncorrelated_zglobal> {
private:
        int n_i;
        int n_k;
        int z_global_size;
        matrix_d z_global;
        std::vector<std::vector<int> > y;
public:
    model_Uncorrelated_zglobal(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_Uncorrelated_zglobal(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_Uncorrelated_zglobal_namespace::model_Uncorrelated_zglobal";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "n_i", "int", context__.to_vec());
            n_i = int(0);
            vals_i__ = context__.vals_i("n_i");
            pos__ = 0;
            n_i = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_i", n_i, 0);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "n_k", "int", context__.to_vec());
            n_k = int(0);
            vals_i__ = context__.vals_i("n_k");
            pos__ = 0;
            n_k = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_k", n_k, 0);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "z_global_size", "int", context__.to_vec());
            z_global_size = int(0);
            vals_i__ = context__.vals_i("z_global_size");
            pos__ = 0;
            z_global_size = vals_i__[pos__++];
            check_greater_or_equal(function__, "z_global_size", z_global_size, 0);
            current_statement_begin__ = 6;
            validate_non_negative_index("z_global", "n_i", n_i);
            validate_non_negative_index("z_global", "z_global_size", z_global_size);
            context__.validate_dims("data initialization", "z_global", "matrix_d", context__.to_vec(n_i,z_global_size));
            z_global = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_i, z_global_size);
            vals_r__ = context__.vals_r("z_global");
            pos__ = 0;
            size_t z_global_j_2_max__ = z_global_size;
            size_t z_global_j_1_max__ = n_i;
            for (size_t j_2__ = 0; j_2__ < z_global_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < z_global_j_1_max__; ++j_1__) {
                    z_global(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("y", "n_i", n_i);
            validate_non_negative_index("y", "n_k", n_k);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(n_i,n_k));
            y = std::vector<std::vector<int> >(n_i, std::vector<int>(n_k, int(0)));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = n_i;
            size_t y_k_1_max__ = n_k;
            for (size_t k_1__ = 0; k_1__ < y_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                    y[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 11;
            validate_non_negative_index("delta", "n_i", n_i);
            num_params_r__ += n_i;
            current_statement_begin__ = 12;
            num_params_r__ += 1;
            current_statement_begin__ = 13;
            validate_non_negative_index("eps", "n_i", n_i);
            validate_non_negative_index("eps", "n_k", n_k);
            num_params_r__ += (n_i * n_k);
            current_statement_begin__ = 14;
            validate_non_negative_index("beta_global", "z_global_size", z_global_size);
            num_params_r__ += z_global_size;
            current_statement_begin__ = 15;
            validate_non_negative_index("tau_N", "n_k", n_k);
            num_params_r__ += n_k;
            current_statement_begin__ = 16;
            validate_non_negative_index("rho", "n_k", n_k);
            num_params_r__ += n_k;
            current_statement_begin__ = 17;
            num_params_r__ += 1;
            current_statement_begin__ = 18;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_Uncorrelated_zglobal() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 11;
        if (!(context__.contains_r("delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "n_i", n_i);
        context__.validate_dims("parameter initialization", "delta", "vector_d", context__.to_vec(n_i));
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta(n_i);
        size_t delta_j_1_max__ = n_i;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            delta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(delta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 12;
        if (!(context__.contains_r("sigma_delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_delta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_delta", "double", context__.to_vec());
        double sigma_delta(0);
        sigma_delta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_delta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_delta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 13;
        if (!(context__.contains_r("eps")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eps missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eps");
        pos__ = 0U;
        validate_non_negative_index("eps", "n_i", n_i);
        validate_non_negative_index("eps", "n_k", n_k);
        context__.validate_dims("parameter initialization", "eps", "matrix_d", context__.to_vec(n_i,n_k));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eps(n_i, n_k);
        size_t eps_j_2_max__ = n_k;
        size_t eps_j_1_max__ = n_i;
        for (size_t j_2__ = 0; j_2__ < eps_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
                eps(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(eps);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eps: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 14;
        if (!(context__.contains_r("beta_global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_global");
        pos__ = 0U;
        validate_non_negative_index("beta_global", "z_global_size", z_global_size);
        context__.validate_dims("parameter initialization", "beta_global", "vector_d", context__.to_vec(z_global_size));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_global(z_global_size);
        size_t beta_global_j_1_max__ = z_global_size;
        for (size_t j_1__ = 0; j_1__ < beta_global_j_1_max__; ++j_1__) {
            beta_global(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_global);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_global: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 15;
        if (!(context__.contains_r("tau_N")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau_N missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau_N");
        pos__ = 0U;
        validate_non_negative_index("tau_N", "n_k", n_k);
        context__.validate_dims("parameter initialization", "tau_N", "vector_d", context__.to_vec(n_k));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_N(n_k);
        size_t tau_N_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < tau_N_j_1_max__; ++j_1__) {
            tau_N(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, tau_N);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau_N: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 16;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "n_k", n_k);
        context__.validate_dims("parameter initialization", "rho", "vector_d", context__.to_vec(n_k));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho(n_k);
        size_t rho_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            rho(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(rho);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 17;
        if (!(context__.contains_r("mu_rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_rho");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_rho", "double", context__.to_vec());
        double mu_rho(0);
        mu_rho = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu_rho);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_rho: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 18;
        if (!(context__.contains_r("sigma_rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_rho");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_rho", "double", context__.to_vec());
        double sigma_rho(0);
        sigma_rho = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_rho);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_rho: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 11;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.vector_constrain(n_i, lp__);
            else
                delta = in__.vector_constrain(n_i);
            current_statement_begin__ = 12;
            local_scalar_t__ sigma_delta;
            (void) sigma_delta;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_delta = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_delta = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 13;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eps;
            (void) eps;  // dummy to suppress unused var warning
            if (jacobian__)
                eps = in__.matrix_constrain(n_i, n_k, lp__);
            else
                eps = in__.matrix_constrain(n_i, n_k);
            current_statement_begin__ = 14;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_global;
            (void) beta_global;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_global = in__.vector_constrain(z_global_size, lp__);
            else
                beta_global = in__.vector_constrain(z_global_size);
            current_statement_begin__ = 15;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau_N;
            (void) tau_N;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_N = in__.vector_lb_constrain(0, n_k, lp__);
            else
                tau_N = in__.vector_lb_constrain(0, n_k);
            current_statement_begin__ = 16;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rho;
            (void) rho;  // dummy to suppress unused var warning
            if (jacobian__)
                rho = in__.vector_constrain(n_k, lp__);
            else
                rho = in__.vector_constrain(n_k);
            current_statement_begin__ = 17;
            local_scalar_t__ mu_rho;
            (void) mu_rho;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_rho = in__.scalar_constrain(lp__);
            else
                mu_rho = in__.scalar_constrain();
            current_statement_begin__ = 18;
            local_scalar_t__ sigma_rho;
            (void) sigma_rho;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_rho = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_rho = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 22;
            validate_non_negative_index("mu", "n_k", n_k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n_k);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 23;
            validate_non_negative_index("tau", "n_k", n_k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau(n_k);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            current_statement_begin__ = 24;
            validate_non_negative_index("bias", "n_i", n_i);
            validate_non_negative_index("bias", "n_k", n_k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> bias(n_i, n_k);
            stan::math::initialize(bias, DUMMY_VAR__);
            stan::math::fill(bias, DUMMY_VAR__);
            current_statement_begin__ = 25;
            validate_non_negative_index("prev_mean", "n_i", n_i);
            validate_non_negative_index("prev_mean", "n_k", n_k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> prev_mean(n_i, n_k);
            stan::math::initialize(prev_mean, DUMMY_VAR__);
            stan::math::fill(prev_mean, DUMMY_VAR__);
            stan::math::assign(prev_mean,stan::math::exp(add(transpose(rep_matrix(rho, n_i)), rep_matrix(add(multiply(sigma_delta, delta), multiply(z_global, beta_global)), n_k))));
            // transformed parameters block statements
            current_statement_begin__ = 27;
            stan::math::assign(mu, stan::math::log(elt_divide(1.0, stan::math::sqrt(add(1.0, elt_divide(1.0, square(tau_N)))))));
            current_statement_begin__ = 28;
            stan::math::assign(tau, stan::math::sqrt(stan::math::log(add(1.0, elt_divide(1.0, square(tau_N))))));
            current_statement_begin__ = 29;
            for (int k = 1; k <= n_k; ++k) {
                current_statement_begin__ = 30;
                stan::model::assign(bias, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                            stan::math::exp(add(get_base1(mu, k, "mu", 1), multiply(get_base1(tau, k, "tau", 1), stan::model::rvalue(eps, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "eps")))), 
                            "assigning variable bias");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 22;
            size_t mu_j_1_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 23;
            size_t tau_j_1_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tau(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tau: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 24;
            size_t bias_j_1_max__ = n_i;
            size_t bias_j_2_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < bias_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < bias_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(bias(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: bias" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable bias: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 25;
            size_t prev_mean_j_1_max__ = n_i;
            size_t prev_mean_j_2_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < prev_mean_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < prev_mean_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(prev_mean(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: prev_mean" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable prev_mean: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 35;
            lp_accum__.add(std_normal_log<propto__>(delta));
            current_statement_begin__ = 36;
            lp_accum__.add(cauchy_log<propto__>(sigma_delta, 0, 2.5));
            current_statement_begin__ = 37;
            lp_accum__.add(cauchy_log<propto__>(tau_N, 0, 2.5));
            current_statement_begin__ = 38;
            lp_accum__.add(std_normal_log<propto__>(to_vector(eps)));
            current_statement_begin__ = 39;
            lp_accum__.add(normal_log<propto__>(beta_global, 0, 10));
            current_statement_begin__ = 40;
            lp_accum__.add(cauchy_log<propto__>(sigma_rho, 0, 2.5));
            current_statement_begin__ = 41;
            lp_accum__.add(normal_log<propto__>(mu_rho, 0, 10));
            current_statement_begin__ = 42;
            lp_accum__.add(normal_log<propto__>(rho, mu_rho, sigma_rho));
            current_statement_begin__ = 44;
            for (int k = 1; k <= n_k; ++k) {
                current_statement_begin__ = 45;
                lp_accum__.add(poisson_log<propto__>(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "y"), elt_multiply(stan::model::rvalue(prev_mean, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "prev_mean"), stan::model::rvalue(bias, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "bias"))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("delta");
        names__.push_back("sigma_delta");
        names__.push_back("eps");
        names__.push_back("beta_global");
        names__.push_back("tau_N");
        names__.push_back("rho");
        names__.push_back("mu_rho");
        names__.push_back("sigma_rho");
        names__.push_back("mu");
        names__.push_back("tau");
        names__.push_back("bias");
        names__.push_back("prev_mean");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_i);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_i);
        dims__.push_back(n_k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(z_global_size);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_i);
        dims__.push_back(n_k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_i);
        dims__.push_back(n_k);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_Uncorrelated_zglobal_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta = in__.vector_constrain(n_i);
        size_t delta_j_1_max__ = n_i;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            vars__.push_back(delta(j_1__));
        }
        double sigma_delta = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_delta);
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eps = in__.matrix_constrain(n_i, n_k);
        size_t eps_j_2_max__ = n_k;
        size_t eps_j_1_max__ = n_i;
        for (size_t j_2__ = 0; j_2__ < eps_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
                vars__.push_back(eps(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_global = in__.vector_constrain(z_global_size);
        size_t beta_global_j_1_max__ = z_global_size;
        for (size_t j_1__ = 0; j_1__ < beta_global_j_1_max__; ++j_1__) {
            vars__.push_back(beta_global(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_N = in__.vector_lb_constrain(0, n_k);
        size_t tau_N_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < tau_N_j_1_max__; ++j_1__) {
            vars__.push_back(tau_N(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho = in__.vector_constrain(n_k);
        size_t rho_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            vars__.push_back(rho(j_1__));
        }
        double mu_rho = in__.scalar_constrain();
        vars__.push_back(mu_rho);
        double sigma_rho = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_rho);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 22;
            validate_non_negative_index("mu", "n_k", n_k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n_k);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 23;
            validate_non_negative_index("tau", "n_k", n_k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tau(n_k);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            current_statement_begin__ = 24;
            validate_non_negative_index("bias", "n_i", n_i);
            validate_non_negative_index("bias", "n_k", n_k);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> bias(n_i, n_k);
            stan::math::initialize(bias, DUMMY_VAR__);
            stan::math::fill(bias, DUMMY_VAR__);
            current_statement_begin__ = 25;
            validate_non_negative_index("prev_mean", "n_i", n_i);
            validate_non_negative_index("prev_mean", "n_k", n_k);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> prev_mean(n_i, n_k);
            stan::math::initialize(prev_mean, DUMMY_VAR__);
            stan::math::fill(prev_mean, DUMMY_VAR__);
            stan::math::assign(prev_mean,stan::math::exp(add(transpose(rep_matrix(rho, n_i)), rep_matrix(add(multiply(sigma_delta, delta), multiply(z_global, beta_global)), n_k))));
            // do transformed parameters statements
            current_statement_begin__ = 27;
            stan::math::assign(mu, stan::math::log(elt_divide(1.0, stan::math::sqrt(add(1.0, elt_divide(1.0, square(tau_N)))))));
            current_statement_begin__ = 28;
            stan::math::assign(tau, stan::math::sqrt(stan::math::log(add(1.0, elt_divide(1.0, square(tau_N))))));
            current_statement_begin__ = 29;
            for (int k = 1; k <= n_k; ++k) {
                current_statement_begin__ = 30;
                stan::model::assign(bias, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                            stan::math::exp(add(get_base1(mu, k, "mu", 1), multiply(get_base1(tau, k, "tau", 1), stan::model::rvalue(eps, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "eps")))), 
                            "assigning variable bias");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t mu_j_1_max__ = n_k;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t tau_j_1_max__ = n_k;
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    vars__.push_back(tau(j_1__));
                }
                size_t bias_j_2_max__ = n_k;
                size_t bias_j_1_max__ = n_i;
                for (size_t j_2__ = 0; j_2__ < bias_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < bias_j_1_max__; ++j_1__) {
                        vars__.push_back(bias(j_1__, j_2__));
                    }
                }
                size_t prev_mean_j_2_max__ = n_k;
                size_t prev_mean_j_1_max__ = n_i;
                for (size_t j_2__ = 0; j_2__ < prev_mean_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < prev_mean_j_1_max__; ++j_1__) {
                        vars__.push_back(prev_mean(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_Uncorrelated_zglobal";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t delta_j_1_max__ = n_i;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_delta";
        param_names__.push_back(param_name_stream__.str());
        size_t eps_j_2_max__ = n_k;
        size_t eps_j_1_max__ = n_i;
        for (size_t j_2__ = 0; j_2__ < eps_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eps" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_global_j_1_max__ = z_global_size;
        for (size_t j_1__ = 0; j_1__ < beta_global_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_global" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_N_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < tau_N_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_N" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_rho";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t bias_j_2_max__ = n_k;
            size_t bias_j_1_max__ = n_i;
            for (size_t j_2__ = 0; j_2__ < bias_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < bias_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "bias" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t prev_mean_j_2_max__ = n_k;
            size_t prev_mean_j_1_max__ = n_i;
            for (size_t j_2__ = 0; j_2__ < prev_mean_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prev_mean_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "prev_mean" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t delta_j_1_max__ = n_i;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_delta";
        param_names__.push_back(param_name_stream__.str());
        size_t eps_j_2_max__ = n_k;
        size_t eps_j_1_max__ = n_i;
        for (size_t j_2__ = 0; j_2__ < eps_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eps" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_global_j_1_max__ = z_global_size;
        for (size_t j_1__ = 0; j_1__ < beta_global_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_global" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_N_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < tau_N_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_N" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_j_1_max__ = n_k;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_rho";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = n_k;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t bias_j_2_max__ = n_k;
            size_t bias_j_1_max__ = n_i;
            for (size_t j_2__ = 0; j_2__ < bias_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < bias_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "bias" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t prev_mean_j_2_max__ = n_k;
            size_t prev_mean_j_1_max__ = n_i;
            for (size_t j_2__ = 0; j_2__ < prev_mean_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prev_mean_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "prev_mean" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_Uncorrelated_zglobal_namespace::model_Uncorrelated_zglobal stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
