% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDSnet.R
\name{MDSnet}
\alias{MDSnet}
\title{MDSnet}
\usage{
MDSnet(qgraph_net, type = c("ordinal", "interval", "ratio", "mspline"),
  MDSadj = NULL, stressTxt = F, ...)
}
\arguments{
\item{qgraph_net}{an object of type \code{qgraph}}

\item{type}{transformation function for MDS, defaults to "ordinal"}

\item{MDSadj}{to use a proximities matrix other than the adjacency matrix
stored in \code{qgraph_net}, provide it in this argument}

\item{stressTxt}{logical. Print the stress value in the lower left corner of the plot?}

\item{...}{additional arguments passed to \code{smacof::mds}}
}
\description{
Convenience function for converting a qgraph object to a layout determined
by multidimensional scaling
}
\details{
A network plotted with multidimensional scaling can be interpreted based on the distances
between nodes. Nodes close together represent closely associated nodes, whereas nodes that are far
apart represent unassociated or negatively associated nodes.
}
\references{
Jones, P. J., Mair, P., & McNally, R. J. (2017). Scaling networks for two-dimensional visualization: a tutorial. Retrieved from osf.io/eugsz
}
