% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remake_img.R
\name{remake_img}
\alias{remake_img}
\title{Remake Image from Vector}
\usage{
remake_img(vec, img, mask = NULL, warn = FALSE, ...)
}
\arguments{
\item{vec}{vector of values to be in resulting image}

\item{img}{object of class \code{\link[oro.nifti]{nifti}} to put vector into}

\item{mask}{binary array/ \code{\link[oro.nifti]{nifti}} object to denote where
vector values are to be.}

\item{warn}{Should a warning be issued if defaulting to FLOAT32?}

\item{...}{additional arguments passed to \code{\link{datatyper}}}
}
\value{
Object of class \code{\link[oro.nifti]{nifti}}
}
\description{
Wrapper function to take a vector of values and result in a 
\code{\link[oro.nifti]{nifti}} object
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
remake_img(c(nim), nim)
mask = nim > 5
vals = nim[mask]
vals = sqrt(vals)
remake_img(vals, nim, mask = mask)

}
\seealso{
\code{\link{niftiarr}}
}
